/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.api.writer.AbstractCollectingResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.plugable.DeserializationDelegate;
import org.apache.flink.runtime.plugable.NonReusingDeserializationDelegate;
import org.apache.flink.util.Preconditions;

public class RecordOrEventCollectingResultPartitionWriter<T>
extends AbstractCollectingResultPartitionWriter {
    private final Collection<Object> output;
    private final NonReusingDeserializationDelegate<T> delegate;
    private final RecordDeserializer<DeserializationDelegate<T>> deserializer = new SpillingAdaptiveSpanningRecordDeserializer(new String[]{System.getProperty("java.io.tmpdir")});

    public RecordOrEventCollectingResultPartitionWriter(Collection<Object> output, BufferProvider bufferProvider, TypeSerializer<T> serializer) {
        super(bufferProvider);
        this.output = (Collection)Preconditions.checkNotNull(output);
        this.delegate = new NonReusingDeserializationDelegate((TypeSerializer)Preconditions.checkNotNull(serializer));
    }

    @Override
    protected void deserializeBuffer(Buffer buffer) throws IOException {
        if (buffer.isBuffer()) {
            this.deserializer.setNextBuffer(buffer);
            while (this.deserializer.hasUnfinishedData()) {
                RecordDeserializer.DeserializationResult result = this.deserializer.getNextRecord(this.delegate);
                if (result.isFullRecord()) {
                    this.output.add(this.delegate.getInstance());
                }
                if (result != RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER && result != RecordDeserializer.DeserializationResult.PARTIAL_RECORD) continue;
                break;
            }
        } else {
            AbstractEvent event = EventSerializer.fromBuffer((Buffer)buffer, (ClassLoader)this.getClass().getClassLoader());
            this.output.add(event);
        }
    }
}

