/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferReceivedListener;

class TestBufferReceivedListener
implements BufferReceivedListener {
    private final Map<InputChannelInfo, List<Buffer>> notifiedOnBuffers = new HashMap<InputChannelInfo, List<Buffer>>();
    final Map<InputChannelInfo, List<CheckpointBarrier>> notifiedOnBarriers = new HashMap<InputChannelInfo, List<CheckpointBarrier>>();

    TestBufferReceivedListener() {
    }

    public void notifyBufferReceived(Buffer buffer, InputChannelInfo channelInfo) {
        this.notifiedOnBuffers.computeIfAbsent(channelInfo, unused -> new ArrayList()).add(buffer);
    }

    public void notifyBarrierReceived(CheckpointBarrier barrier, InputChannelInfo channelInfo) {
        this.notifiedOnBarriers.computeIfAbsent(channelInfo, unused -> new ArrayList()).add(barrier);
    }
}

