/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.AbstractID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CoLocationConstraintTest {
    @Test
    public void testCreateConstraints() {
        JobVertexID id1 = new JobVertexID();
        JobVertexID id2 = new JobVertexID();
        JobVertex vertex1 = new JobVertex("vertex1", id1);
        vertex1.setParallelism(2);
        JobVertex vertex2 = new JobVertex("vertex2", id2);
        vertex2.setParallelism(3);
        CoLocationGroup group = new CoLocationGroup(new JobVertex[]{vertex1, vertex2});
        AbstractID groupId = group.getId();
        Assert.assertNotNull((Object)groupId);
        CoLocationConstraint constraint1 = group.getLocationConstraint(0);
        CoLocationConstraint constraint2 = group.getLocationConstraint(1);
        CoLocationConstraint constraint3 = group.getLocationConstraint(2);
        Assert.assertFalse((constraint1 == constraint2 ? 1 : 0) != 0);
        Assert.assertFalse((constraint1 == constraint3 ? 1 : 0) != 0);
        Assert.assertFalse((constraint2 == constraint3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)groupId, (Object)constraint1.getGroupId());
        Assert.assertEquals((Object)groupId, (Object)constraint2.getGroupId());
        Assert.assertEquals((Object)groupId, (Object)constraint3.getGroupId());
    }

    @Test
    public void testLockLocation() {
        JobVertex vertex = new JobVertex("vertex");
        vertex.setParallelism(1);
        CoLocationGroup constraintGroup = new CoLocationGroup(new JobVertex[]{vertex});
        CoLocationConstraint constraint = constraintGroup.getLocationConstraint(0);
        Assert.assertThat((Object)constraint.getSlotRequestId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)constraint.isAssigned(), (Matcher)CoreMatchers.is((Object)false));
        SlotRequestId slotRequestId = new SlotRequestId();
        constraint.setSlotRequestId(slotRequestId);
        Assert.assertThat((Object)constraint.isAssigned(), (Matcher)CoreMatchers.is((Object)false));
        try {
            constraint.getLocation();
            Assert.fail((String)"should throw an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            Assert.fail((String)"wrong exception, should be IllegalStateException");
        }
        LocalTaskManagerLocation location = new LocalTaskManagerLocation();
        constraint.lockLocation((TaskManagerLocation)location);
        Assert.assertThat((Object)constraint.isAssigned(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)constraint.getLocation(), (Matcher)CoreMatchers.is((Object)((Object)location)));
        try {
            LocalTaskManagerLocation anotherLocation = new LocalTaskManagerLocation();
            constraint.lockLocation((TaskManagerLocation)anotherLocation);
            Assert.fail((String)"should throw an IllegalStateException");
        }
        catch (IllegalStateException anotherLocation) {
        }
        catch (Exception e) {
            Assert.fail((String)"wrong exception, should be IllegalStateException");
        }
        constraint.setSlotRequestId(null);
        Assert.assertThat((Object)constraint.isAssigned(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)constraint.getLocation(), (Matcher)CoreMatchers.is((Object)((Object)location)));
    }
}

