/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.scheduler.SchedulerTestBase;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.junit.Assert;
import org.junit.Test;

public class ScheduleWithCoLocationHintTest
extends SchedulerTestBase {
    @Override
    protected ComponentMainThreadExecutor getComponentMainThreadExecutor() {
        return ComponentMainThreadExecutorServiceAdapter.forMainThread();
    }

    @Test
    public void scheduleAllSharedAndCoLocated() throws Exception {
        JobVertexID jid1 = new JobVertexID();
        JobVertexID jid2 = new JobVertexID();
        this.testingSlotProvider.addTaskManager(2);
        this.testingSlotProvider.addTaskManager(2);
        this.testingSlotProvider.addTaskManager(2);
        Assert.assertEquals((long)6L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        CoLocationGroup ccg = new CoLocationGroup();
        CoLocationConstraint c1 = new CoLocationConstraint(ccg);
        CoLocationConstraint c2 = new CoLocationConstraint(ccg);
        CoLocationConstraint c3 = new CoLocationConstraint(ccg);
        CoLocationConstraint c4 = new CoLocationConstraint(ccg);
        CoLocationConstraint c5 = new CoLocationConstraint(ccg);
        CoLocationConstraint c6 = new CoLocationConstraint(ccg);
        LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 0, 6, sharingGroup), sharingGroup.getSlotSharingGroupId(), c1), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 1, 6, sharingGroup), sharingGroup.getSlotSharingGroupId(), c2), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 2, 6, sharingGroup), sharingGroup.getSlotSharingGroupId(), c3), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 3, 6, sharingGroup), sharingGroup.getSlotSharingGroupId(), c4), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s5 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 0, 6, sharingGroup), sharingGroup.getSlotSharingGroupId(), c1), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s6 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 1, 6, sharingGroup), sharingGroup.getSlotSharingGroupId(), c2), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s7 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 2, 6, sharingGroup), sharingGroup.getSlotSharingGroupId(), c3), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s8 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 4, 6, sharingGroup), sharingGroup.getSlotSharingGroupId(), c5), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s9 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 5, 6, sharingGroup), sharingGroup.getSlotSharingGroupId(), c6), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s10 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 3, 6, sharingGroup), sharingGroup.getSlotSharingGroupId(), c4), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s11 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 4, 6, sharingGroup), sharingGroup.getSlotSharingGroupId(), c5), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s12 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 5, 6, sharingGroup), sharingGroup.getSlotSharingGroupId(), c6), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        Assert.assertNotNull((Object)s1);
        Assert.assertNotNull((Object)s2);
        Assert.assertNotNull((Object)s3);
        Assert.assertNotNull((Object)s4);
        Assert.assertNotNull((Object)s5);
        Assert.assertNotNull((Object)s6);
        Assert.assertNotNull((Object)s7);
        Assert.assertNotNull((Object)s8);
        Assert.assertNotNull((Object)s9);
        Assert.assertNotNull((Object)s10);
        Assert.assertNotNull((Object)s11);
        Assert.assertNotNull((Object)s12);
        Assert.assertEquals((Object)s1.getTaskManagerLocation(), (Object)s5.getTaskManagerLocation());
        Assert.assertEquals((Object)s2.getTaskManagerLocation(), (Object)s6.getTaskManagerLocation());
        Assert.assertEquals((Object)s3.getTaskManagerLocation(), (Object)s7.getTaskManagerLocation());
        Assert.assertEquals((Object)s4.getTaskManagerLocation(), (Object)s10.getTaskManagerLocation());
        Assert.assertEquals((Object)s8.getTaskManagerLocation(), (Object)s11.getTaskManagerLocation());
        Assert.assertEquals((Object)s9.getTaskManagerLocation(), (Object)s12.getTaskManagerLocation());
        Assert.assertEquals((Object)c1.getLocation(), (Object)s1.getTaskManagerLocation());
        Assert.assertEquals((Object)c2.getLocation(), (Object)s2.getTaskManagerLocation());
        Assert.assertEquals((Object)c3.getLocation(), (Object)s3.getTaskManagerLocation());
        Assert.assertEquals((Object)c4.getLocation(), (Object)s4.getTaskManagerLocation());
        Assert.assertEquals((Object)c5.getLocation(), (Object)s8.getTaskManagerLocation());
        Assert.assertEquals((Object)c6.getLocation(), (Object)s9.getTaskManagerLocation());
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        Assert.assertEquals((long)6L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
        Assert.assertEquals((long)6L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
        s1.releaseSlot();
        s2.releaseSlot();
        s3.releaseSlot();
        s4.releaseSlot();
        s7.releaseSlot();
        s10.releaseSlot();
        s11.releaseSlot();
        s12.releaseSlot();
        Assert.assertTrue((this.testingSlotProvider.getNumberOfAvailableSlots() >= 1 ? 1 : 0) != 0);
        LogicalSlot single = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(new JobVertexID(), 0, 1, null)), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        Assert.assertNotNull((Object)single);
        s1.releaseSlot();
        s2.releaseSlot();
        s3.releaseSlot();
        s5.releaseSlot();
        s6.releaseSlot();
        s7.releaseSlot();
        s8.releaseSlot();
        s9.releaseSlot();
        s11.releaseSlot();
        s12.releaseSlot();
        Assert.assertEquals((long)5L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        Assert.assertEquals((long)6L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
        Assert.assertEquals((long)7L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
    }

    @Test
    public void scheduleWithIntermediateRelease() throws Exception {
        JobVertexID jid1 = new JobVertexID();
        JobVertexID jid2 = new JobVertexID();
        JobVertexID jid3 = new JobVertexID();
        JobVertexID jid4 = new JobVertexID();
        this.testingSlotProvider.addTaskManager(1);
        this.testingSlotProvider.addTaskManager(1);
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        CoLocationConstraint c1 = new CoLocationConstraint(new CoLocationGroup());
        LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 0, 1, sharingGroup), sharingGroup.getSlotSharingGroupId(), c1), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 0, 1, sharingGroup), sharingGroup.getSlotSharingGroupId(), c1), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot sSolo = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid4, 0, 1, null)), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        ResourceID taskManager = s1.getTaskManagerLocation().getResourceID();
        s1.releaseSlot();
        s2.releaseSlot();
        sSolo.releaseSlot();
        LogicalSlot sNew = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid3, 0, 1, sharingGroup), sharingGroup.getSlotSharingGroupId(), c1), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        Assert.assertEquals((Object)taskManager, (Object)sNew.getTaskManagerLocation().getResourceID());
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
    }

    @Test
    public void scheduleWithReleaseNoResource() throws Exception {
        JobVertexID jid1 = new JobVertexID();
        JobVertexID jid2 = new JobVertexID();
        JobVertexID jid3 = new JobVertexID();
        this.testingSlotProvider.addTaskManager(1);
        this.testingSlotProvider.addTaskManager(1);
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        CoLocationConstraint c1 = new CoLocationConstraint(new CoLocationGroup());
        LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 0, 1, sharingGroup), sharingGroup.getSlotSharingGroupId(), c1), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        s1.releaseSlot();
        this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 0, 1, null)), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 1, 2, null)), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        try {
            this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid3, 0, 1, sharingGroup), sharingGroup.getSlotSharingGroupId(), c1), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
            Assert.fail((String)"Scheduled even though no resource was available.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof NoResourceAvailableException));
        }
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
        Assert.assertEquals((long)3L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
    }

    @Test
    public void scheduleMixedCoLocationSlotSharing() throws Exception {
        JobVertexID jid1 = new JobVertexID();
        JobVertexID jid2 = new JobVertexID();
        JobVertexID jid3 = new JobVertexID();
        JobVertexID jid4 = new JobVertexID();
        this.testingSlotProvider.addTaskManager(1);
        this.testingSlotProvider.addTaskManager(1);
        this.testingSlotProvider.addTaskManager(1);
        this.testingSlotProvider.addTaskManager(1);
        Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        CoLocationGroup grp = new CoLocationGroup();
        CoLocationConstraint clc1 = new CoLocationConstraint(grp);
        CoLocationConstraint clc2 = new CoLocationConstraint(grp);
        CoLocationConstraint clc3 = new CoLocationConstraint(grp);
        CoLocationConstraint clc4 = new CoLocationConstraint(grp);
        SlotSharingGroup shareGroup = new SlotSharingGroup();
        this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 0, 4, shareGroup), shareGroup.getSlotSharingGroupId()), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 2, 4, shareGroup), shareGroup.getSlotSharingGroupId()), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 1, 4, shareGroup), shareGroup.getSlotSharingGroupId()), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 3, 4, shareGroup), shareGroup.getSlotSharingGroupId()), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s21 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 0, 4, shareGroup), shareGroup.getSlotSharingGroupId(), clc1), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s22 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 2, 4, shareGroup), shareGroup.getSlotSharingGroupId(), clc2), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s23 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 1, 4, shareGroup), shareGroup.getSlotSharingGroupId(), clc3), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s24 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 3, 4, shareGroup), shareGroup.getSlotSharingGroupId(), clc4), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s31 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid3, 1, 4, shareGroup), shareGroup.getSlotSharingGroupId(), clc2), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s32 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid3, 2, 4, shareGroup), shareGroup.getSlotSharingGroupId(), clc3), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s33 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid3, 3, 4, shareGroup), shareGroup.getSlotSharingGroupId(), clc4), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot s34 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid3, 0, 4, shareGroup), shareGroup.getSlotSharingGroupId(), clc1), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid4, 0, 4, shareGroup), shareGroup.getSlotSharingGroupId()), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid4, 1, 4, shareGroup), shareGroup.getSlotSharingGroupId()), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid4, 2, 4, shareGroup), shareGroup.getSlotSharingGroupId()), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid4, 3, 4, shareGroup), shareGroup.getSlotSharingGroupId()), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        Assert.assertEquals((Object)s21.getTaskManagerLocation(), (Object)s34.getTaskManagerLocation());
        Assert.assertEquals((Object)s22.getTaskManagerLocation(), (Object)s31.getTaskManagerLocation());
        Assert.assertEquals((Object)s23.getTaskManagerLocation(), (Object)s32.getTaskManagerLocation());
        Assert.assertEquals((Object)s24.getTaskManagerLocation(), (Object)s33.getTaskManagerLocation());
        Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
        Assert.assertEquals((long)12L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
    }

    @Test
    public void testGetsNonLocalFromSharingGroupFirst() throws Exception {
        JobVertexID jid1 = new JobVertexID();
        JobVertexID jid2 = new JobVertexID();
        JobVertexID jid3 = new JobVertexID();
        TaskManagerLocation loc1 = this.testingSlotProvider.addTaskManager(1);
        TaskManagerLocation loc2 = this.testingSlotProvider.addTaskManager(1);
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        CoLocationGroup ccg = new CoLocationGroup();
        CoLocationConstraint cc1 = new CoLocationConstraint(ccg);
        CoLocationConstraint cc2 = new CoLocationConstraint(ccg);
        LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 0, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId()), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
        LogicalSlot s2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 1, 2, sharingGroup, loc2), sharingGroup.getSlotSharingGroupId()), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc2), TestingUtils.infiniteTime()).get();
        LogicalSlot s3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 0, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId(), cc1), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
        LogicalSlot s4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 1, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId(), cc2), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
        LogicalSlot s5 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid3, 0, 2, sharingGroup, loc2), sharingGroup.getSlotSharingGroupId(), cc1), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc2), TestingUtils.infiniteTime()).get();
        LogicalSlot s6 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid3, 1, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId(), cc2), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
        Assert.assertEquals((Object)s1.getTaskManagerLocation(), (Object)s3.getTaskManagerLocation());
        Assert.assertEquals((Object)s2.getTaskManagerLocation(), (Object)s4.getTaskManagerLocation());
        Assert.assertEquals((Object)s1.getTaskManagerLocation(), (Object)s5.getTaskManagerLocation());
        Assert.assertEquals((Object)s2.getTaskManagerLocation(), (Object)s6.getTaskManagerLocation());
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        Assert.assertEquals((long)5L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
        Assert.assertTrue((1 == this.testingSlotProvider.getNumberOfNonLocalizedAssignments() || 1 == this.testingSlotProvider.getNumberOfHostLocalizedAssignments() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
        s1.releaseSlot();
        s2.releaseSlot();
        s3.releaseSlot();
        s4.releaseSlot();
        s5.releaseSlot();
        s6.releaseSlot();
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
    }

    @Test
    public void testSlotReleasedInBetween() throws Exception {
        JobVertexID jid1 = new JobVertexID();
        JobVertexID jid2 = new JobVertexID();
        TaskManagerLocation loc1 = this.testingSlotProvider.addTaskManager(1);
        TaskManagerLocation loc2 = this.testingSlotProvider.addTaskManager(1);
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        CoLocationGroup ccg = new CoLocationGroup();
        CoLocationConstraint cc1 = new CoLocationConstraint(ccg);
        CoLocationConstraint cc2 = new CoLocationConstraint(ccg);
        LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 0, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId(), cc1), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
        LogicalSlot s2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 1, 2, sharingGroup, loc2), sharingGroup.getSlotSharingGroupId(), cc2), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc2), TestingUtils.infiniteTime()).get();
        s1.releaseSlot();
        s2.releaseSlot();
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        LogicalSlot s3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 0, 2, sharingGroup, loc2), sharingGroup.getSlotSharingGroupId(), cc1), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc2), TestingUtils.infiniteTime()).get();
        LogicalSlot s4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 1, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId(), cc2), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
        Assert.assertEquals((Object)loc1, (Object)s3.getTaskManagerLocation());
        Assert.assertEquals((Object)loc2, (Object)s4.getTaskManagerLocation());
        s3.releaseSlot();
        s4.releaseSlot();
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        Assert.assertEquals((long)4L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
    }

    @Test
    public void testSlotReleasedInBetweenAndNoNewLocal() throws Exception {
        JobVertexID jid1 = new JobVertexID();
        JobVertexID jid2 = new JobVertexID();
        JobVertexID jidx = new JobVertexID();
        TaskManagerLocation loc1 = this.testingSlotProvider.addTaskManager(1);
        TaskManagerLocation loc2 = this.testingSlotProvider.addTaskManager(1);
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        CoLocationGroup ccg = new CoLocationGroup();
        CoLocationConstraint cc1 = new CoLocationConstraint(ccg);
        CoLocationConstraint cc2 = new CoLocationConstraint(ccg);
        LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 0, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId(), cc1), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
        LogicalSlot s2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 1, 2, sharingGroup, loc2), sharingGroup.getSlotSharingGroupId(), cc2), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc2), TestingUtils.infiniteTime()).get();
        s1.releaseSlot();
        s2.releaseSlot();
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        LogicalSlot sa = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jidx, 0, 2, null)), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        LogicalSlot sb = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jidx, 1, 2, null)), SlotProfile.noRequirements(), TestingUtils.infiniteTime()).get();
        try {
            this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 0, 2, sharingGroup, loc2), sharingGroup.getSlotSharingGroupId(), cc1), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc2), TestingUtils.infiniteTime()).get();
            Assert.fail((String)"should not be able to find a resource");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof NoResourceAvailableException));
        }
        catch (Exception e) {
            Assert.fail((String)"wrong exception");
        }
        sa.releaseSlot();
        sb.releaseSlot();
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfNonLocalizedAssignments());
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
    }

    @Test
    public void testScheduleOutOfOrder() throws Exception {
        JobVertexID jid1 = new JobVertexID();
        JobVertexID jid2 = new JobVertexID();
        TaskManagerLocation loc1 = this.testingSlotProvider.addTaskManager(1);
        this.testingSlotProvider.addTaskManager(1);
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        CoLocationGroup ccg = new CoLocationGroup();
        CoLocationConstraint cc1 = new CoLocationConstraint(ccg);
        CoLocationConstraint cc2 = new CoLocationConstraint(ccg);
        LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 0, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId(), cc1), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
        LogicalSlot s2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 0, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId(), cc2), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
        LogicalSlot s3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 1, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId(), cc1), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
        LogicalSlot s4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 1, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId(), cc2), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
        Assert.assertEquals((Object)s1.getTaskManagerLocation(), (Object)s3.getTaskManagerLocation());
        Assert.assertEquals((Object)s2.getTaskManagerLocation(), (Object)s4.getTaskManagerLocation());
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        Assert.assertEquals((long)3L, (long)this.testingSlotProvider.getNumberOfLocalizedAssignments());
        Assert.assertTrue((1 == this.testingSlotProvider.getNumberOfNonLocalizedAssignments() || 1 == this.testingSlotProvider.getNumberOfHostLocalizedAssignments() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.testingSlotProvider.getNumberOfUnconstrainedAssignments());
        s1.releaseSlot();
        s2.releaseSlot();
        s3.releaseSlot();
        s4.releaseSlot();
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
    }

    @Test
    public void nonColocationFollowsCoLocation() throws Exception {
        JobVertexID jid1 = new JobVertexID();
        JobVertexID jid2 = new JobVertexID();
        TaskManagerLocation loc1 = this.testingSlotProvider.addTaskManager(1);
        TaskManagerLocation loc2 = this.testingSlotProvider.addTaskManager(1);
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        CoLocationGroup ccg = new CoLocationGroup();
        CoLocationConstraint cc1 = new CoLocationConstraint(ccg);
        CoLocationConstraint cc2 = new CoLocationConstraint(ccg);
        LogicalSlot s1 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 0, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId(), cc1), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
        LogicalSlot s2 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid1, 1, 2, sharingGroup, loc2), sharingGroup.getSlotSharingGroupId(), cc2), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc2), TestingUtils.infiniteTime()).get();
        LogicalSlot s3 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 0, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId()), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
        LogicalSlot s4 = (LogicalSlot)this.testingSlotProvider.allocateSlot(new ScheduledUnit(ExecutionGraphTestUtils.getExecution(jid2, 1, 2, sharingGroup, loc1), sharingGroup.getSlotSharingGroupId()), ScheduleWithCoLocationHintTest.slotProfileForLocation(loc1), TestingUtils.infiniteTime()).get();
        Assert.assertEquals((Object)s1.getTaskManagerLocation(), (Object)s3.getTaskManagerLocation());
        Assert.assertEquals((Object)s2.getTaskManagerLocation(), (Object)s4.getTaskManagerLocation());
        s1.releaseSlot();
        s2.releaseSlot();
        s3.releaseSlot();
        s4.releaseSlot();
        Assert.assertEquals((long)2L, (long)this.testingSlotProvider.getNumberOfAvailableSlots());
    }

    private static SlotProfile slotProfileForLocation(TaskManagerLocation location) {
        return SlotProfile.preferredLocality((ResourceProfile)ResourceProfile.UNKNOWN, Collections.singletonList(location));
    }
}

