/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.PreviousAllocationSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolImpl;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolResource;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class SlotPoolCoLocationTest
extends TestLogger {
    @Rule
    public final SlotPoolResource slotPoolResource = new SlotPoolResource((SlotSelectionStrategy)PreviousAllocationSlotSelectionStrategy.create());

    @Test
    public void testSimpleCoLocatedSlotScheduling() throws ExecutionException, InterruptedException {
        ArrayBlockingQueue allocationIds = new ArrayBlockingQueue(2);
        TestingResourceManagerGateway testingResourceManagerGateway = this.slotPoolResource.getTestingResourceManagerGateway();
        testingResourceManagerGateway.setRequestSlotConsumer(slotRequest -> allocationIds.offer(slotRequest.getAllocationId()));
        LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
        SlotPoolImpl slotPoolGateway = this.slotPoolResource.getSlotPool();
        slotPoolGateway.registerTaskManager(taskManagerLocation.getResourceID());
        CoLocationGroup group = new CoLocationGroup();
        CoLocationConstraint coLocationConstraint1 = group.getLocationConstraint(0);
        CoLocationConstraint coLocationConstraint2 = group.getLocationConstraint(1);
        SlotSharingGroupId slotSharingGroupId = new SlotSharingGroupId();
        JobVertexID jobVertexId1 = new JobVertexID();
        JobVertexID jobVertexId2 = new JobVertexID();
        SlotProvider slotProvider = this.slotPoolResource.getSlotProvider();
        CompletableFuture logicalSlotFuture11 = slotProvider.allocateSlot(new ScheduledUnit(jobVertexId1, slotSharingGroupId, coLocationConstraint1), SlotProfile.noRequirements(), TestingUtils.infiniteTime());
        CompletableFuture logicalSlotFuture22 = slotProvider.allocateSlot(new ScheduledUnit(jobVertexId2, slotSharingGroupId, coLocationConstraint2), SlotProfile.noRequirements(), TestingUtils.infiniteTime());
        CompletableFuture logicalSlotFuture12 = slotProvider.allocateSlot(new ScheduledUnit(jobVertexId2, slotSharingGroupId, coLocationConstraint1), SlotProfile.noRequirements(), TestingUtils.infiniteTime());
        CompletableFuture logicalSlotFuture21 = slotProvider.allocateSlot(new ScheduledUnit(jobVertexId1, slotSharingGroupId, coLocationConstraint2), SlotProfile.noRequirements(), TestingUtils.infiniteTime());
        AllocationID allocationId1 = (AllocationID)allocationIds.take();
        AllocationID allocationId2 = (AllocationID)allocationIds.take();
        Collection slotOfferFuture1 = slotPoolGateway.offerSlots((TaskManagerLocation)taskManagerLocation, (TaskManagerGateway)new SimpleAckingTaskManagerGateway(), Collections.singletonList(new SlotOffer(allocationId1, 0, ResourceProfile.ANY)));
        Collection slotOfferFuture2 = slotPoolGateway.offerSlots((TaskManagerLocation)taskManagerLocation, (TaskManagerGateway)new SimpleAckingTaskManagerGateway(), Collections.singletonList(new SlotOffer(allocationId2, 0, ResourceProfile.ANY)));
        Assert.assertFalse((boolean)slotOfferFuture1.isEmpty());
        Assert.assertFalse((boolean)slotOfferFuture2.isEmpty());
        LogicalSlot logicalSlot11 = (LogicalSlot)logicalSlotFuture11.get();
        LogicalSlot logicalSlot12 = (LogicalSlot)logicalSlotFuture12.get();
        LogicalSlot logicalSlot21 = (LogicalSlot)logicalSlotFuture21.get();
        LogicalSlot logicalSlot22 = (LogicalSlot)logicalSlotFuture22.get();
        Assert.assertEquals((Object)logicalSlot11.getAllocationId(), (Object)logicalSlot12.getAllocationId());
        Assert.assertEquals((Object)logicalSlot21.getAllocationId(), (Object)logicalSlot22.getAllocationId());
        Assert.assertNotEquals((Object)logicalSlot11.getAllocationId(), (Object)logicalSlot21.getAllocationId());
    }
}

