/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.slotpool.Scheduler;
import org.apache.flink.runtime.jobmaster.slotpool.SchedulerImpl;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolImpl;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.TestingSlotPoolImpl;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.junit.rules.ExternalResource;

public class SlotPoolResource
extends ExternalResource {
    @Nonnull
    private final SlotSelectionStrategy schedulingStrategy;
    private SlotPoolImpl slotPool;
    private Scheduler scheduler;
    private TestingResourceManagerGateway testingResourceManagerGateway;
    private final ComponentMainThreadExecutor mainThreadExecutor;

    public SlotPoolResource(@Nonnull SlotSelectionStrategy schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
        this.mainThreadExecutor = ComponentMainThreadExecutorServiceAdapter.forMainThread();
        this.slotPool = null;
        this.testingResourceManagerGateway = null;
    }

    public SlotProvider getSlotProvider() {
        this.checkInitialized();
        return this.scheduler;
    }

    public TestingResourceManagerGateway getTestingResourceManagerGateway() {
        this.checkInitialized();
        return this.testingResourceManagerGateway;
    }

    public SlotPoolImpl getSlotPool() {
        this.checkInitialized();
        return this.slotPool;
    }

    private void checkInitialized() {
        assert (this.slotPool != null);
    }

    protected void before() throws Throwable {
        if (this.slotPool != null) {
            this.terminateSlotPool();
        }
        this.testingResourceManagerGateway = new TestingResourceManagerGateway();
        this.slotPool = new TestingSlotPoolImpl(new JobID());
        this.scheduler = new SchedulerImpl(this.schedulingStrategy, (SlotPool)this.slotPool);
        this.slotPool.start(JobMasterId.generate(), "foobar", this.mainThreadExecutor);
        this.scheduler.start(this.mainThreadExecutor);
        this.slotPool.connectToResourceManager((ResourceManagerGateway)this.testingResourceManagerGateway);
    }

    protected void after() {
        if (this.slotPool != null) {
            this.terminateSlotPool();
            this.slotPool = null;
        }
    }

    private void terminateSlotPool() {
        this.slotPool.close();
    }
}

