/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolImpl;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.util.FlinkException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class SlotPoolUtils {
    private SlotPoolUtils() {
        throw new UnsupportedOperationException("Cannot instantiate this class.");
    }

    public static CompletableFuture<PhysicalSlot> requestNewAllocatedBatchSlot(SlotPool slotPool, ComponentMainThreadExecutor mainThreadExecutor, ResourceProfile resourceProfile) {
        return CompletableFuture.supplyAsync(() -> slotPool.requestNewAllocatedBatchSlot(new SlotRequestId(), resourceProfile), (Executor)mainThreadExecutor).thenCompose(Function.identity());
    }

    public static ResourceID offerSlots(SlotPoolImpl slotPool, ComponentMainThreadExecutor mainThreadExecutor, List<ResourceProfile> resourceProfiles) {
        return SlotPoolUtils.offerSlots(slotPool, mainThreadExecutor, resourceProfiles, new SimpleAckingTaskManagerGateway());
    }

    public static ResourceID offerSlots(SlotPoolImpl slotPool, ComponentMainThreadExecutor mainThreadExecutor, List<ResourceProfile> resourceProfiles, TaskManagerGateway taskManagerGateway) {
        LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
        CompletableFuture.runAsync(() -> {
            slotPool.registerTaskManager(taskManagerLocation.getResourceID());
            Collection slotOffers = IntStream.range(0, resourceProfiles.size()).mapToObj(i -> new SlotOffer(new AllocationID(), i, (ResourceProfile)resourceProfiles.get(i))).collect(Collectors.toList());
            Collection acceptedOffers = slotPool.offerSlots(taskManagerLocation, taskManagerGateway, slotOffers);
            MatcherAssert.assertThat((Object)acceptedOffers, (Matcher)Matchers.is((Object)slotOffers));
        }, (Executor)mainThreadExecutor).join();
        return taskManagerLocation.getResourceID();
    }

    public static void failAllocation(SlotPoolImpl slotPool, ComponentMainThreadExecutor mainThreadExecutor, AllocationID allocationId, Exception exception) {
        CompletableFuture.runAsync(() -> slotPool.failAllocation(allocationId, exception), (Executor)mainThreadExecutor).join();
    }

    public static void releaseTaskManager(SlotPoolImpl slotPool, ComponentMainThreadExecutor mainThreadExecutor, ResourceID taskManagerResourceId) {
        CompletableFuture.runAsync(() -> slotPool.releaseTaskManager(taskManagerResourceId, (Exception)new FlinkException("Let's get rid of the offered slot.")), (Executor)mainThreadExecutor).join();
    }
}

