/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolImpl;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class TestingSlotPoolImpl
extends SlotPoolImpl {
    private ResourceProfile lastRequestedSlotResourceProfile;

    public TestingSlotPoolImpl(JobID jobId) {
        this(jobId, (Clock)SystemClock.getInstance(), AkkaUtils.getDefaultTimeout(), AkkaUtils.getDefaultTimeout(), Time.milliseconds((long)((Long)JobManagerOptions.SLOT_IDLE_TIMEOUT.defaultValue())));
    }

    public TestingSlotPoolImpl(JobID jobId, Clock clock, Time rpcTimeout, Time idleSlotTimeout, Time batchSlotTimeout) {
        super(jobId, clock, rpcTimeout, idleSlotTimeout, batchSlotTimeout);
    }

    void triggerCheckIdleSlot() {
        this.runAsync(() -> ((TestingSlotPoolImpl)this).checkIdleSlot());
    }

    void triggerCheckBatchSlotTimeout() {
        this.runAsync(() -> ((TestingSlotPoolImpl)this).checkBatchSlotTimeout());
    }

    public CompletableFuture<PhysicalSlot> requestNewAllocatedSlot(SlotRequestId slotRequestId, ResourceProfile resourceProfile, Time timeout) {
        this.lastRequestedSlotResourceProfile = resourceProfile;
        return super.requestNewAllocatedSlot(slotRequestId, resourceProfile, timeout);
    }

    public ResourceProfile getLastRequestedSlotResourceProfile() {
        return this.lastRequestedSlotResourceProfile;
    }
}

