/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingContender
implements LeaderContender {
    private static final Logger LOG = LoggerFactory.getLogger(TestingContender.class);
    private final String address;
    private final LeaderElectionService leaderElectionService;
    private UUID leaderSessionID = null;
    private boolean leader = false;
    private Throwable error = null;
    private Object lock = new Object();
    private Object errorLock = new Object();

    public TestingContender(String address, LeaderElectionService leaderElectionService) {
        this.address = address;
        this.leaderElectionService = leaderElectionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLeader(long timeout) throws TimeoutException {
        long curTimeout;
        long start = System.currentTimeMillis();
        while (!this.isLeader() && (curTimeout = timeout - System.currentTimeMillis() + start) > 0L) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(curTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!this.isLeader()) {
            throw new TimeoutException("Contender was not elected as the leader within " + timeout + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForError(long timeout) throws TimeoutException {
        long curTimeout;
        long start = System.currentTimeMillis();
        while (this.error == null && (curTimeout = timeout - System.currentTimeMillis() + start) > 0L) {
            Object object = this.errorLock;
            synchronized (object) {
                try {
                    this.errorLock.wait(curTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.error == null) {
            throw new TimeoutException("Contender did not see an exception in " + timeout + "ms");
        }
    }

    public UUID getLeaderSessionID() {
        return this.leaderSessionID;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isLeader() {
        return this.leader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantLeadership(UUID leaderSessionID) {
        Object object = this.lock;
        synchronized (object) {
            LOG.debug("Was granted leadership with session ID {}.", (Object)leaderSessionID);
            this.leaderSessionID = leaderSessionID;
            this.leaderElectionService.confirmLeadership(leaderSessionID, this.address);
            this.leader = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeLeadership() {
        Object object = this.lock;
        synchronized (object) {
            LOG.debug("Was revoked leadership. Old session ID {}.", (Object)this.leaderSessionID);
            this.leader = false;
            this.leaderSessionID = null;
            this.lock.notifyAll();
        }
    }

    public String getDescription() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(Exception exception) {
        Object object = this.errorLock;
        synchronized (object) {
            this.error = exception;
            this.errorLock.notifyAll();
        }
    }
}

