/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.operators.coordination.TaskNotRunningException;
import org.apache.flink.util.FlinkRuntimeException;

public class MockOperatorCoordinatorContext
implements OperatorCoordinator.Context {
    private final OperatorID operatorID;
    private final ClassLoader userCodeClassLoader;
    private final int numSubtasks;
    private final boolean failEventSending;
    private final Map<Integer, List<OperatorEvent>> eventsToOperator;
    private boolean jobFailed;
    private Throwable jobFailureReason;

    public MockOperatorCoordinatorContext(OperatorID operatorID, int numSubtasks) {
        this(operatorID, numSubtasks, true);
    }

    public MockOperatorCoordinatorContext(OperatorID operatorID, int numSubtasks, boolean failEventSending) {
        this(operatorID, numSubtasks, failEventSending, MockOperatorCoordinatorContext.class.getClassLoader());
    }

    public MockOperatorCoordinatorContext(OperatorID operatorID, ClassLoader userCodeClassLoader) {
        this(operatorID, 1, true, userCodeClassLoader);
    }

    public MockOperatorCoordinatorContext(OperatorID operatorID, int numSubtasks, boolean failEventSending, ClassLoader userCodeClassLoader) {
        this.operatorID = operatorID;
        this.numSubtasks = numSubtasks;
        this.eventsToOperator = new HashMap<Integer, List<OperatorEvent>>();
        this.jobFailed = false;
        this.jobFailureReason = null;
        this.failEventSending = failEventSending;
        this.userCodeClassLoader = userCodeClassLoader;
    }

    public OperatorID getOperatorId() {
        return this.operatorID;
    }

    public CompletableFuture<Acknowledge> sendEvent(OperatorEvent evt, int targetSubtask) throws TaskNotRunningException {
        this.eventsToOperator.computeIfAbsent(targetSubtask, subtaskId -> new ArrayList()).add(evt);
        if (this.failEventSending) {
            CompletableFuture<Acknowledge> future = new CompletableFuture<Acknowledge>();
            future.completeExceptionally(new FlinkRuntimeException("Testing Exception to fail event sending."));
            return future;
        }
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public void failJob(Throwable cause) {
        this.jobFailed = true;
        this.jobFailureReason = cause;
    }

    public int currentParallelism() {
        return this.numSubtasks;
    }

    public ClassLoader getUserCodeClassloader() {
        return this.userCodeClassLoader;
    }

    public List<OperatorEvent> getEventsToOperatorBySubtaskId(int subtaskId) {
        return this.eventsToOperator.get(subtaskId);
    }

    public Map<Integer, List<OperatorEvent>> getEventsToOperator() {
        return this.eventsToOperator;
    }

    public boolean isJobFailed() {
        return this.jobFailed;
    }

    public Throwable getJobFailureReason() {
        return this.jobFailureReason;
    }
}

