/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionConfigBuilder;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public class ArchivedExecutionGraphBuilder {
    private static final Random RANDOM = new Random();
    private JobID jobID;
    private String jobName;
    private Map<JobVertexID, ArchivedExecutionJobVertex> tasks;
    private List<ArchivedExecutionJobVertex> verticesInCreationOrder;
    private long[] stateTimestamps;
    private JobStatus state;
    private ErrorInfo failureCause;
    private String jsonPlan;
    private StringifiedAccumulatorResult[] archivedUserAccumulators;
    private ArchivedExecutionConfig archivedExecutionConfig;
    private boolean isStoppable;
    private Map<String, SerializedValue<OptionalFailure<Object>>> serializedUserAccumulators;

    public ArchivedExecutionGraphBuilder setJobID(JobID jobID) {
        this.jobID = jobID;
        return this;
    }

    public ArchivedExecutionGraphBuilder setJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public ArchivedExecutionGraphBuilder setTasks(Map<JobVertexID, ArchivedExecutionJobVertex> tasks) {
        this.tasks = tasks;
        return this;
    }

    public ArchivedExecutionGraphBuilder setVerticesInCreationOrder(List<ArchivedExecutionJobVertex> verticesInCreationOrder) {
        this.verticesInCreationOrder = verticesInCreationOrder;
        return this;
    }

    public ArchivedExecutionGraphBuilder setStateTimestamps(long[] stateTimestamps) {
        Preconditions.checkArgument((stateTimestamps.length == JobStatus.values().length ? 1 : 0) != 0);
        this.stateTimestamps = stateTimestamps;
        return this;
    }

    public ArchivedExecutionGraphBuilder setState(JobStatus state) {
        this.state = state;
        return this;
    }

    public ArchivedExecutionGraphBuilder setFailureCause(ErrorInfo failureCause) {
        this.failureCause = failureCause;
        return this;
    }

    public ArchivedExecutionGraphBuilder setJsonPlan(String jsonPlan) {
        this.jsonPlan = jsonPlan;
        return this;
    }

    public ArchivedExecutionGraphBuilder setArchivedUserAccumulators(StringifiedAccumulatorResult[] archivedUserAccumulators) {
        this.archivedUserAccumulators = archivedUserAccumulators;
        return this;
    }

    public ArchivedExecutionGraphBuilder setArchivedExecutionConfig(ArchivedExecutionConfig archivedExecutionConfig) {
        this.archivedExecutionConfig = archivedExecutionConfig;
        return this;
    }

    public ArchivedExecutionGraphBuilder setStoppable(boolean stoppable) {
        this.isStoppable = stoppable;
        return this;
    }

    public ArchivedExecutionGraphBuilder setSerializedUserAccumulators(Map<String, SerializedValue<OptionalFailure<Object>>> serializedUserAccumulators) {
        this.serializedUserAccumulators = serializedUserAccumulators;
        return this;
    }

    public ArchivedExecutionGraph build() {
        String jobName;
        JobID jobID = this.jobID != null ? this.jobID : new JobID();
        String string = jobName = this.jobName != null ? this.jobName : "job_" + RANDOM.nextInt();
        if (this.tasks == null) {
            this.tasks = Collections.emptyMap();
        }
        return new ArchivedExecutionGraph(jobID, jobName, this.tasks, this.verticesInCreationOrder != null ? this.verticesInCreationOrder : new ArrayList<ArchivedExecutionJobVertex>(this.tasks.values()), this.stateTimestamps != null ? this.stateTimestamps : new long[JobStatus.values().length], this.state != null ? this.state : JobStatus.FINISHED, this.failureCause, this.jsonPlan != null ? this.jsonPlan : "{\"jobid\":\"" + jobID + "\", \"name\":\"" + jobName + "\", \"nodes\":[]}", this.archivedUserAccumulators != null ? this.archivedUserAccumulators : new StringifiedAccumulatorResult[]{}, this.serializedUserAccumulators != null ? this.serializedUserAccumulators : Collections.emptyMap(), this.archivedExecutionConfig != null ? this.archivedExecutionConfig : new ArchivedExecutionConfigBuilder().build(), this.isStoppable, null, null, "stateBackendName");
    }
}

