/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.api.common.InputDependencyConstraint;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingResultPartition;
import org.apache.flink.util.Preconditions;

public class TestingSchedulingExecutionVertex
implements SchedulingExecutionVertex {
    private final ExecutionVertexID executionVertexId;
    private final Collection<TestingSchedulingResultPartition> consumedPartitions;
    private final Collection<TestingSchedulingResultPartition> producedPartitions;
    private InputDependencyConstraint inputDependencyConstraint;
    private ExecutionState executionState;

    public TestingSchedulingExecutionVertex(JobVertexID jobVertexId, int subtaskIndex) {
        this(jobVertexId, subtaskIndex, InputDependencyConstraint.ANY);
    }

    public TestingSchedulingExecutionVertex(JobVertexID jobVertexId, int subtaskIndex, InputDependencyConstraint constraint) {
        this(jobVertexId, subtaskIndex, constraint, new ArrayList<TestingSchedulingResultPartition>());
    }

    public TestingSchedulingExecutionVertex(JobVertexID jobVertexId, int subtaskIndex, InputDependencyConstraint constraint, Collection<TestingSchedulingResultPartition> consumedPartitions) {
        this.executionVertexId = new ExecutionVertexID(jobVertexId, subtaskIndex);
        this.inputDependencyConstraint = constraint;
        this.consumedPartitions = (Collection)Preconditions.checkNotNull(consumedPartitions);
        this.producedPartitions = new ArrayList<TestingSchedulingResultPartition>();
        this.executionState = ExecutionState.CREATED;
    }

    public ExecutionVertexID getId() {
        return this.executionVertexId;
    }

    public ExecutionState getState() {
        return this.executionState;
    }

    public void setState(ExecutionState state) {
        this.executionState = state;
    }

    public Iterable<TestingSchedulingResultPartition> getConsumedResults() {
        return this.consumedPartitions;
    }

    public Iterable<TestingSchedulingResultPartition> getProducedResults() {
        return this.producedPartitions;
    }

    public InputDependencyConstraint getInputDependencyConstraint() {
        return this.inputDependencyConstraint;
    }

    void addConsumedPartition(TestingSchedulingResultPartition partition) {
        this.consumedPartitions.add(partition);
    }

    void addProducedPartition(TestingSchedulingResultPartition partition) {
        this.producedPartitions.add(partition);
    }
}

