/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.modules;

import java.io.File;
import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.modules.JaasModule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JaasModuleTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Before
    public void setUp() throws IOException {
        System.getProperties().remove("java.security.auth.login.config");
        this.folder.create();
    }

    @Test
    public void testJaasModuleFilePathIfWorkingDirPresent() throws IOException {
        File file = this.folder.newFolder();
        this.testJaasModuleFilePath(file.toPath().toString());
    }

    @Test
    public void testJaasModuleFilePathIfWorkingDirNotPresent() throws IOException {
        File file = this.folder.newFolder();
        this.testJaasModuleFilePath(file.toPath().toString() + "/tmp");
    }

    private void testJaasModuleFilePath(String workingDir) {
        Configuration configuration = new Configuration();
        configuration.setString(CoreOptions.TMP_DIRS, workingDir);
        SecurityConfiguration sc = new SecurityConfiguration(configuration);
        JaasModule module = new JaasModule(sc);
        module.install();
        this.assertJaasFileLocateInRightDirectory(workingDir);
    }

    @Test
    public void testCreateJaasModuleFileInTemporary() {
        Configuration configuration = new Configuration();
        SecurityConfiguration sc = new SecurityConfiguration(configuration);
        JaasModule module = new JaasModule(sc);
        module.install();
        this.assertJaasFileLocateInRightDirectory((String)CoreOptions.TMP_DIRS.defaultValue());
    }

    private void assertJaasFileLocateInRightDirectory(String directory) {
        Assert.assertTrue((boolean)System.getProperty("java.security.auth.login.config").startsWith(directory));
    }
}

