/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collections;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.util.IOUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HeapKeyedStateBackendAsyncByDefaultTest {
    @Rule
    public final TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testConfigOptionDefaultsToAsync() {
        Assert.assertTrue((boolean)((Boolean)CheckpointingOptions.ASYNC_SNAPSHOTS.defaultValue()));
    }

    @Test
    public void testFsStateBackendDefaultsToAsync() throws Exception {
        FsStateBackend backend = new FsStateBackend(this.tmpFolder.newFolder().toURI());
        Assert.assertTrue((boolean)backend.isUsingAsynchronousSnapshots());
        this.validateSupportForAsyncSnapshots((StateBackend)backend);
    }

    @Test
    public void testMemoryStateBackendDefaultsToAsync() throws Exception {
        MemoryStateBackend backend = new MemoryStateBackend();
        Assert.assertTrue((boolean)backend.isUsingAsynchronousSnapshots());
        this.validateSupportForAsyncSnapshots((StateBackend)backend);
    }

    private void validateSupportForAsyncSnapshots(StateBackend backend) throws Exception {
        AbstractKeyedStateBackend keyedStateBackend = backend.createKeyedStateBackend((Environment)new DummyEnvironment("Test", 1, 0), new JobID(), "testOperator", (TypeSerializer)IntSerializer.INSTANCE, 1, new KeyGroupRange(0, 0), null, TtlTimeProvider.DEFAULT, (MetricGroup)new UnregisteredMetricsGroup(), Collections.emptyList(), new CloseableRegistry());
        Assert.assertTrue((boolean)keyedStateBackend.supportsAsynchronousSnapshots());
        IOUtils.closeQuietly((AutoCloseable)keyedStateBackend);
        keyedStateBackend.dispose();
    }
}

