/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointTestUtils;
import org.apache.flink.runtime.state.IncrementalRemoteKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;

public class IncrementalRemoteKeyedStateHandleTest {
    @Test
    public void testUnregisteredDiscarding() throws Exception {
        IncrementalRemoteKeyedStateHandle stateHandle = IncrementalRemoteKeyedStateHandleTest.create(new Random(42L));
        stateHandle.discardState();
        for (StreamStateHandle handle : stateHandle.getPrivateState().values()) {
            ((StreamStateHandle)Mockito.verify((Object)handle)).discardState();
        }
        for (StreamStateHandle handle : stateHandle.getSharedState().values()) {
            ((StreamStateHandle)Mockito.verify((Object)handle)).discardState();
        }
        ((StreamStateHandle)Mockito.verify((Object)stateHandle.getMetaStateHandle())).discardState();
    }

    @Test
    public void testSharedStateDeRegistration() throws Exception {
        SharedStateRegistryKey registryKey;
        SharedStateRegistry registry = (SharedStateRegistry)PowerMockito.spy((Object)new SharedStateRegistry());
        IncrementalRemoteKeyedStateHandle stateHandle1 = IncrementalRemoteKeyedStateHandleTest.create(new Random(42L));
        IncrementalRemoteKeyedStateHandle stateHandle2 = IncrementalRemoteKeyedStateHandleTest.create(new Random(42L));
        for (Map.Entry entry : stateHandle1.getSharedState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)entry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)0))).unregisterReference(registryKey);
            ((StreamStateHandle)Mockito.verify(entry.getValue(), (VerificationMode)Mockito.times((int)0))).discardState();
        }
        for (Map.Entry entry : stateHandle2.getSharedState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)entry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)0))).unregisterReference(registryKey);
            ((StreamStateHandle)Mockito.verify(entry.getValue(), (VerificationMode)Mockito.times((int)0))).discardState();
        }
        stateHandle1.registerSharedStates(registry);
        stateHandle2.registerSharedStates(registry);
        for (Map.Entry stateHandleEntry : stateHandle1.getSharedState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)stateHandleEntry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry)).registerReference(registryKey, (StreamStateHandle)stateHandleEntry.getValue());
        }
        for (Map.Entry stateHandleEntry : stateHandle2.getSharedState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)stateHandleEntry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry)).registerReference(registryKey, (StreamStateHandle)stateHandleEntry.getValue());
        }
        stateHandle1.discardState();
        for (Map.Entry entry : stateHandle1.getSharedState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)entry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)1))).unregisterReference(registryKey);
            ((StreamStateHandle)Mockito.verify(entry.getValue(), (VerificationMode)Mockito.times((int)0))).discardState();
        }
        for (StreamStateHandle handle : stateHandle2.getSharedState().values()) {
            ((StreamStateHandle)Mockito.verify((Object)handle, (VerificationMode)Mockito.times((int)0))).discardState();
        }
        for (Map.Entry handleEntry : stateHandle1.getPrivateState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)handleEntry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)0))).unregisterReference(registryKey);
            ((StreamStateHandle)Mockito.verify(handleEntry.getValue(), (VerificationMode)Mockito.times((int)1))).discardState();
        }
        for (Map.Entry handleEntry : stateHandle2.getPrivateState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)handleEntry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)0))).unregisterReference(registryKey);
            ((StreamStateHandle)Mockito.verify(handleEntry.getValue(), (VerificationMode)Mockito.times((int)0))).discardState();
        }
        ((StreamStateHandle)Mockito.verify((Object)stateHandle1.getMetaStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
        ((StreamStateHandle)Mockito.verify((Object)stateHandle2.getMetaStateHandle(), (VerificationMode)Mockito.times((int)0))).discardState();
        stateHandle2.discardState();
        for (Map.Entry entry : stateHandle1.getSharedState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)entry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)2))).unregisterReference(registryKey);
            ((StreamStateHandle)Mockito.verify(entry.getValue())).discardState();
        }
        for (Map.Entry entry : stateHandle2.getSharedState().entrySet()) {
            registryKey = stateHandle1.createSharedStateRegistryKeyFromFileName((StateHandleID)entry.getKey());
            ((SharedStateRegistry)Mockito.verify((Object)registry, (VerificationMode)Mockito.times((int)2))).unregisterReference(registryKey);
            ((StreamStateHandle)Mockito.verify(entry.getValue())).discardState();
        }
        ((StreamStateHandle)Mockito.verify((Object)stateHandle1.getMetaStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
        ((StreamStateHandle)Mockito.verify((Object)stateHandle2.getMetaStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
    }

    @Test
    public void testSharedStateReRegistration() throws Exception {
        SharedStateRegistry stateRegistryA = (SharedStateRegistry)PowerMockito.spy((Object)new SharedStateRegistry());
        IncrementalRemoteKeyedStateHandle stateHandleX = IncrementalRemoteKeyedStateHandleTest.create(new Random(1L));
        IncrementalRemoteKeyedStateHandle stateHandleY = IncrementalRemoteKeyedStateHandleTest.create(new Random(2L));
        IncrementalRemoteKeyedStateHandle stateHandleZ = IncrementalRemoteKeyedStateHandleTest.create(new Random(3L));
        stateHandleX.registerSharedStates(stateRegistryA);
        stateHandleY.registerSharedStates(stateRegistryA);
        stateHandleZ.registerSharedStates(stateRegistryA);
        try {
            stateHandleX.registerSharedStates(stateRegistryA);
            Assert.fail((String)"Should not be able to register twice with the same registry.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        stateHandleZ.discardState();
        ((StreamStateHandle)Mockito.verify((Object)stateHandleZ.getMetaStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
        for (StreamStateHandle stateHandle : stateHandleZ.getSharedState().values()) {
            ((StreamStateHandle)Mockito.verify((Object)stateHandle, (VerificationMode)Mockito.times((int)1))).discardState();
        }
        stateRegistryA.close();
        try {
            IncrementalRemoteKeyedStateHandleTest.create(new Random(4L)).registerSharedStates(stateRegistryA);
            Assert.fail((String)"Should not be able to register new state to closed registry.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        stateHandleY.discardState();
        ((StreamStateHandle)Mockito.verify((Object)stateHandleY.getMetaStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
        for (StreamStateHandle stateHandle : stateHandleY.getSharedState().values()) {
            ((StreamStateHandle)Mockito.verify((Object)stateHandle, (VerificationMode)Mockito.times((int)1))).discardState();
        }
        ((StreamStateHandle)Mockito.verify((Object)stateHandleX.getMetaStateHandle(), (VerificationMode)Mockito.never())).discardState();
        for (StreamStateHandle stateHandle : stateHandleX.getSharedState().values()) {
            ((StreamStateHandle)Mockito.verify((Object)stateHandle, (VerificationMode)Mockito.never())).discardState();
        }
        SharedStateRegistry sharedStateRegistryB = (SharedStateRegistry)PowerMockito.spy((Object)new SharedStateRegistry());
        stateHandleX.registerSharedStates(sharedStateRegistryB);
        stateHandleX.discardState();
        ((StreamStateHandle)Mockito.verify((Object)stateHandleX.getMetaStateHandle(), (VerificationMode)Mockito.times((int)1))).discardState();
        for (StreamStateHandle stateHandle : stateHandleX.getSharedState().values()) {
            ((StreamStateHandle)Mockito.verify((Object)stateHandle, (VerificationMode)Mockito.times((int)1))).discardState();
        }
        sharedStateRegistryB.close();
    }

    private static IncrementalRemoteKeyedStateHandle create(Random rnd) {
        return new IncrementalRemoteKeyedStateHandle(UUID.nameUUIDFromBytes("test".getBytes()), KeyGroupRange.of((int)0, (int)0), 1L, IncrementalRemoteKeyedStateHandleTest.placeSpies(CheckpointTestUtils.createRandomStateHandleMap(rnd)), IncrementalRemoteKeyedStateHandleTest.placeSpies(CheckpointTestUtils.createRandomStateHandleMap(rnd)), (StreamStateHandle)PowerMockito.spy((Object)CheckpointTestUtils.createDummyStreamStateHandle(rnd, null)));
    }

    private static Map<StateHandleID, StreamStateHandle> placeSpies(Map<StateHandleID, StreamStateHandle> map) {
        for (Map.Entry<StateHandleID, StreamStateHandle> entry : map.entrySet()) {
            entry.setValue((StreamStateHandle)PowerMockito.spy((Object)entry.getValue()));
        }
        return map;
    }
}

