/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;
import org.apache.flink.runtime.state.memory.NonPersistentMetadataCheckpointStorageLocation;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;

public class TestingCheckpointStorageCoordinatorView
implements CheckpointStorage,
Serializable {
    private final HashMap<String, TestingCompletedCheckpointStorageLocation> registeredSavepoints = new HashMap();

    public void registerSavepoint(String pointer, byte[] metadata) {
        this.registeredSavepoints.put(pointer, new TestingCompletedCheckpointStorageLocation(pointer, metadata));
    }

    public boolean supportsHighlyAvailableStorage() {
        return false;
    }

    public boolean hasDefaultSavepointLocation() {
        return false;
    }

    public CompletedCheckpointStorageLocation resolveCheckpoint(String externalPointer) throws IOException {
        CompletedCheckpointStorageLocation location = this.registeredSavepoints.get(externalPointer);
        if (location != null) {
            return location;
        }
        throw new IOException("Could not find savepoint for pointer: " + externalPointer);
    }

    public void initializeBaseLocations() throws IOException {
    }

    public CheckpointStorageLocation initializeLocationForCheckpoint(long checkpointId) throws IOException {
        return new NonPersistentMetadataCheckpointStorageLocation(Integer.MAX_VALUE);
    }

    public CheckpointStorageLocation initializeLocationForSavepoint(long checkpointId, @Nullable String externalLocationPointer) throws IOException {
        return new NonPersistentMetadataCheckpointStorageLocation(Integer.MAX_VALUE);
    }

    public CheckpointStreamFactory resolveCheckpointStorageLocation(long checkpointId, CheckpointStorageLocationReference reference) {
        return new MemCheckpointStreamFactory(Integer.MAX_VALUE);
    }

    public CheckpointStreamFactory.CheckpointStateOutputStream createTaskOwnedStateStream() {
        return new MemCheckpointStreamFactory.MemoryCheckpointOutputStream(Integer.MAX_VALUE);
    }

    public StateBackend asStateBackend() {
        return new FactoringStateBackend(this);
    }

    private static final class FactoringStateBackend
    implements StateBackend {
        private final TestingCheckpointStorageCoordinatorView testingCoordinatorView;

        private FactoringStateBackend(TestingCheckpointStorageCoordinatorView testingCoordinatorView) {
            this.testingCoordinatorView = testingCoordinatorView;
        }

        public CompletedCheckpointStorageLocation resolveCheckpoint(String externalPointer) throws IOException {
            return this.testingCoordinatorView.resolveCheckpoint(externalPointer);
        }

        public CheckpointStorage createCheckpointStorage(JobID jobId) throws IOException {
            return this.testingCoordinatorView;
        }

        public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry, TtlTimeProvider ttlTimeProvider, MetricGroup metricGroup, @Nonnull Collection<KeyedStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) throws Exception {
            throw new UnsupportedOperationException();
        }

        public OperatorStateBackend createOperatorStateBackend(Environment env, String operatorIdentifier, @Nonnull Collection<OperatorStateHandle> stateHandles, CloseableRegistry cancelStreamRegistry) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    private static final class TestingCompletedCheckpointStorageLocation
    implements CompletedCheckpointStorageLocation,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String pointer;
        private final byte[] metadata;

        TestingCompletedCheckpointStorageLocation(String pointer, byte[] metadata) {
            this.pointer = pointer;
            this.metadata = metadata;
        }

        public String getExternalPointer() {
            return this.pointer;
        }

        public StreamStateHandle getMetadataHandle() {
            return new ByteStreamStateHandle(this.pointer, this.metadata);
        }

        public void disposeStorageLocation() throws IOException {
        }
    }
}

