/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.AbstractFileCheckpointStorageTestBase;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;
import org.apache.flink.runtime.state.memory.MemoryBackendCheckpointStorage;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.junit.Assert;
import org.junit.Test;

public class MemoryCheckpointStorageTest
extends AbstractFileCheckpointStorageTestBase {
    private static final int DEFAULT_MAX_STATE_SIZE = 0x500000;

    @Override
    protected CheckpointStorage createCheckpointStorage(Path checkpointDir) throws Exception {
        return new MemoryBackendCheckpointStorage(new JobID(), checkpointDir, null, 0x500000);
    }

    @Override
    protected CheckpointStorage createCheckpointStorageWithSavepointDir(Path checkpointDir, Path savepointDir) throws Exception {
        return new MemoryBackendCheckpointStorage(new JobID(), checkpointDir, savepointDir, 0x500000);
    }

    @Test
    public void testParametrizationDefault() throws Exception {
        JobID jid = new JobID();
        MemoryStateBackend backend = new MemoryStateBackend();
        MemoryBackendCheckpointStorage storage = (MemoryBackendCheckpointStorage)backend.createCheckpointStorage(jid);
        Assert.assertFalse((boolean)storage.supportsHighlyAvailableStorage());
        Assert.assertFalse((boolean)storage.hasDefaultSavepointLocation());
        Assert.assertNull((Object)storage.getDefaultSavepointDirectory());
        Assert.assertEquals((long)0x500000L, (long)storage.getMaxStateSize());
    }

    @Test
    public void testParametrizationDirectories() throws Exception {
        JobID jid = new JobID();
        Path checkpointPath = new Path(this.tmp.newFolder().toURI().toString());
        Path savepointPath = new Path(this.tmp.newFolder().toURI().toString());
        MemoryStateBackend backend = new MemoryStateBackend(checkpointPath.toString(), savepointPath.toString());
        MemoryBackendCheckpointStorage storage = (MemoryBackendCheckpointStorage)backend.createCheckpointStorage(jid);
        Assert.assertTrue((boolean)storage.supportsHighlyAvailableStorage());
        Assert.assertTrue((boolean)storage.hasDefaultSavepointLocation());
        Assert.assertNotNull((Object)storage.getDefaultSavepointDirectory());
        Assert.assertEquals((Object)savepointPath, (Object)storage.getDefaultSavepointDirectory());
    }

    @Test
    public void testParametrizationStateSize() throws Exception {
        int maxSize = 17;
        MemoryStateBackend backend = new MemoryStateBackend(17);
        MemoryBackendCheckpointStorage storage = (MemoryBackendCheckpointStorage)backend.createCheckpointStorage(new JobID());
        Assert.assertEquals((long)17L, (long)storage.getMaxStateSize());
    }

    @Test
    public void testNonPersistentCheckpointLocation() throws Exception {
        MemoryBackendCheckpointStorage storage = new MemoryBackendCheckpointStorage(new JobID(), null, null, 0x500000);
        CheckpointStorageLocation location = storage.initializeLocationForCheckpoint(9L);
        CheckpointMetadataOutputStream stream = location.createMetadataOutputStream();
        stream.write(99);
        CompletedCheckpointStorageLocation completed = stream.closeAndFinalizeCheckpoint();
        StreamStateHandle handle = completed.getMetadataHandle();
        Assert.assertTrue((boolean)(handle instanceof ByteStreamStateHandle));
        try {
            storage.resolveCheckpoint(completed.getExternalPointer());
            Assert.fail((String)"should fail with an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testLocationReference() throws Exception {
        MemoryBackendCheckpointStorage storage = new MemoryBackendCheckpointStorage(new JobID(), null, null, 0x500000);
        CheckpointStorageLocation location = storage.initializeLocationForCheckpoint(42L);
        Assert.assertTrue((boolean)location.getLocationReference().isDefaultReference());
        storage = new MemoryBackendCheckpointStorage(new JobID(), this.randomTempPath(), null, 0x500000);
        location = storage.initializeLocationForCheckpoint(42L);
        Assert.assertTrue((boolean)location.getLocationReference().isDefaultReference());
        storage = new MemoryBackendCheckpointStorage(new JobID(), null, null, 0x500000);
        location = storage.initializeLocationForSavepoint(1337L, this.randomTempPath().toString());
        Assert.assertTrue((boolean)location.getLocationReference().isDefaultReference());
    }

    @Test
    public void testTaskOwnedStateStream() throws Exception {
        StreamStateHandle stateHandle;
        List<String> state = Arrays.asList("Flopsy", "Mopsy", "Cotton Tail", "Peter");
        MemoryBackendCheckpointStorage storage = new MemoryBackendCheckpointStorage(new JobID(), null, null, 0x500000);
        try (CheckpointStreamFactory.CheckpointStateOutputStream stream = storage.createTaskOwnedStateStream();){
            Assert.assertTrue((boolean)(stream instanceof MemCheckpointStreamFactory.MemoryCheckpointOutputStream));
            new ObjectOutputStream((OutputStream)stream).writeObject(state);
            stateHandle = stream.closeAndGetHandle();
        }
        var5_4 = null;
        try (ObjectInputStream in = new ObjectInputStream((InputStream)stateHandle.openInputStream());){
            Assert.assertEquals(state, (Object)in.readObject());
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testStorageLocationMkdirs() throws Exception {
        MemoryBackendCheckpointStorage storage = new MemoryBackendCheckpointStorage(new JobID(), this.randomTempPath(), null, 0x500000);
        File baseDir = new File(storage.getCheckpointsDirectory().getPath());
        Assert.assertFalse((boolean)baseDir.exists());
        storage.initializeLocationForCheckpoint(177L);
        Assert.assertTrue((boolean)baseDir.exists());
    }
}

