/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.commons.io.FileUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.heartbeat.TestingHeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.NoOpMetricRegistry;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcServiceResource;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TaskManagerRunnerStartupTest
extends TestLogger {
    private static final String LOCAL_HOST = "localhost";
    @ClassRule
    public static final TestingRpcServiceResource RPC_SERVICE_RESOURCE = new TestingRpcServiceResource();
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final RpcService rpcService = RPC_SERVICE_RESOURCE.getTestingRpcService();
    private TestingHighAvailabilityServices highAvailabilityServices;

    @Before
    public void setupTest() {
        this.highAvailabilityServices = new TestingHighAvailabilityServices();
    }

    @After
    public void tearDownTest() throws Exception {
        this.highAvailabilityServices.closeAndCleanupAllData();
        this.highAvailabilityServices = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIODirectoryNotWritable() throws Exception {
        File nonWritable = this.tempFolder.newFolder();
        Assume.assumeTrue((String)"Cannot create non-writable temporary file directory. Skipping test.", (boolean)nonWritable.setWritable(false, false));
        try {
            Configuration cfg = TaskManagerRunnerStartupTest.createFlinkConfiguration();
            cfg.setString(CoreOptions.TMP_DIRS, nonWritable.getAbsolutePath());
            try {
                TaskManagerRunnerStartupTest.startTaskManager(cfg, this.rpcService, this.highAvailabilityServices);
                Assert.fail((String)"Should fail synchronously with an IOException");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            nonWritable.setWritable(true, false);
            try {
                FileUtils.deleteDirectory((File)nonWritable);
            }
            catch (IOException iOException) {}
        }
    }

    @Test(expected=IllegalConfigurationException.class)
    public void testMemoryConfigWrong() throws Exception {
        Configuration cfg = TaskManagerRunnerStartupTest.createFlinkConfiguration();
        cfg.set(TaskManagerOptions.NETWORK_MEMORY_MIN, (Object)MemorySize.parse((String)"100m"));
        cfg.set(TaskManagerOptions.NETWORK_MEMORY_MAX, (Object)MemorySize.parse((String)"10m"));
        TaskManagerRunnerStartupTest.startTaskManager(cfg, this.rpcService, this.highAvailabilityServices);
    }

    @Test
    public void testStartupWhenNetworkStackFailsToInitialize() throws Exception {
        ServerSocket blocker = new ServerSocket(0, 50, InetAddress.getByName(LOCAL_HOST));
        try {
            Configuration cfg = TaskManagerRunnerStartupTest.createFlinkConfiguration();
            cfg.setInteger(NettyShuffleEnvironmentOptions.DATA_PORT, blocker.getLocalPort());
            cfg.setString(TaskManagerOptions.BIND_HOST, LOCAL_HOST);
            TaskManagerRunnerStartupTest.startTaskManager(cfg, this.rpcService, this.highAvailabilityServices);
            Assert.fail((String)"Should throw IOException when the network stack cannot be initialized.");
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)blocker);
        }
    }

    private static Configuration createFlinkConfiguration() {
        return TaskExecutorResourceUtils.adjustForLocalExecution((Configuration)new Configuration());
    }

    private static void startTaskManager(Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices) throws Exception {
        TaskManagerRunner.startTaskManager((Configuration)configuration, (ResourceID)ResourceID.generate(), (RpcService)rpcService, (HighAvailabilityServices)highAvailabilityServices, (HeartbeatServices)new TestingHeartbeatServices(), (MetricRegistry)NoOpMetricRegistry.INSTANCE, (BlobCacheService)new BlobCacheService(configuration, (BlobView)new VoidBlobStore(), null), (boolean)false, (ExternalResourceInfoProvider)ExternalResourceInfoProvider.NO_EXTERNAL_RESOURCES, error -> {});
    }
}

