/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.util.Collection;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.contrib.streaming.state.AbstractRocksDBAppendingState;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.util.FlinkRuntimeException;
import org.rocksdb.ColumnFamilyHandle;

class RocksDBAggregatingState<K, N, T, ACC, R>
extends AbstractRocksDBAppendingState<K, N, T, ACC, R>
implements InternalAggregatingState<K, N, T, ACC, R> {
    private final AggregateFunction<T, ACC, R> aggFunction;

    private RocksDBAggregatingState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, TypeSerializer<ACC> valueSerializer, ACC defaultValue, AggregateFunction<T, ACC, R> aggFunction, RocksDBKeyedStateBackend<K> backend) {
        super(columnFamily, namespaceSerializer, valueSerializer, defaultValue, backend);
        this.aggFunction = aggFunction;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.backend.getKeySerializer();
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public TypeSerializer<ACC> getValueSerializer() {
        return this.valueSerializer;
    }

    public R get() {
        Object accumulator = this.getInternal();
        if (accumulator == null) {
            return null;
        }
        return (R)this.aggFunction.getResult(accumulator);
    }

    public void add(T value) {
        byte[] key = this.getKeyBytes();
        Object accumulator = this.getInternal(key);
        accumulator = accumulator == null ? this.aggFunction.createAccumulator() : accumulator;
        this.updateInternal(key, this.aggFunction.add(value, accumulator));
    }

    public void mergeNamespaces(N target, Collection<N> sources) {
        if (sources == null || sources.isEmpty()) {
            return;
        }
        try {
            Object current = null;
            for (N source : sources) {
                if (source == null) continue;
                this.setCurrentNamespace(source);
                byte[] sourceKey = this.serializeCurrentKeyWithGroupAndNamespace();
                byte[] valueBytes = this.backend.db.get(this.columnFamily, sourceKey);
                this.backend.db.delete(this.columnFamily, this.writeOptions, sourceKey);
                if (valueBytes == null) continue;
                this.dataInputView.setBuffer(valueBytes);
                Object value = this.valueSerializer.deserialize((DataInputView)this.dataInputView);
                if (current != null) {
                    current = this.aggFunction.merge(current, value);
                    continue;
                }
                current = value;
            }
            if (current != null) {
                this.setCurrentNamespace(target);
                byte[] targetKey = this.serializeCurrentKeyWithGroupAndNamespace();
                byte[] targetValueBytes = this.backend.db.get(this.columnFamily, targetKey);
                if (targetValueBytes != null) {
                    this.dataInputView.setBuffer(targetValueBytes);
                    Object value = this.valueSerializer.deserialize((DataInputView)this.dataInputView);
                    current = this.aggFunction.merge(current, value);
                }
                this.dataOutputView.clear();
                this.valueSerializer.serialize(current, (DataOutputView)this.dataOutputView);
                this.backend.db.put(this.columnFamily, this.writeOptions, targetKey, this.dataOutputView.getCopyOfBuffer());
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Error while merging state in RocksDB", (Throwable)e);
        }
    }

    static <K, N, SV, S extends State, IS extends S> IS create(StateDescriptor<S, SV> stateDesc, Tuple2<ColumnFamilyHandle, RegisteredKeyValueStateBackendMetaInfo<N, SV>> registerResult, RocksDBKeyedStateBackend<K> backend) {
        return (IS)new RocksDBAggregatingState((ColumnFamilyHandle)registerResult.f0, ((RegisteredKeyValueStateBackendMetaInfo)registerResult.f1).getNamespaceSerializer(), ((RegisteredKeyValueStateBackendMetaInfo)registerResult.f1).getStateSerializer(), stateDesc.getDefaultValue(), ((AggregatingStateDescriptor)stateDesc).getAggregateFunction(), backend);
    }
}

