/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.Serializable;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.LinkElement;
import org.rocksdb.CompactionStyle;

public class RocksDBConfigurableOptions
implements Serializable {
    public static final ConfigOption<Integer> MAX_BACKGROUND_THREADS = ConfigOptions.key((String)"state.backend.rocksdb.thread.num").intType().noDefaultValue().withDescription("The maximum number of concurrent background flush and compaction jobs (per TaskManager). RocksDB has default configuration as '1'.");
    public static final ConfigOption<Integer> MAX_OPEN_FILES = ConfigOptions.key((String)"state.backend.rocksdb.files.open").intType().noDefaultValue().withDescription("The maximum number of open files (per TaskManager) that can be used by the DB, '-1' means no limit. RocksDB has default configuration as '-1'.");
    public static final ConfigOption<CompactionStyle> COMPACTION_STYLE = ConfigOptions.key((String)"state.backend.rocksdb.compaction.style").enumType(CompactionStyle.class).noDefaultValue().withDescription(String.format("The specified compaction style for DB. Candidate compaction style is %s, %s or %s, and RocksDB choose '%s' as default style.", CompactionStyle.LEVEL.name(), CompactionStyle.FIFO.name(), CompactionStyle.UNIVERSAL.name(), CompactionStyle.LEVEL.name()));
    public static final ConfigOption<Boolean> USE_DYNAMIC_LEVEL_SIZE = ConfigOptions.key((String)"state.backend.rocksdb.compaction.level.use-dynamic-size").booleanType().noDefaultValue().withDescription(Description.builder().text("If true, RocksDB will pick target size of each level dynamically. From an empty DB, ").text("RocksDB would make last level the base level, which means merging L0 data into the last level, ").text("until it exceeds max_bytes_for_level_base. And then repeat this process for second last level and so on. ").text("RocksDB has default configuration as 'false'. ").text("For more information, please refer to %s", new InlineElement[]{LinkElement.link((String)"https://github.com/facebook/rocksdb/wiki/Leveled-Compaction#level_compaction_dynamic_level_bytes-is-true", (String)"RocksDB's doc.")}).build());
    public static final ConfigOption<MemorySize> TARGET_FILE_SIZE_BASE = ConfigOptions.key((String)"state.backend.rocksdb.compaction.level.target-file-size-base").memoryType().noDefaultValue().withDescription("The target file size for compaction, which determines a level-1 file size. RocksDB has default configuration as '64MB'.");
    public static final ConfigOption<MemorySize> MAX_SIZE_LEVEL_BASE = ConfigOptions.key((String)"state.backend.rocksdb.compaction.level.max-size-level-base").memoryType().noDefaultValue().withDescription("The upper-bound of the total size of level base files in bytes. RocksDB has default configuration as '256MB'.");
    public static final ConfigOption<MemorySize> WRITE_BUFFER_SIZE = ConfigOptions.key((String)"state.backend.rocksdb.writebuffer.size").memoryType().noDefaultValue().withDescription("The amount of data built up in memory (backed by an unsorted log on disk) before converting to a sorted on-disk files. RocksDB has default writebuffer size as '64MB'.");
    public static final ConfigOption<Integer> MAX_WRITE_BUFFER_NUMBER = ConfigOptions.key((String)"state.backend.rocksdb.writebuffer.count").intType().noDefaultValue().withDescription("Tne maximum number of write buffers that are built up in memory. RocksDB has default configuration as '2'.");
    public static final ConfigOption<Integer> MIN_WRITE_BUFFER_NUMBER_TO_MERGE = ConfigOptions.key((String)"state.backend.rocksdb.writebuffer.number-to-merge").intType().noDefaultValue().withDescription("The minimum number of write buffers that will be merged together before writing to storage. RocksDB has default configuration as '1'.");
    public static final ConfigOption<MemorySize> BLOCK_SIZE = ConfigOptions.key((String)"state.backend.rocksdb.block.blocksize").memoryType().noDefaultValue().withDescription("The approximate size (in bytes) of user data packed per block. RocksDB has default blocksize as '4KB'.");
    public static final ConfigOption<MemorySize> BLOCK_CACHE_SIZE = ConfigOptions.key((String)"state.backend.rocksdb.block.cache-size").memoryType().noDefaultValue().withDescription("The amount of the cache for data blocks in RocksDB. RocksDB has default block-cache size as '8MB'.");
    public static final ConfigOption<MemorySize> WRITE_BATCH_SIZE = ConfigOptions.key((String)"state.backend.rocksdb.write-batch-size").memoryType().defaultValue((Object)MemorySize.parse((String)"2mb")).withDescription("The max size of the consumed memory for RocksDB batch write, will flush just based on item count if this config set to 0.");
}

