/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.contrib.streaming.state.PredefinedOptions;
import org.apache.flink.contrib.streaming.state.RocksDBNativeMetricOptions;
import org.apache.flink.contrib.streaming.state.RocksDBOptionsFactory;
import org.apache.flink.contrib.streaming.state.RocksDBSharedResources;
import org.apache.flink.runtime.memory.OpaqueMemoryResource;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Filter;
import org.rocksdb.IndexType;
import org.rocksdb.ReadOptions;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RocksDBResourceContainer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBResourceContainer.class);
    private final PredefinedOptions predefinedOptions;
    @Nullable
    private final RocksDBOptionsFactory optionsFactory;
    @Nullable
    private final OpaqueMemoryResource<RocksDBSharedResources> sharedResources;
    private final ArrayList<AutoCloseable> handlesToClose;

    public RocksDBResourceContainer() {
        this(PredefinedOptions.DEFAULT, null, null);
    }

    public RocksDBResourceContainer(PredefinedOptions predefinedOptions, @Nullable RocksDBOptionsFactory optionsFactory) {
        this(predefinedOptions, optionsFactory, null);
    }

    public RocksDBResourceContainer(PredefinedOptions predefinedOptions, @Nullable RocksDBOptionsFactory optionsFactory, @Nullable OpaqueMemoryResource<RocksDBSharedResources> sharedResources) {
        this.predefinedOptions = (PredefinedOptions)((Object)Preconditions.checkNotNull((Object)((Object)predefinedOptions)));
        this.optionsFactory = optionsFactory;
        this.sharedResources = sharedResources;
        this.handlesToClose = new ArrayList();
    }

    public DBOptions getDbOptions() {
        DBOptions opt = this.predefinedOptions.createDBOptions(this.handlesToClose);
        this.handlesToClose.add((AutoCloseable)opt);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createDBOptions(opt, this.handlesToClose);
        }
        opt = opt.setCreateIfMissing(true);
        if (this.sharedResources != null) {
            opt.setWriteBufferManager(((RocksDBSharedResources)this.sharedResources.getResourceHandle()).getWriteBufferManager());
        }
        return opt;
    }

    public Long getWriteBufferManagerCapacity() {
        if (this.sharedResources == null) {
            return null;
        }
        return ((RocksDBSharedResources)this.sharedResources.getResourceHandle()).getWriteBufferManagerCapacity();
    }

    public ColumnFamilyOptions getColumnOptions() {
        ColumnFamilyOptions opt = this.predefinedOptions.createColumnOptions(this.handlesToClose);
        this.handlesToClose.add((AutoCloseable)opt);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createColumnOptions(opt, this.handlesToClose);
        }
        if (this.sharedResources != null) {
            BlockBasedTableConfig blockBasedTableConfig;
            RocksDBSharedResources rocksResources = (RocksDBSharedResources)this.sharedResources.getResourceHandle();
            Cache blockCache = rocksResources.getCache();
            TableFormatConfig tableFormatConfig = opt.tableFormatConfig();
            if (tableFormatConfig == null) {
                blockBasedTableConfig = new BlockBasedTableConfig();
            } else {
                Preconditions.checkArgument((boolean)(tableFormatConfig instanceof BlockBasedTableConfig), (Object)"We currently only support BlockBasedTableConfig When bounding total memory.");
                blockBasedTableConfig = (BlockBasedTableConfig)tableFormatConfig;
            }
            if (rocksResources.isUsingPartitionedIndexFilters() && this.overwriteFilterIfExist(blockBasedTableConfig)) {
                blockBasedTableConfig.setIndexType(IndexType.kTwoLevelIndexSearch);
                blockBasedTableConfig.setPartitionFilters(true);
                blockBasedTableConfig.setPinTopLevelIndexAndFilter(true);
            }
            blockBasedTableConfig.setBlockCache(blockCache);
            blockBasedTableConfig.setCacheIndexAndFilterBlocks(true);
            blockBasedTableConfig.setCacheIndexAndFilterBlocksWithHighPriority(true);
            blockBasedTableConfig.setPinL0FilterAndIndexBlocksInCache(true);
            opt.setTableFormatConfig((TableFormatConfig)blockBasedTableConfig);
        }
        return opt;
    }

    public WriteOptions getWriteOptions() {
        WriteOptions opt = new WriteOptions().setDisableWAL(true);
        this.handlesToClose.add((AutoCloseable)opt);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createWriteOptions(opt, this.handlesToClose);
        }
        return opt;
    }

    public ReadOptions getReadOptions() {
        ReadOptions opt = new ReadOptions();
        this.handlesToClose.add((AutoCloseable)opt);
        if (this.optionsFactory != null) {
            opt = this.optionsFactory.createReadOptions(opt, this.handlesToClose);
        }
        return opt;
    }

    RocksDBNativeMetricOptions getMemoryWatcherOptions(RocksDBNativeMetricOptions defaultMetricOptions) {
        return this.optionsFactory == null ? defaultMetricOptions : this.optionsFactory.createNativeMetricsOptions(defaultMetricOptions);
    }

    PredefinedOptions getPredefinedOptions() {
        return this.predefinedOptions;
    }

    @Nullable
    RocksDBOptionsFactory getOptionsFactory() {
        return this.optionsFactory;
    }

    @Override
    public void close() throws Exception {
        this.handlesToClose.forEach(IOUtils::closeQuietly);
        this.handlesToClose.clear();
        if (this.sharedResources != null) {
            this.sharedResources.close();
        }
    }

    private boolean overwriteFilterIfExist(BlockBasedTableConfig blockBasedTableConfig) {
        if (blockBasedTableConfig.filterPolicy() != null) {
            BloomFilter newFilter = new BloomFilter(10.0, false);
            LOG.info("Existing filter has been overwritten to full filters since partitioned index filters is enabled.");
            blockBasedTableConfig.setFilterPolicy((Filter)newFilter);
            this.handlesToClose.add((AutoCloseable)newFilter);
        }
        return true;
    }
}

