/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.DoneFuture;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.shaded.guava18.com.google.common.io.Closer;

public class OperatorSnapshotFutures {
    @Nonnull
    private RunnableFuture<SnapshotResult<KeyedStateHandle>> keyedStateManagedFuture;
    @Nonnull
    private RunnableFuture<SnapshotResult<KeyedStateHandle>> keyedStateRawFuture;
    @Nonnull
    private RunnableFuture<SnapshotResult<OperatorStateHandle>> operatorStateManagedFuture;
    @Nonnull
    private RunnableFuture<SnapshotResult<OperatorStateHandle>> operatorStateRawFuture;
    @Nonnull
    private Future<SnapshotResult<StateObjectCollection<InputChannelStateHandle>>> inputChannelStateFuture;
    @Nonnull
    private Future<SnapshotResult<StateObjectCollection<ResultSubpartitionStateHandle>>> resultSubpartitionStateFuture;

    public OperatorSnapshotFutures() {
        this((RunnableFuture<SnapshotResult<KeyedStateHandle>>)DoneFuture.of((Object)SnapshotResult.empty()), (RunnableFuture<SnapshotResult<KeyedStateHandle>>)DoneFuture.of((Object)SnapshotResult.empty()), (RunnableFuture<SnapshotResult<OperatorStateHandle>>)DoneFuture.of((Object)SnapshotResult.empty()), (RunnableFuture<SnapshotResult<OperatorStateHandle>>)DoneFuture.of((Object)SnapshotResult.empty()), (Future<SnapshotResult<StateObjectCollection<InputChannelStateHandle>>>)DoneFuture.of((Object)SnapshotResult.empty()), (Future<SnapshotResult<StateObjectCollection<ResultSubpartitionStateHandle>>>)DoneFuture.of((Object)SnapshotResult.empty()));
    }

    public OperatorSnapshotFutures(@Nonnull RunnableFuture<SnapshotResult<KeyedStateHandle>> keyedStateManagedFuture, @Nonnull RunnableFuture<SnapshotResult<KeyedStateHandle>> keyedStateRawFuture, @Nonnull RunnableFuture<SnapshotResult<OperatorStateHandle>> operatorStateManagedFuture, @Nonnull RunnableFuture<SnapshotResult<OperatorStateHandle>> operatorStateRawFuture, @Nonnull Future<SnapshotResult<StateObjectCollection<InputChannelStateHandle>>> inputChannelStateFuture, @Nonnull Future<SnapshotResult<StateObjectCollection<ResultSubpartitionStateHandle>>> resultSubpartitionStateFuture) {
        this.keyedStateManagedFuture = keyedStateManagedFuture;
        this.keyedStateRawFuture = keyedStateRawFuture;
        this.operatorStateManagedFuture = operatorStateManagedFuture;
        this.operatorStateRawFuture = operatorStateRawFuture;
        this.inputChannelStateFuture = inputChannelStateFuture;
        this.resultSubpartitionStateFuture = resultSubpartitionStateFuture;
    }

    @Nonnull
    public RunnableFuture<SnapshotResult<KeyedStateHandle>> getKeyedStateManagedFuture() {
        return this.keyedStateManagedFuture;
    }

    public void setKeyedStateManagedFuture(@Nonnull RunnableFuture<SnapshotResult<KeyedStateHandle>> keyedStateManagedFuture) {
        this.keyedStateManagedFuture = keyedStateManagedFuture;
    }

    @Nonnull
    public RunnableFuture<SnapshotResult<KeyedStateHandle>> getKeyedStateRawFuture() {
        return this.keyedStateRawFuture;
    }

    public void setKeyedStateRawFuture(@Nonnull RunnableFuture<SnapshotResult<KeyedStateHandle>> keyedStateRawFuture) {
        this.keyedStateRawFuture = keyedStateRawFuture;
    }

    @Nonnull
    public RunnableFuture<SnapshotResult<OperatorStateHandle>> getOperatorStateManagedFuture() {
        return this.operatorStateManagedFuture;
    }

    public void setOperatorStateManagedFuture(@Nonnull RunnableFuture<SnapshotResult<OperatorStateHandle>> operatorStateManagedFuture) {
        this.operatorStateManagedFuture = operatorStateManagedFuture;
    }

    @Nonnull
    public RunnableFuture<SnapshotResult<OperatorStateHandle>> getOperatorStateRawFuture() {
        return this.operatorStateRawFuture;
    }

    public void setOperatorStateRawFuture(@Nonnull RunnableFuture<SnapshotResult<OperatorStateHandle>> operatorStateRawFuture) {
        this.operatorStateRawFuture = operatorStateRawFuture;
    }

    @Nonnull
    public Future<SnapshotResult<StateObjectCollection<InputChannelStateHandle>>> getInputChannelStateFuture() {
        return this.inputChannelStateFuture;
    }

    public void setInputChannelStateFuture(@Nonnull Future<SnapshotResult<StateObjectCollection<InputChannelStateHandle>>> inputChannelStateFuture) {
        this.inputChannelStateFuture = inputChannelStateFuture;
    }

    @Nonnull
    public Future<SnapshotResult<StateObjectCollection<ResultSubpartitionStateHandle>>> getResultSubpartitionStateFuture() {
        return this.resultSubpartitionStateFuture;
    }

    public void setResultSubpartitionStateFuture(@Nonnull Future<SnapshotResult<StateObjectCollection<ResultSubpartitionStateHandle>>> resultSubpartitionStateFuture) {
        this.resultSubpartitionStateFuture = resultSubpartitionStateFuture;
    }

    public void cancel() throws Exception {
        ArrayList<Tuple2> pairs = new ArrayList<Tuple2>();
        pairs.add(new Tuple2(this.getKeyedStateManagedFuture(), (Object)"managed keyed"));
        pairs.add(new Tuple2(this.getKeyedStateRawFuture(), (Object)"managed operator"));
        pairs.add(new Tuple2(this.getOperatorStateManagedFuture(), (Object)"raw keyed"));
        pairs.add(new Tuple2(this.getOperatorStateRawFuture(), (Object)"raw operator"));
        pairs.add(new Tuple2(this.getInputChannelStateFuture(), (Object)"input channel"));
        pairs.add(new Tuple2(this.getResultSubpartitionStateFuture(), (Object)"result subpartition"));
        try (Closer closer = Closer.create();){
            for (Tuple2 pair : pairs) {
                closer.register(() -> {
                    try {
                        StateUtil.discardStateFuture((Future)((Future)pair.f0));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("Could not properly cancel %s state future", pair.f1), e);
                    }
                });
            }
        }
    }

    public Future<?>[] getAllFutures() {
        return new Future[]{this.keyedStateManagedFuture, this.keyedStateRawFuture, this.operatorStateManagedFuture, this.operatorStateRawFuture, this.inputChannelStateFuture, this.resultSubpartitionStateFuture};
    }
}

