/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.io.IOException;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.partition.consumer.CheckpointableInput;
import org.apache.flink.streaming.runtime.io.checkpointing.AlternatingWaitingForFirstBarrier;
import org.apache.flink.streaming.runtime.io.checkpointing.BarrierHandlerState;
import org.apache.flink.streaming.runtime.io.checkpointing.CollectingBarriersUnaligned;

final class WaitingForFirstBarrierUnaligned
implements BarrierHandlerState {
    private final boolean alternating;
    private final CheckpointableInput[] inputs;

    WaitingForFirstBarrierUnaligned(boolean alternating, CheckpointableInput[] inputs) {
        this.alternating = alternating;
        this.inputs = inputs;
    }

    @Override
    public BarrierHandlerState alignmentTimeout(BarrierHandlerState.Controller controller, CheckpointBarrier checkpointBarrier) {
        return this;
    }

    @Override
    public BarrierHandlerState announcementReceived(BarrierHandlerState.Controller controller, InputChannelInfo channelInfo, int sequenceNumber) throws IOException {
        this.inputs[channelInfo.getGateIdx()].convertToPriorityEvent(channelInfo.getInputChannelIdx(), sequenceNumber);
        return this;
    }

    @Override
    public BarrierHandlerState barrierReceived(BarrierHandlerState.Controller controller, InputChannelInfo channelInfo, CheckpointBarrier checkpointBarrier) throws CheckpointException, IOException {
        if (!checkpointBarrier.getCheckpointOptions().isUnalignedCheckpoint()) {
            this.inputs[channelInfo.getGateIdx()].resumeConsumption(channelInfo);
        }
        CheckpointBarrier unalignedBarrier = checkpointBarrier.asUnaligned();
        controller.initInputsCheckpoint(unalignedBarrier);
        for (CheckpointableInput input : this.inputs) {
            input.checkpointStarted(unalignedBarrier);
        }
        controller.triggerGlobalCheckpoint(unalignedBarrier);
        if (controller.allBarriersReceived()) {
            for (CheckpointableInput input : this.inputs) {
                input.checkpointStopped(unalignedBarrier.getId());
            }
            if (this.alternating) {
                return new AlternatingWaitingForFirstBarrier(this.inputs);
            }
            return this;
        }
        return new CollectingBarriersUnaligned(this.alternating, this.inputs);
    }

    @Override
    public BarrierHandlerState abort(long cancelledId) {
        if (this.alternating) {
            return new AlternatingWaitingForFirstBarrier(this.inputs);
        }
        return this;
    }
}

