/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.bridge.scala.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl$;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ExternalSchemaTranslator;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.SchemaResolver;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.StreamTableDescriptor;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.ExternalModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.OutputConversionModifyOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ScalaDataStreamQueryOperation;
import org.apache.flink.table.operations.ScalaExternalQueryOperation;
import org.apache.flink.table.operations.utils.OperationTreeBuilder;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.typeutils.FieldInfoUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Internal
@ScalaSignature(bytes="\u0006\u0001\u0011ud\u0001B\u0001\u0003\u0001M\u0011!d\u0015;sK\u0006lG+\u00192mK\u0016sg/\u001b:p]6,g\u000e^%na2T!a\u0001\u0003\u0002\u0011%tG/\u001a:oC2T!!\u0002\u0004\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005\u001dA\u0011A\u00022sS\u0012<WM\u0003\u0002\n\u0015\u0005\u0019\u0011\r]5\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001F\r\u0011\u0005U9R\"\u0001\f\u000b\u0005\rA\u0011B\u0001\r\u0017\u0005Q!\u0016M\u00197f\u000b:4\u0018N]8o[\u0016tG/S7qYB\u0011!dG\u0007\u0002\t%\u0011A\u0004\u0002\u0002\u0017'R\u0014X-Y7UC\ndW-\u00128wSJ|g.\\3oi\"Aa\u0004\u0001B\u0001B\u0003%q$\u0001\bdCR\fGn\\4NC:\fw-\u001a:\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\tR\u0011aB2bi\u0006dwnZ\u0005\u0003I\u0005\u0012abQ1uC2|w-T1oC\u001e,'\u000f\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u00035iw\u000eZ;mK6\u000bg.Y4feB\u0011\u0001fK\u0007\u0002S)\u0011!FC\u0001\u0007[>$W\u000f\\3\n\u00051J#!D'pIVdW-T1oC\u001e,'\u000f\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0003=1WO\\2uS>t7)\u0019;bY><\u0007C\u0001\u00111\u0013\t\t\u0014EA\bGk:\u001cG/[8o\u0007\u0006$\u0018\r\\8h\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014AB2p]\u001aLw\r\u0005\u00026m5\t\u0001\"\u0003\u00028\u0011\tYA+\u00192mK\u000e{gNZ5h\u0011!I\u0004A!A!\u0002\u0013Q\u0014!G:dC2\fW\t_3dkRLwN\\#om&\u0014xN\\7f]R\u0004\"a\u000f!\u000e\u0003qR!!B\u001f\u000b\u0005%q$BA \r\u0003%\u0019HO]3b[&tw-\u0003\u0002By\tQ2\u000b\u001e:fC6,\u00050Z2vi&|g.\u00128wSJ|g.\\3oi\"A1\t\u0001B\u0001B\u0003%A)A\u0004qY\u0006tg.\u001a:\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001dS\u0011A\u00033fY\u0016<\u0017\r^5p]&\u0011\u0011J\u0012\u0002\b!2\fgN\\3s\u0011!Y\u0005A!A!\u0002\u0013a\u0015\u0001C3yK\u000e,Ho\u001c:\u0011\u0005\u0015k\u0015B\u0001(G\u0005!)\u00050Z2vi>\u0014\b\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\u0002\u0017%\u001c8\u000b\u001e:fC6Lgn\u001a\t\u0003%Rk\u0011a\u0015\u0006\u0002\u000b%\u0011Qk\u0015\u0002\b\u0005>|G.Z1o\u0011!9\u0006A!A!\u0002\u0013A\u0016aD;tKJ\u001cE.Y:t\u0019>\fG-\u001a:\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016\u0001\u00027b]\u001eT\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`5\nY1\t\\1tg2{\u0017\rZ3s\u0011\u0015\t\u0007\u0001\"\u0001c\u0003\u0019a\u0014N\\5u}QQ1-\u001a4hQ&T7\u000e\\7\u0011\u0005\u0011\u0004Q\"\u0001\u0002\t\u000by\u0001\u0007\u0019A\u0010\t\u000b\u0019\u0002\u0007\u0019A\u0014\t\u000b9\u0002\u0007\u0019A\u0018\t\u000bM\u0002\u0007\u0019\u0001\u001b\t\u000be\u0002\u0007\u0019\u0001\u001e\t\u000b\r\u0003\u0007\u0019\u0001#\t\u000b-\u0003\u0007\u0019\u0001'\t\u000bA\u0003\u0007\u0019A)\t\u000b]\u0003\u0007\u0019\u0001-\t\u000b=\u0004A\u0011\t9\u0002\u001d\u0019\u0014x.\u001c#bi\u0006\u001cFO]3b[V\u0011\u0011\u000f \u000b\u0003eV\u0004\"!N:\n\u0005QD!!\u0002+bE2,\u0007\"\u0002<o\u0001\u00049\u0018A\u00033bi\u0006\u001cFO]3b[B\u00191\b\u001f>\n\u0005ed$A\u0003#bi\u0006\u001cFO]3b[B\u00111\u0010 \u0007\u0001\t\u0015ihN1\u0001\u007f\u0005\u0005!\u0016cA@\u0002\u0006A\u0019!+!\u0001\n\u0007\u0005\r1KA\u0004O_RD\u0017N\\4\u0011\u0007I\u000b9!C\u0002\u0002\nM\u00131!\u00118z\u0011\u0019y\u0007\u0001\"\u0011\u0002\u000eU!\u0011qBA\f)\u0015\u0011\u0018\u0011CA\r\u0011\u001d1\u00181\u0002a\u0001\u0003'\u0001Ba\u000f=\u0002\u0016A\u001910a\u0006\u0005\ru\fYA1\u0001\u007f\u0011!\tY\"a\u0003A\u0002\u0005u\u0011AB:dQ\u0016l\u0017\rE\u00026\u0003?I1!!\t\t\u0005\u0019\u00196\r[3nC\"9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0012a\u00054s_6\u001c\u0005.\u00198hK2|wm\u0015;sK\u0006lGc\u0001:\u0002*!9a/a\tA\u0002\u0005-\u0002\u0003B\u001ey\u0003[\u0001B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003ga\u0011!\u0002;za\u0016\u001c\u0018\u0002BA\u001c\u0003c\u00111AU8x\u0011\u001d\t)\u0003\u0001C!\u0003w!RA]A\u001f\u0003\u007fAqA^A\u001d\u0001\u0004\tY\u0003\u0003\u0005\u0002\u001c\u0005e\u0002\u0019AA\u000f\u0011\u001d\t)\u0003\u0001C!\u0003\u0007\"rA]A#\u0003\u000f\nI\u0005C\u0004w\u0003\u0003\u0002\r!a\u000b\t\u0011\u0005m\u0011\u0011\ta\u0001\u0003;A\u0001\"a\u0013\u0002B\u0001\u0007\u0011QJ\u0001\u000eG\"\fgnZ3m_\u001elu\u000eZ3\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015\u000b\u0003%\u0019wN\u001c8fGR|'/\u0003\u0003\u0002X\u0005E#!D\"iC:<W\r\\8h\u001b>$W\rC\u0004\u0002\\\u0001!\t%!\u0018\u0002'\r\u0014X-\u0019;f)\u0016l\u0007o\u001c:bef4\u0016.Z<\u0016\t\u0005}\u0013q\u0011\u000b\u0007\u0003C\n9'!!\u0011\u0007I\u000b\u0019'C\u0002\u0002fM\u0013A!\u00168ji\"A\u0011\u0011NA-\u0001\u0004\tY'\u0001\u0003qCRD\u0007\u0003BA7\u0003wrA!a\u001c\u0002xA\u0019\u0011\u0011O*\u000e\u0005\u0005M$bAA;%\u00051AH]8pizJ1!!\u001fT\u0003\u0019\u0001&/\u001a3fM&!\u0011QPA@\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011P*\t\u000fY\fI\u00061\u0001\u0002\u0004B!1\b_AC!\rY\u0018q\u0011\u0003\u0007{\u0006e#\u0019\u0001@\t\u000f\u0005m\u0003\u0001\"\u0011\u0002\fV!\u0011QRAL)!\t\t'a$\u0002\u0012\u0006e\u0005\u0002CA5\u0003\u0013\u0003\r!a\u001b\t\u000fY\fI\t1\u0001\u0002\u0014B!1\b_AK!\rY\u0018q\u0013\u0003\u0007{\u0006%%\u0019\u0001@\t\u0011\u0005m\u0011\u0011\u0012a\u0001\u0003;Aq!!(\u0001\t\u0013\ty*\u0001\nge>l7\u000b\u001e:fC6Le\u000e^3s]\u0006dW\u0003BAQ\u0003c#\u0012B]AR\u0003g\u000b9-!4\t\u000fY\fY\n1\u0001\u0002&B1\u0011qUAW\u0003_k!!!+\u000b\u0007\u0005-V(\u0001\u0006eCR\f7\u000f\u001e:fC6L1!_AU!\rY\u0018\u0011\u0017\u0003\u0007{\u0006m%\u0019\u0001@\t\u0011\u0005m\u00111\u0014a\u0001\u0003;AC!a-\u00028B!\u0011\u0011XAb\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016AC1o]>$\u0018\r^5p]*\u0011\u0011\u0011Y\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003\u000b\fYL\u0001\u0005Ok2d\u0017M\u00197f\u0011!\tI-a'A\u0002\u0005-\u0014\u0001\u0003<jK^\u0004\u0016\r\u001e5)\t\u0005\u001d\u0017q\u0017\u0005\t\u0003\u0017\nY\n1\u0001\u0002N!9\u0011\u0011\u001b\u0001\u0005B\u0005M\u0017\u0001\u0004;p\t\u0006$\u0018m\u0015;sK\u0006lG\u0003BA\u0016\u0003+DaaCAh\u0001\u0004\u0011\bbBAi\u0001\u0011\u0005\u0013\u0011\\\u000b\u0005\u00037\f\t\u000f\u0006\u0004\u0002^\u0006\r\u0018Q\u001d\t\u0005wa\fy\u000eE\u0002|\u0003C$a!`Al\u0005\u0004q\bBB\u0006\u0002X\u0002\u0007!\u000f\u0003\u0005\u0002h\u0006]\u0007\u0019AAu\u0003-!\u0018M]4fi\u000ec\u0017m]:\u0011\r\u00055\u00141^Ap\u0013\u0011\ti/a \u0003\u000b\rc\u0017m]:\t\u000f\u0005E\u0007\u0001\"\u0011\u0002rV!\u00111_A})\u0019\t)0a?\u0002~B!1\b_A|!\rY\u0018\u0011 \u0003\u0007{\u0006=(\u0019\u0001@\t\r-\ty\u000f1\u0001s\u0011!\ty0a<A\u0002\t\u0005\u0011A\u0004;be\u001e,G\u000fR1uCRK\b/\u001a\u0019\u0005\u0005\u0007\u0011y\u0001\u0005\u0004\u0003\u0006\t%!QB\u0007\u0003\u0005\u000fQ1!a\r\u000b\u0013\u0011\u0011YAa\u0002\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0007cA>\u0003\u0010\u0011Y!\u0011CA\u007f\u0003\u0003\u0005\tQ!\u0001\u007f\u0005\ryF%\r\u0005\b\u0005+\u0001A\u0011\tB\f\u0003E!xn\u00115b]\u001e,Gn\\4TiJ,\u0017-\u001c\u000b\u0005\u0003W\u0011I\u0002\u0003\u0004\f\u0005'\u0001\rA\u001d\u0005\b\u0005+\u0001A\u0011\tB\u000f)\u0019\tYCa\b\u0003\"!11Ba\u0007A\u0002ID\u0001Ba\t\u0003\u001c\u0001\u0007\u0011QD\u0001\ri\u0006\u0014x-\u001a;TG\",W.\u0019\u0005\b\u0005+\u0001A\u0011\tB\u0014)!\tYC!\u000b\u0003,\t5\u0002BB\u0006\u0003&\u0001\u0007!\u000f\u0003\u0005\u0003$\t\u0015\u0002\u0019AA\u000f\u0011!\tYE!\nA\u0002\u00055\u0003b\u0002B\u0019\u0001\u0011%!1G\u0001\u0011i>\u001cFO]3b[&sG/\u001a:oC2,BA!\u000e\u0003<QA!q\u0007B\u001f\u0005\u007f\u0011\t\u0006\u0005\u0003<q\ne\u0002cA>\u0003<\u00111QPa\fC\u0002yDaa\u0003B\u0018\u0001\u0004\u0011\b\u0002\u0003B!\u0005_\u0001\rAa\u0011\u0002/M\u001c\u0007.Z7b)J\fgn\u001d7bi&|gNU3tk2$\b\u0003\u0002B#\u0005\u0017r1\u0001\tB$\u0013\r\u0011I%I\u0001\u0019\u000bb$XM\u001d8bYN\u001b\u0007.Z7b)J\fgn\u001d7bi>\u0014\u0018\u0002\u0002B'\u0005\u001f\u0012AbT;uaV$(+Z:vYRT1A!\u0013\"\u0011!\tYEa\fA\u0002\u00055\u0003\u0006\u0002B)\u0003oCqA!\r\u0001\t\u0013\u00119&\u0006\u0003\u0003Z\t}CC\u0002B.\u0005C\u0012\u0019\u0007\u0005\u0003<q\nu\u0003cA>\u0003`\u00111QP!\u0016C\u0002yDaa\u0003B+\u0001\u0004\u0011\b\u0002\u0003B3\u0005+\u0002\rAa\u001a\u0002\u001f5|G-\u001b4z\u001fB,'/\u0019;j_:\u0004BA!\u001b\u0003p5\u0011!1\u000e\u0006\u0004\u0005[R\u0011AC8qKJ\fG/[8og&!!\u0011\u000fB6\u0005=iu\u000eZ5gs>\u0003XM]1uS>t\u0007BB8\u0001\t\u0003\u0012)(\u0006\u0003\u0003x\t}D#\u0002:\u0003z\t\u0005\u0005b\u0002<\u0003t\u0001\u0007!1\u0010\t\u0005wa\u0014i\bE\u0002|\u0005\u007f\"a! B:\u0005\u0004q\b\u0002\u0003BB\u0005g\u0002\rA!\"\u0002\r\u0019LW\r\u001c3t!\u0015\u0011&q\u0011BF\u0013\r\u0011Ii\u0015\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0003\u0002BG\u0005'k!Aa$\u000b\u0007\tE%\"A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002\u0002BK\u0005\u001f\u0013!\"\u0012=qe\u0016\u001c8/[8o\u0011\u001d\u0011I\n\u0001C!\u00057\u000b!C]3hSN$XM\u001d#bi\u0006\u001cFO]3b[V!!Q\u0014BU)\u0019\t\tGa(\u0003$\"A!\u0011\u0015BL\u0001\u0004\tY'\u0001\u0003oC6,\u0007b\u0002<\u0003\u0018\u0002\u0007!Q\u0015\t\u0005wa\u00149\u000bE\u0002|\u0005S#a! BL\u0005\u0004q\bb\u0002BM\u0001\u0011\u0005#QV\u000b\u0005\u0005_\u0013I\f\u0006\u0005\u0002b\tE&1\u0017B^\u0011!\u0011\tKa+A\u0002\u0005-\u0004b\u0002<\u0003,\u0002\u0007!Q\u0017\t\u0005wa\u00149\fE\u0002|\u0005s#a! BV\u0005\u0004q\b\u0002\u0003BB\u0005W\u0003\rA!\"\t\u000f\t}\u0006\u0001\"\u0011\u0003B\u0006qAo\\!qa\u0016tGm\u0015;sK\u0006lW\u0003\u0002Bb\u0005\u0017$BA!2\u0003dR!!q\u0019Bg!\u0011Y\u0004P!3\u0011\u0007m\u0014Y\r\u0002\u0004~\u0005{\u0013\rA \u0005\u000b\u0005\u001f\u0014i,!AA\u0004\tE\u0017AC3wS\u0012,gnY3%cA1!1\u001bBp\u0005\u0013l!A!6\u000b\t\t]'\u0011\\\u0001\tif\u0004X-\u001b8g_*!!1\u001cBo\u0003\u0019\u0019w.\\7p]*\u0011\u0011\u0002D\u0005\u0005\u0005C\u0014)NA\bUsB,\u0017J\u001c4pe6\fG/[8o\u0011\u0019Y!Q\u0018a\u0001e\"9!q\u001d\u0001\u0005B\t%\u0018a\u0004;p%\u0016$(/Y2u'R\u0014X-Y7\u0016\t\t-(\u0011 \u000b\u0005\u0005[\u001c\t\u0001\u0006\u0003\u0003p\nm\b\u0003B\u001ey\u0005c\u0004bA\u0015Bz#\n]\u0018b\u0001B{'\n1A+\u001e9mKJ\u00022a\u001fB}\t\u0019i(Q\u001db\u0001}\"Q!Q Bs\u0003\u0003\u0005\u001dAa@\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007\u0005\u0004\u0003T\n}'q\u001f\u0005\u0007\u0017\t\u0015\b\u0019\u0001:\t\u000f\r\u0015\u0001\u0001\"\u0011\u0004\b\u0005\u0001\"/Z4jgR,'OR;oGRLwN\\\u000b\u0005\u0007\u0013\u0019)\u0002\u0006\u0004\u0004\f\r]1\u0011\u0004\u000b\u0005\u0003C\u001ai\u0001\u0003\u0006\u0004\u0010\r\r\u0011\u0011!a\u0002\u0007#\t!\"\u001a<jI\u0016t7-\u001a\u00134!\u0019\u0011\u0019Na8\u0004\u0014A\u00191p!\u0006\u0005\ru\u001c\u0019A1\u0001\u007f\u0011!\u0011\tka\u0001A\u0002\u0005-\u0004\u0002CB\u000e\u0007\u0007\u0001\ra!\b\u0002\u0005Q4\u0007CBB\u0010\u0007K\u0019\u0019\"\u0004\u0002\u0004\")\u001911\u0005\u0006\u0002\u0013\u0019,hn\u0019;j_:\u001c\u0018\u0002BB\u0014\u0007C\u0011Q\u0002V1cY\u00164UO\\2uS>t\u0007bBB\u0003\u0001\u0011\u000531F\u000b\u0007\u0007[\u0019Ida\u0011\u0015\r\r=2qIB%)\u0019\t\tg!\r\u0004<!Q11GB\u0015\u0003\u0003\u0005\u001da!\u000e\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007\u0005\u0004\u0003T\n}7q\u0007\t\u0004w\u000eeBAB?\u0004*\t\u0007a\u0010\u0003\u0006\u0004>\r%\u0012\u0011!a\u0002\u0007\u007f\t!\"\u001a<jI\u0016t7-\u001a\u00136!\u0019\u0011\u0019Na8\u0004BA\u00191pa\u0011\u0005\u000f\r\u00153\u0011\u0006b\u0001}\n\u0019\u0011iQ\"\t\u0011\t\u00056\u0011\u0006a\u0001\u0003WB\u0001ba\u0013\u0004*\u0001\u00071QJ\u0001\u0002MBA1qDB(\u0007o\u0019\t%\u0003\u0003\u0004R\r\u0005\"!E!hOJ,w-\u0019;f\rVt7\r^5p]\"91Q\u0001\u0001\u0005B\rUSCBB,\u0007G\u001ai\u0007\u0006\u0004\u0004Z\r=4\u0011\u000f\u000b\u0007\u0003C\u001aYf!\u001a\t\u0015\ru31KA\u0001\u0002\b\u0019y&\u0001\u0006fm&$WM\\2fIY\u0002bAa5\u0003`\u000e\u0005\u0004cA>\u0004d\u00111Qpa\u0015C\u0002yD!ba\u001a\u0004T\u0005\u0005\t9AB5\u0003))g/\u001b3f]\u000e,Ge\u000e\t\u0007\u0005'\u0014yna\u001b\u0011\u0007m\u001ci\u0007B\u0004\u0004F\rM#\u0019\u0001@\t\u0011\t\u000561\u000ba\u0001\u0003WB\u0001ba\u0013\u0004T\u0001\u000711\u000f\t\t\u0007?\u0019)h!\u0019\u0004l%!1qOB\u0011\u0005Y!\u0016M\u00197f\u0003\u001e<'/Z4bi\u00164UO\\2uS>t\u0007bBB>\u0001\u0011\u00053QP\u0001\bG>tg.Z2u)\u0011\u0019yha#\u0011\t\r\u00055qQ\u0007\u0003\u0007\u0007S1a!\"\u000b\u0003-!Wm]2sSB$xN]:\n\t\r%51\u0011\u0002\u0016'R\u0014X-Y7UC\ndW\rR3tGJL\u0007\u000f^8s\u0011!\u0019ii!\u001fA\u0002\r=\u0015aE2p]:,7\r^8s\t\u0016\u001c8M]5qi>\u0014\b\u0003BBA\u0007#KAaa%\u0004\u0004\n\u00192i\u001c8oK\u000e$xN\u001d#fg\u000e\u0014\u0018\u000e\u001d;pe\"91q\u0013\u0001\u0005R\re\u0015a\u0005<bY&$\u0017\r^3UC\ndWmU8ve\u000e,G\u0003BA1\u00077C\u0001b!(\u0004\u0016\u0002\u00071qT\u0001\fi\u0006\u0014G.Z*pkJ\u001cW\r\r\u0003\u0004\"\u000e=\u0006CBBR\u0007S\u001bi+\u0004\u0002\u0004&*\u00191q\u0015\u0006\u0002\u000fM|WO]2fg&!11VBS\u0005-!\u0016M\u00197f'>,(oY3\u0011\u0007m\u001cy\u000bB\u0006\u00042\u000em\u0015\u0011!A\u0001\u0006\u0003q(aA0%e!91Q\u0017\u0001\u0005\n\r]\u0016!E4fiR\u0013\u0018M\\:g_Jl\u0017\r^5p]V!1\u0011XBe)\u0019\u0019Yla3\u0004NB11QXBb\u0007\u000fl!aa0\u000b\t\r\u0005'Q\\\u0001\u0004I\u0006<\u0017\u0002BBc\u0007\u007f\u0013a\u0002\u0016:b]N4wN]7bi&|g\u000eE\u0002|\u0007\u0013$a!`BZ\u0005\u0004q\bBB\u0006\u00044\u0002\u0007!\u000f\u0003\u0005\u0004P\u000eM\u0006\u0019ABi\u0003=!(/\u00198tM>\u0014X.\u0019;j_:\u001c\bCBBj\u00073\u001ci.\u0004\u0002\u0004V*\u00191q\u001b/\u0002\tU$\u0018\u000e\\\u0005\u0005\u00077\u001c)N\u0001\u0003MSN$\b\u0007BBp\u0007G\u0004ba!0\u0004D\u000e\u0005\bcA>\u0004d\u0012Y1Q]Bg\u0003\u0003\u0005\tQ!\u0001\u007f\u0005\ryFe\r\u0005\b\u0007S\u0004A\u0011BBv\u0003A\t7/U;fef|\u0005/\u001a:bi&|g.\u0006\u0003\u0004n\u000e]HCBBx\u0007s\u001ci\u0010\u0005\u0004\u0003j\rE8Q_\u0005\u0005\u0007g\u0014YGA\u000fTG\u0006d\u0017\rR1uCN#(/Z1n#V,'/_(qKJ\fG/[8o!\rY8q\u001f\u0003\u0007{\u000e\u001d(\u0019\u0001@\t\u000fY\u001c9\u000f1\u0001\u0004|B!1\b_B{\u0011!\u0011\u0019ia:A\u0002\r}\b#\u0002*\u0005\u0002\u0011\u0015\u0011b\u0001C\u0002'\n1q\n\u001d;j_:\u0004baa5\u0004Z\n-\u0005b\u0002C\u0005\u0001\u0011EC1B\u0001\u0016cV\fG.\u001b4z#V,'/_(qKJ\fG/[8o)\u0019!i\u0001b\u0005\u0005\u001eA!!\u0011\u000eC\b\u0013\u0011!\tBa\u001b\u0003\u001dE+XM]=Pa\u0016\u0014\u0018\r^5p]\"AAQ\u0003C\u0004\u0001\u0004!9\"\u0001\u0006jI\u0016tG/\u001b4jKJ\u00042\u0001\tC\r\u0013\r!Y\"\t\u0002\u0011\u001f\nTWm\u0019;JI\u0016tG/\u001b4jKJD\u0001\u0002b\b\u0005\b\u0001\u0007AQB\u0001\u000fcV,'/_(qKJ\fG/[8o\u0011\u001d\tY\u0006\u0001C!\tG)B\u0001\"\n\u00050QA\u0011\u0011\rC\u0014\tS!\t\u0004\u0003\u0005\u0002j\u0011\u0005\u0002\u0019AA6\u0011\u001d1H\u0011\u0005a\u0001\tW\u0001Ba\u000f=\u0005.A\u00191\u0010b\f\u0005\ru$\tC1\u0001\u007f\u0011!\u0011\u0019\t\"\tA\u0002\t\u0015\u0005f\u0001\u0001\u00056A!Aq\u0007C\u001e\u001b\t!IDC\u0002\u0002>2IA\u0001\"\u0010\u0005:\tA\u0011J\u001c;fe:\fGnB\u0004\u0005B\tA\t\u0001b\u0011\u00025M#(/Z1n)\u0006\u0014G.Z#om&\u0014xN\\7f]RLU\u000e\u001d7\u0011\u0007\u0011$)E\u0002\u0004\u0002\u0005!\u0005AqI\n\u0005\t\u000b\"I\u0005E\u0002S\t\u0017J1\u0001\"\u0014T\u0005\u0019\te.\u001f*fM\"9\u0011\r\"\u0012\u0005\u0002\u0011ECC\u0001C\"\u0011!!)\u0006\"\u0012\u0005\u0002\u0011]\u0013AB2sK\u0006$X\rF\u0004d\t3\"i\u0006b\u001a\t\u000f\u0011mC1\u000ba\u0001u\u0005!R\r_3dkRLwN\\#om&\u0014xN\\7f]RD\u0001\u0002b\u0018\u0005T\u0001\u0007A\u0011M\u0001\tg\u0016$H/\u001b8hgB\u0019Q\u0007b\u0019\n\u0007\u0011\u0015\u0004BA\nF]ZL'o\u001c8nK:$8+\u001a;uS:<7\u000fC\u0004\u0005j\u0011M\u0003\u0019\u0001\u001b\u0002\u0017Q\f'\r\\3D_:4\u0017n\u001a\u0005\t\t[\")\u0005\"\u0003\u0005p\u0005qAn\\8lkB,\u00050Z2vi>\u0014H#\u0002'\u0005r\u0011m\u0004\u0002\u0003C:\tW\u0002\r\u0001\"\u001e\u0002%\u0015DXmY;u_J\u0004&o\u001c9feRLWm\u001d\t\t\u0007'$9(a\u001b\u0002l%!A\u0011PBk\u0005\ri\u0015\r\u001d\u0005\b\t7\"Y\u00071\u0001;\u0001")
public class StreamTableEnvironmentImpl
extends TableEnvironmentImpl
implements StreamTableEnvironment {
    private final CatalogManager catalogManager;
    private final FunctionCatalog functionCatalog;
    private final StreamExecutionEnvironment scalaExecutionEnvironment;
    private final Planner planner;

    public static StreamTableEnvironmentImpl create(StreamExecutionEnvironment streamExecutionEnvironment, EnvironmentSettings environmentSettings, TableConfig tableConfig) {
        return StreamTableEnvironmentImpl$.MODULE$.create(streamExecutionEnvironment, environmentSettings, tableConfig);
    }

    @Override
    public <T> Table fromDataStream(org.apache.flink.streaming.api.scala.DataStream<T> dataStream) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), null, null, ChangelogMode.insertOnly());
    }

    @Override
    public <T> Table fromDataStream(org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Schema schema) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), schema, null, ChangelogMode.insertOnly());
    }

    @Override
    public Table fromChangelogStream(org.apache.flink.streaming.api.scala.DataStream<Row> dataStream) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), null, null, ChangelogMode.all());
    }

    @Override
    public Table fromChangelogStream(org.apache.flink.streaming.api.scala.DataStream<Row> dataStream, Schema schema) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), schema, null, ChangelogMode.all());
    }

    @Override
    public Table fromChangelogStream(org.apache.flink.streaming.api.scala.DataStream<Row> dataStream, Schema schema, ChangelogMode changelogMode) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), schema, null, changelogMode);
    }

    @Override
    public <T> void createTemporaryView(String path, org.apache.flink.streaming.api.scala.DataStream<T> dataStream) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        this.createTemporaryView(path, this.fromStreamInternal(dataStream.javaStream(), null, path, ChangelogMode.insertOnly()));
    }

    @Override
    public <T> void createTemporaryView(String path, org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Schema schema) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        this.createTemporaryView(path, this.fromStreamInternal(dataStream.javaStream(), schema, path, ChangelogMode.insertOnly()));
    }

    private <T> Table fromStreamInternal(DataStream<T> dataStream, @Nullable Schema schema, @Nullable String viewPath, ChangelogMode changelogMode) {
        Preconditions.checkNotNull((Object)changelogMode, (String)"Changelog mode must not be null.");
        CatalogManager catalogManager = this.getCatalogManager();
        SchemaResolver schemaResolver = catalogManager.getSchemaResolver();
        OperationTreeBuilder operationTreeBuilder = this.getOperationTreeBuilder();
        UnresolvedIdentifier unresolvedIdentifier = viewPath != null ? this.getParser().parseIdentifier(viewPath) : UnresolvedIdentifier.of((String[])new String[]{new StringBuilder(31).append("Unregistered_DataStream_Source_").append(dataStream.getId()).toString()});
        ObjectIdentifier objectIdentifier = catalogManager.qualifyIdentifier(unresolvedIdentifier);
        ExternalSchemaTranslator.InputResult schemaTranslationResult = ExternalSchemaTranslator.fromExternal((DataTypeFactory)catalogManager.getDataTypeFactory(), (TypeInformation)dataStream.getType(), (Schema)schema);
        ResolvedSchema resolvedSchema = schemaTranslationResult.getSchema().resolve(schemaResolver);
        ScalaExternalQueryOperation<T> scanOperation = new ScalaExternalQueryOperation<T>(objectIdentifier, dataStream, schemaTranslationResult.getPhysicalDataType(), schemaTranslationResult.isTopLevelRecord(), changelogMode, resolvedSchema);
        List projections = schemaTranslationResult.getProjections();
        if (projections == null) {
            return this.createTable(scanOperation);
        }
        QueryOperation projectOperation = operationTreeBuilder.project(Arrays.asList((Object[])new Expression[]{package$.MODULE$.array2ArrayConstructor(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(projections).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> ApiExpressionUtils.unresolvedRef((String)x$1), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(UnresolvedReferenceExpression.class)))}), scanOperation);
        return this.createTable(projectOperation);
    }

    @Override
    public org.apache.flink.streaming.api.scala.DataStream<Row> toDataStream(Table table) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        DataType sourceType = table.getResolvedSchema().toSourceRowDataType();
        return this.toDataStream(table, (AbstractDataType<?>)sourceType);
    }

    @Override
    public <T> org.apache.flink.streaming.api.scala.DataStream<T> toDataStream(Table table, Class<T> targetClass) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull(targetClass, (String)"Target class must not be null.");
        Class<T> clazz = targetClass;
        Class<Row> clazz2 = Row.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return this.toDataStream(table);
        }
        return this.toDataStream(table, (AbstractDataType<?>)DataTypes.of(targetClass));
    }

    @Override
    public <T> org.apache.flink.streaming.api.scala.DataStream<T> toDataStream(Table table, AbstractDataType<?> targetDataType) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull(targetDataType, (String)"Target data type must not be null.");
        ExternalSchemaTranslator.OutputResult schemaTranslationResult = ExternalSchemaTranslator.fromInternal((DataTypeFactory)this.catalogManager.getDataTypeFactory(), (ResolvedSchema)table.getResolvedSchema(), targetDataType);
        return this.toStreamInternal(table, schemaTranslationResult, ChangelogMode.insertOnly());
    }

    @Override
    public org.apache.flink.streaming.api.scala.DataStream<Row> toChangelogStream(Table table) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        ExternalSchemaTranslator.OutputResult schemaTranslationResult = ExternalSchemaTranslator.fromInternal((ResolvedSchema)table.getResolvedSchema(), null);
        return this.toStreamInternal(table, schemaTranslationResult, null);
    }

    @Override
    public org.apache.flink.streaming.api.scala.DataStream<Row> toChangelogStream(Table table, Schema targetSchema) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull((Object)targetSchema, (String)"Target schema must not be null.");
        ExternalSchemaTranslator.OutputResult schemaTranslationResult = ExternalSchemaTranslator.fromInternal((ResolvedSchema)table.getResolvedSchema(), (Schema)targetSchema);
        return this.toStreamInternal(table, schemaTranslationResult, null);
    }

    @Override
    public org.apache.flink.streaming.api.scala.DataStream<Row> toChangelogStream(Table table, Schema targetSchema, ChangelogMode changelogMode) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull((Object)targetSchema, (String)"Target schema must not be null.");
        Preconditions.checkNotNull((Object)changelogMode, (String)"Changelog mode must not be null.");
        ExternalSchemaTranslator.OutputResult schemaTranslationResult = ExternalSchemaTranslator.fromInternal((ResolvedSchema)table.getResolvedSchema(), (Schema)targetSchema);
        return this.toStreamInternal(table, schemaTranslationResult, changelogMode);
    }

    private <T> org.apache.flink.streaming.api.scala.DataStream<T> toStreamInternal(Table table, ExternalSchemaTranslator.OutputResult schemaTranslationResult, @Nullable ChangelogMode changelogMode) {
        QueryOperation queryOperation;
        CatalogManager catalogManager = this.getCatalogManager();
        SchemaResolver schemaResolver = catalogManager.getSchemaResolver();
        OperationTreeBuilder operationTreeBuilder = this.getOperationTreeBuilder();
        Optional optionalProjections = schemaTranslationResult.getProjections();
        if (optionalProjections.isPresent()) {
            List projections = (List)optionalProjections.get();
            queryOperation = operationTreeBuilder.project((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(projections).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> ApiExpressionUtils.unresolvedRef((String)x$1), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1, Buffer$.MODULE$.canBuildFrom())).asJava(), table.getQueryOperation());
        } else {
            queryOperation = table.getQueryOperation();
        }
        QueryOperation projectOperation = queryOperation;
        ResolvedSchema resolvedSchema = schemaResolver.resolve(schemaTranslationResult.getSchema());
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])new String[]{new StringBuilder(29).append("Unregistered_DataStream_Sink_").append(ExternalModifyOperation.getUniqueId()).toString()});
        ObjectIdentifier objectIdentifier = catalogManager.qualifyIdentifier(unresolvedIdentifier);
        ExternalModifyOperation modifyOperation = new ExternalModifyOperation(objectIdentifier, projectOperation, resolvedSchema, changelogMode, schemaTranslationResult.getPhysicalDataType().orElse(resolvedSchema.toPhysicalRowDataType()));
        return this.toStreamInternal(table, (ModifyOperation)modifyOperation);
    }

    private <T> org.apache.flink.streaming.api.scala.DataStream<T> toStreamInternal(Table table, ModifyOperation modifyOperation) {
        List transformations = this.planner.translate(Collections.singletonList(modifyOperation));
        Transformation<T> streamTransformation = this.getTransformation(table, transformations);
        this.scalaExecutionEnvironment.getWrappedStreamExecutionEnvironment().addOperator(streamTransformation);
        return new org.apache.flink.streaming.api.scala.DataStream(new DataStream(this.scalaExecutionEnvironment.getWrappedStreamExecutionEnvironment(), streamTransformation));
    }

    @Override
    public <T> Table fromDataStream(org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Seq<Expression> fields) {
        ScalaDataStreamQueryOperation<T> queryOperation = this.asQueryOperation(dataStream, (Option<List<Expression>>)new Some(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)fields.toList()).asJava()));
        return this.createTable(queryOperation);
    }

    @Override
    public <T> void registerDataStream(String name, org.apache.flink.streaming.api.scala.DataStream<T> dataStream) {
        this.registerTable(name, this.fromDataStream(dataStream));
    }

    @Override
    public <T> void registerDataStream(String name, org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Seq<Expression> fields) {
        this.registerTable(name, this.fromDataStream(dataStream, fields));
    }

    @Override
    public <T> org.apache.flink.streaming.api.scala.DataStream<T> toAppendStream(Table table, TypeInformation<T> evidence$1) {
        TypeInformation<T> returnType = evidence$1;
        OutputConversionModifyOperation modifyOperation = new OutputConversionModifyOperation(table.getQueryOperation(), TypeConversions.fromLegacyInfoToDataType(returnType), OutputConversionModifyOperation.UpdateMode.APPEND);
        return this.toStreamInternal(table, (ModifyOperation)modifyOperation);
    }

    @Override
    public <T> org.apache.flink.streaming.api.scala.DataStream<Tuple2<Object, T>> toRetractStream(Table table, TypeInformation<T> evidence$2) {
        CaseClassTypeInfo returnType = new CaseClassTypeInfo<Tuple2<Object, T>>(null, evidence$2){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, T>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, T>> unused = new ScalaCaseClassSerializer<Tuple2<Object, T>>(this, fieldSerializers){

                    public Tuple2<Object, T> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[0])), fields[1]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        };
        OutputConversionModifyOperation modifyOperation = new OutputConversionModifyOperation(table.getQueryOperation(), TypeConversions.fromLegacyInfoToDataType((TypeInformation)returnType), OutputConversionModifyOperation.UpdateMode.RETRACT);
        return this.toStreamInternal(table, (ModifyOperation)modifyOperation);
    }

    @Override
    public <T> void registerFunction(String name, TableFunction<T> tf, TypeInformation<T> evidence$3) {
        TypeInformation typeInfo = UserDefinedFunctionHelper.getReturnTypeOfTableFunction(tf, (TypeInformation)((TypeInformation)Predef$.MODULE$.implicitly(evidence$3)));
        this.functionCatalog.registerTempSystemTableFunction(name, tf, typeInfo);
    }

    @Override
    public <T, ACC> void registerFunction(String name, AggregateFunction<T, ACC> f, TypeInformation<T> evidence$4, TypeInformation<ACC> evidence$5) {
        TypeInformation typeInfo = UserDefinedFunctionHelper.getReturnTypeOfAggregateFunction(f, (TypeInformation)((TypeInformation)Predef$.MODULE$.implicitly(evidence$4)));
        TypeInformation accTypeInfo = UserDefinedFunctionHelper.getAccumulatorTypeOfAggregateFunction(f, (TypeInformation)((TypeInformation)Predef$.MODULE$.implicitly(evidence$5)));
        this.functionCatalog.registerTempSystemAggregateFunction(name, f, typeInfo, accTypeInfo);
    }

    @Override
    public <T, ACC> void registerFunction(String name, TableAggregateFunction<T, ACC> f, TypeInformation<T> evidence$6, TypeInformation<ACC> evidence$7) {
        TypeInformation typeInfo = UserDefinedFunctionHelper.getReturnTypeOfAggregateFunction(f, (TypeInformation)((TypeInformation)Predef$.MODULE$.implicitly(evidence$6)));
        TypeInformation accTypeInfo = UserDefinedFunctionHelper.getAccumulatorTypeOfAggregateFunction(f, (TypeInformation)((TypeInformation)Predef$.MODULE$.implicitly(evidence$7)));
        this.functionCatalog.registerTempSystemAggregateFunction(name, f, typeInfo, accTypeInfo);
    }

    @Override
    public StreamTableDescriptor connect(ConnectorDescriptor connectorDescriptor) {
        return (StreamTableDescriptor)super.connect(connectorDescriptor);
    }

    public void validateTableSource(TableSource<?> tableSource) {
        super.validateTableSource(tableSource);
        if (TableSourceValidation.hasRowtimeAttribute(tableSource)) {
            TimeCharacteristic timeCharacteristic = this.scalaExecutionEnvironment.getStreamTimeCharacteristic();
            TimeCharacteristic timeCharacteristic2 = TimeCharacteristic.EventTime;
            if (timeCharacteristic == null ? timeCharacteristic2 != null : !timeCharacteristic.equals(timeCharacteristic2)) {
                throw new TableException(String.format("A rowtime attribute requires an EventTime time characteristic in stream environment. But is: %s}", this.scalaExecutionEnvironment.getStreamTimeCharacteristic()));
            }
        }
    }

    private <T> Transformation<T> getTransformation(Table table, List<Transformation<?>> transformations) {
        if (transformations.size() != 1) {
            throw new TableException(String.format("Expected a single transformation for query: %s\n Got: %s", table.getQueryOperation().asSummaryString(), transformations));
        }
        return transformations.get(0);
    }

    private <T> ScalaDataStreamQueryOperation<T> asQueryOperation(org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Option<List<Expression>> fields) {
        TypeInformation streamType = dataStream.javaStream().getType();
        FieldInfoUtils.TypeInfoSchema typeInfoSchema = (FieldInfoUtils.TypeInfoSchema)fields.map((Function1 & Serializable & scala.Serializable)f -> {
            void var3_3;
            FieldInfoUtils.TypeInfoSchema fieldsInfo = FieldInfoUtils.getFieldsInfo((TypeInformation)streamType, (Expression[])((Expression[])f.toArray((Object[])new Expression[0])));
            if (fieldsInfo.isRowtimeDefined() && $this.scalaExecutionEnvironment.getStreamTimeCharacteristic() != TimeCharacteristic.EventTime) {
                throw new ValidationException(String.format("A rowtime attribute requires an EventTime time characteristic in stream environment. But is: %s", $this.scalaExecutionEnvironment.getStreamTimeCharacteristic()));
            }
            return var3_3;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> FieldInfoUtils.getFieldsInfo((TypeInformation)streamType));
        return new ScalaDataStreamQueryOperation(dataStream.javaStream(), typeInfoSchema.getIndices(), typeInfoSchema.toResolvedSchema());
    }

    public QueryOperation qualifyQueryOperation(ObjectIdentifier identifier, QueryOperation queryOperation) {
        ScalaDataStreamQueryOperation scalaDataStreamQueryOperation;
        ScalaDataStreamQueryOperation scalaDataStreamQueryOperation2 = queryOperation;
        if (scalaDataStreamQueryOperation2 instanceof ScalaDataStreamQueryOperation) {
            ScalaDataStreamQueryOperation scalaDataStreamQueryOperation3 = scalaDataStreamQueryOperation2;
            scalaDataStreamQueryOperation = new ScalaDataStreamQueryOperation(identifier, scalaDataStreamQueryOperation3.getDataStream(), scalaDataStreamQueryOperation3.getFieldIndices(), scalaDataStreamQueryOperation3.getResolvedSchema());
        } else {
            scalaDataStreamQueryOperation = queryOperation;
        }
        return scalaDataStreamQueryOperation;
    }

    @Override
    public <T> void createTemporaryView(String path, org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Seq<Expression> fields) {
        this.createTemporaryView(path, this.fromDataStream(dataStream, fields));
    }

    public StreamTableEnvironmentImpl(CatalogManager catalogManager, ModuleManager moduleManager, FunctionCatalog functionCatalog, TableConfig config, StreamExecutionEnvironment scalaExecutionEnvironment, Planner planner, Executor executor, boolean isStreaming, ClassLoader userClassLoader) {
        this.catalogManager = catalogManager;
        this.functionCatalog = functionCatalog;
        this.scalaExecutionEnvironment = scalaExecutionEnvironment;
        this.planner = planner;
        super(catalogManager, moduleManager, config, executor, functionCatalog, planner, isStreaming, userClassLoader);
    }
}

