/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RexImplicationChecker;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.mutable.Holder;
import org.apache.calcite.rel.mutable.MutableAggregate;
import org.apache.calcite.rel.mutable.MutableFilter;
import org.apache.calcite.rel.mutable.MutableProject;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRelVisitor;
import org.apache.calcite.rel.mutable.MutableRels;
import org.apache.calcite.rel.mutable.MutableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.flink.calcite.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.LinkedHashMultimap;
import org.apache.flink.calcite.shaded.com.google.common.collect.Multimap;
import org.apache.flink.calcite.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;

public class SubstitutionVisitor {
    private static final boolean DEBUG = CalciteSystemProperty.DEBUG.value();
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    protected static final ImmutableList<UnifyRule> DEFAULT_RULES = ImmutableList.of(TrivialRule.access$000(), ScanToProjectUnifyRule.INSTANCE, ProjectToProjectUnifyRule.INSTANCE, FilterToProjectUnifyRule.INSTANCE, AggregateToAggregateUnifyRule.INSTANCE, AggregateOnProjectToAggregateUnifyRule.INSTANCE);
    protected final RelBuilder relBuilder;
    private final ImmutableList<UnifyRule> rules;
    private final Map<Pair<Class, Class>, List<UnifyRule>> ruleMap = new HashMap<Pair<Class, Class>, List<UnifyRule>>();
    private final RelOptCluster cluster;
    private final RexSimplify simplify;
    private final Holder query;
    private final MutableRel target;
    final List<MutableRel> targetLeaves;
    final List<MutableRel> queryLeaves;
    final Map<MutableRel, MutableRel> replacementMap = new HashMap<MutableRel, MutableRel>();
    final Multimap<MutableRel, MutableRel> equivalents = LinkedHashMultimap.create();
    protected final MutableRel[] slots = new MutableRel[2];

    public SubstitutionVisitor(RelNode target_, RelNode query_) {
        this(target_, query_, DEFAULT_RULES, RelFactories.LOGICAL_BUILDER);
    }

    public SubstitutionVisitor(RelNode target_, RelNode query_, ImmutableList<UnifyRule> rules) {
        this(target_, query_, rules, RelFactories.LOGICAL_BUILDER);
    }

    public SubstitutionVisitor(RelNode target_, RelNode query_, ImmutableList<UnifyRule> rules, RelBuilderFactory relBuilderFactory) {
        this.cluster = target_.getCluster();
        RexExecutor executor = Util.first(this.cluster.getPlanner().getExecutor(), RexUtil.EXECUTOR);
        RelOptPredicateList predicates = RelOptPredicateList.EMPTY;
        this.simplify = new RexSimplify(this.cluster.getRexBuilder(), predicates, executor);
        this.rules = rules;
        this.query = Holder.of(MutableRels.toMutable(query_));
        this.target = MutableRels.toMutable(target_);
        this.relBuilder = relBuilderFactory.create(this.cluster, null);
        final Set parents = Sets.newIdentityHashSet();
        final ArrayList allNodes = new ArrayList();
        MutableRelVisitor visitor = new MutableRelVisitor(){

            @Override
            public void visit(MutableRel node) {
                parents.add(node.getParent());
                allNodes.add(node);
                super.visit(node);
            }
        };
        visitor.go(this.target);
        allNodes.removeAll(parents);
        this.targetLeaves = ImmutableList.copyOf(allNodes);
        allNodes.clear();
        parents.clear();
        visitor.go(this.query);
        allNodes.removeAll(parents);
        this.queryLeaves = ImmutableList.copyOf(allNodes);
    }

    void register(MutableRel result, MutableRel query) {
    }

    @VisibleForTesting
    public static RexNode splitFilter(RexSimplify simplify, RexNode condition, RexNode target) {
        RexNode x2;
        RexNode r;
        RexNode target2;
        RexBuilder rexBuilder = simplify.rexBuilder;
        RexNode condition2 = SubstitutionVisitor.canonizeNode(rexBuilder, condition);
        RexNode z = SubstitutionVisitor.splitOr(rexBuilder, condition2, target2 = SubstitutionVisitor.canonizeNode(rexBuilder, target));
        if (z != null) {
            return z;
        }
        if (SubstitutionVisitor.isEquivalent(rexBuilder, condition2, target2)) {
            return rexBuilder.makeLiteral(true);
        }
        RexNode x = RexUtil.andNot(rexBuilder, target2, condition2);
        if (SubstitutionVisitor.mayBeSatisfiable(x) && !(r = SubstitutionVisitor.canonizeNode(rexBuilder, simplify.simplifyUnknownAsFalse(x2 = RexUtil.composeConjunction(rexBuilder, ImmutableList.of(condition2, target2))))).isAlwaysFalse() && SubstitutionVisitor.isEquivalent(rexBuilder, condition2, r)) {
            List<RexNode> conjs = RelOptUtil.conjunctions(r);
            for (RexNode e : RelOptUtil.conjunctions(target2)) {
                RexUtil.removeAll(conjs, e);
            }
            return RexUtil.composeConjunction(rexBuilder, conjs);
        }
        return null;
    }

    private static RexNode canonizeNode(RexBuilder rexBuilder, RexNode condition) {
        switch (condition.getKind()) {
            case AND: 
            case OR: {
                RexCall call = (RexCall)condition;
                TreeMap<String, RexNode> newOperands = new TreeMap<String, RexNode>();
                for (RexNode operand : call.operands) {
                    operand = SubstitutionVisitor.canonizeNode(rexBuilder, operand);
                    newOperands.put(operand.toString(), operand);
                }
                if (newOperands.size() < 2) {
                    return (RexNode)newOperands.values().iterator().next();
                }
                return rexBuilder.makeCall(call.getOperator(), ImmutableList.copyOf(newOperands.values()));
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: {
                RexCall call = (RexCall)condition;
                RexNode left = call.getOperands().get(0);
                RexNode right = call.getOperands().get(1);
                if (left.toString().compareTo(right.toString()) <= 0) {
                    return call;
                }
                return RexUtil.invert(rexBuilder, call);
            }
        }
        return condition;
    }

    private static RexNode splitOr(RexBuilder rexBuilder, RexNode condition, RexNode target) {
        List<RexNode> conditions = RelOptUtil.disjunctions(condition);
        int conditionsLength = conditions.size();
        int targetsLength = 0;
        for (RexNode e : RelOptUtil.disjunctions(target)) {
            RexUtil.removeAll(conditions, e);
            ++targetsLength;
        }
        if (conditions.isEmpty() && conditionsLength == targetsLength) {
            return rexBuilder.makeLiteral(true);
        }
        if (conditions.isEmpty()) {
            return condition;
        }
        return null;
    }

    private static boolean isEquivalent(RexBuilder rexBuilder, RexNode condition, RexNode target) {
        HashSet<String> targetDisjunctions;
        HashSet<String> conditionDisjunctions = new HashSet<String>(RexUtil.strings(RelOptUtil.conjunctions(condition)));
        return conditionDisjunctions.equals(targetDisjunctions = new HashSet<String>(RexUtil.strings(RelOptUtil.conjunctions(target))));
    }

    public static boolean mayBeSatisfiable(RexNode e) {
        ArrayList<RexNode> disjunctions = new ArrayList<RexNode>();
        ArrayList<RexNode> notDisjunctions = new ArrayList<RexNode>();
        RelOptUtil.decomposeConjunction(e, disjunctions, notDisjunctions);
        for (RexNode disjunction : disjunctions) {
            switch (disjunction.getKind()) {
                case LITERAL: {
                    if (RexLiteral.booleanValue(disjunction)) break;
                    return false;
                }
            }
        }
        for (RexNode disjunction : notDisjunctions) {
            switch (disjunction.getKind()) {
                case LITERAL: {
                    if (!RexLiteral.booleanValue(disjunction)) break;
                    return false;
                }
            }
        }
        for (RexNode notDisjunction : notDisjunctions) {
            List<RexNode> disjunctions2 = RelOptUtil.conjunctions(notDisjunction);
            if (!disjunctions.containsAll(disjunctions2)) continue;
            return false;
        }
        return true;
    }

    public RelNode go0(RelNode replacement_) {
        MutableRel node0;
        assert (false);
        MutableRel replacement = MutableRels.toMutable(replacement_);
        assert (SubstitutionVisitor.equalType("target", this.target, "replacement", replacement, Litmus.THROW));
        this.replacementMap.put(this.target, replacement);
        UnifyResult unifyResult = this.matchRecurse(this.target);
        if (unifyResult == null) {
            return null;
        }
        MutableRel node = node0 = unifyResult.result;
        if (DEBUG) {
            System.out.println("Convert: query:\n" + this.query.deep() + "\nunify.query:\n" + ((UnifyResult)unifyResult).call.query.deep() + "\nunify.result:\n" + unifyResult.result.deep() + "\nunify.target:\n" + ((UnifyResult)unifyResult).call.target.deep() + "\nnode0:\n" + node0.deep() + "\nnode:\n" + node.deep());
        }
        return MutableRels.fromMutable(node, this.relBuilder);
    }

    public List<RelNode> go(RelNode replacement_) {
        List<List<Replacement>> matches2 = this.go(MutableRels.toMutable(replacement_));
        if (matches2.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<RelNode> sub = new ArrayList<RelNode>();
        sub.add(MutableRels.fromMutable(this.query.getInput(), this.relBuilder));
        SubstitutionVisitor.reverseSubstitute(this.relBuilder, this.query, matches2, sub, 0, matches2.size());
        return sub;
    }

    private List<List<Replacement>> go(MutableRel replacement) {
        int count;
        assert (SubstitutionVisitor.equalType("target", this.target, "replacement", replacement, Litmus.THROW));
        List<MutableRel> queryDescendants = MutableRels.descendants(this.query);
        List<MutableRel> targetDescendants = MutableRels.descendants(this.target);
        HashMap<MutableRel, MutableRel> map = new HashMap<MutableRel, MutableRel>();
        for (MutableRel queryDescendant : queryDescendants) {
            map.put(queryDescendant, queryDescendant);
        }
        for (MutableRel targetDescendant : targetDescendants) {
            MutableRel queryDescendant = (MutableRel)map.get(targetDescendant);
            if (queryDescendant == null) continue;
            assert (this.rowTypesAreEquivalent(queryDescendant, targetDescendant, Litmus.THROW));
            this.equivalents.put(queryDescendant, targetDescendant);
        }
        map.clear();
        ArrayList<Replacement> attempted = new ArrayList<Replacement>();
        ArrayList<List<Replacement>> substitutions = new ArrayList<List<Replacement>>();
        block2: do {
            count = 0;
            MutableRel queryDescendant = this.query;
            block3: while (queryDescendant != null) {
                for (Replacement r : attempted) {
                    if (queryDescendant != r.after) continue;
                    queryDescendant = MutableRels.preOrderTraverseNext(queryDescendant);
                    continue block3;
                }
                MutableRel next = MutableRels.preOrderTraverseNext(queryDescendant);
                MutableRel childOrNext = ((MutableRel)queryDescendant).getInputs().isEmpty() ? next : ((MutableRel)queryDescendant).getInputs().get(0);
                for (MutableRel targetDescendant : targetDescendants) {
                    for (UnifyRule rule : this.applicableRules(queryDescendant, targetDescendant)) {
                        UnifyResult result;
                        UnifyRuleCall call = rule.match(this, queryDescendant, targetDescendant);
                        if (call == null || (result = rule.apply(call)) == null) continue;
                        ++count;
                        attempted.add(new Replacement(((UnifyResult)result).call.query, result.result));
                        ((UnifyResult)result).call.query.replaceInParent(result.result);
                        for (int i = 0; i < rule.slotCount; ++i) {
                            Collection<MutableRel> equi = this.equivalents.get(this.slots[i]);
                            if (equi.isEmpty()) continue;
                            this.equivalents.remove(this.slots[i], equi.iterator().next());
                        }
                        assert (this.rowTypesAreEquivalent(result.result, ((UnifyResult)result).call.query, Litmus.THROW));
                        this.equivalents.put(result.result, ((UnifyResult)result).call.query);
                        if (targetDescendant != this.target) continue block2;
                        if (!this.target.equals(replacement)) {
                            Replacement r = SubstitutionVisitor.replace(this.query.getInput(), this.target, replacement.clone());
                            assert (r != null) : rule + "should have returned a result containing the target.";
                            attempted.add(r);
                        }
                        substitutions.add(ImmutableList.copyOf(attempted));
                        attempted.clear();
                        queryDescendant = next;
                        continue block3;
                    }
                }
                queryDescendant = childOrNext;
            }
        } while (count != 0 && !attempted.isEmpty());
        if (!attempted.isEmpty()) {
            SubstitutionVisitor.undoReplacement(attempted);
        }
        return substitutions;
    }

    private boolean rowTypesAreEquivalent(MutableRel rel0, MutableRel rel1, Litmus litmus) {
        if (rel0.rowType.getFieldCount() != rel1.rowType.getFieldCount()) {
            return litmus.fail("Mismatch for column count: [{}]", Pair.of(rel0, rel1));
        }
        for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(rel0.rowType.getFieldList(), rel0.rowType.getFieldList())) {
            if (((RelDataTypeField)pair.left).getType().equals(((RelDataTypeField)pair.right).getType())) continue;
            return litmus.fail("Mismatch for column type: [{}]", Pair.of(rel0, rel1));
        }
        return litmus.succeed();
    }

    public static Replacement replace(MutableRel query, MutableRel find, MutableRel replace) {
        if (find.equals(replace)) {
            return null;
        }
        assert (SubstitutionVisitor.equalType("find", find, "replace", replace, Litmus.THROW));
        return SubstitutionVisitor.replaceRecurse(query, find, replace);
    }

    private static Replacement replaceRecurse(MutableRel query, MutableRel find, MutableRel replace) {
        if (find.equals(query)) {
            query.replaceInParent(replace);
            return new Replacement(query, replace);
        }
        for (MutableRel input : query.getInputs()) {
            Replacement r = SubstitutionVisitor.replaceRecurse(input, find, replace);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private static void undoReplacement(List<Replacement> replacement) {
        for (int i = replacement.size() - 1; i >= 0; --i) {
            Replacement r = replacement.get(i);
            r.after.replaceInParent(r.before);
        }
    }

    private static void redoReplacement(List<Replacement> replacement) {
        for (Replacement r : replacement) {
            r.before.replaceInParent(r.after);
        }
    }

    private static void reverseSubstitute(RelBuilder relBuilder, Holder query, List<List<Replacement>> matches2, List<RelNode> sub, int replaceCount, int maxCount) {
        if (matches2.isEmpty()) {
            return;
        }
        List<List<Replacement>> rem = matches2.subList(1, matches2.size());
        SubstitutionVisitor.reverseSubstitute(relBuilder, query, rem, sub, replaceCount, maxCount);
        SubstitutionVisitor.undoReplacement(matches2.get(0));
        if (++replaceCount < maxCount) {
            sub.add(MutableRels.fromMutable(query.getInput(), relBuilder));
        }
        SubstitutionVisitor.reverseSubstitute(relBuilder, query, rem, sub, replaceCount, maxCount);
        SubstitutionVisitor.redoReplacement(matches2.get(0));
    }

    private UnifyResult matchRecurse(MutableRel target) {
        assert (false);
        List<MutableRel> targetInputs = target.getInputs();
        MutableRel queryParent = null;
        for (MutableRel targetInput : targetInputs) {
            UnifyResult unifyResult = this.matchRecurse(targetInput);
            if (unifyResult == null) {
                return null;
            }
            queryParent = ((UnifyResult)unifyResult).call.query.replaceInParent(unifyResult.result);
        }
        if (targetInputs.isEmpty()) {
            for (MutableRel queryLeaf : this.queryLeaves) {
                for (UnifyRule rule : this.applicableRules(queryLeaf, target)) {
                    UnifyResult x = this.apply(rule, queryLeaf, target);
                    if (x == null) continue;
                    if (DEBUG) {
                        System.out.println("Rule: " + rule + "\nQuery:\n" + queryParent + (((UnifyResult)x).call.query != queryParent ? "\nQuery (original):\n" + queryParent : "") + "\nTarget:\n" + target.deep() + "\nResult:\n" + x.result.deep() + "\n");
                    }
                    return x;
                }
            }
        } else {
            assert (queryParent != null);
            for (UnifyRule rule : this.applicableRules(queryParent, target)) {
                UnifyResult x = this.apply(rule, queryParent, target);
                if (x == null) continue;
                if (DEBUG) {
                    System.out.println("Rule: " + rule + "\nQuery:\n" + queryParent.deep() + (((UnifyResult)x).call.query != queryParent ? "\nQuery (original):\n" + queryParent.toString() : "") + "\nTarget:\n" + target.deep() + "\nResult:\n" + x.result.deep() + "\n");
                }
                return x;
            }
        }
        if (DEBUG) {
            System.out.println("Unify failed:\nQuery:\n" + queryParent.toString() + "\nTarget:\n" + target.toString() + "\n");
        }
        return null;
    }

    private UnifyResult apply(UnifyRule rule, MutableRel query, MutableRel target) {
        UnifyRuleCall call = new UnifyRuleCall(rule, query, target, ImmutableList.of());
        return rule.apply(call);
    }

    private List<UnifyRule> applicableRules(MutableRel query, MutableRel target) {
        Class<?> targetClass;
        Class<?> queryClass = query.getClass();
        Pair<Class<?>, Class<?>> key = Pair.of(queryClass, targetClass = target.getClass());
        Collection<UnifyRule> list = this.ruleMap.get(key);
        if (list == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (UnifyRule rule : this.rules) {
                if (!SubstitutionVisitor.mightMatch(rule, queryClass, targetClass)) continue;
                builder.add(rule);
            }
            list = builder.build();
            this.ruleMap.put((Pair<Class, Class>)key, (List<UnifyRule>)list);
        }
        return list;
    }

    private static boolean mightMatch(UnifyRule rule, Class queryClass, Class targetClass) {
        return rule.queryOperand.clazz.isAssignableFrom(queryClass) && rule.targetOperand.clazz.isAssignableFrom(targetClass);
    }

    public static MutableAggregate permute(MutableAggregate aggregate, MutableRel input, Mapping mapping) {
        ImmutableBitSet groupSet = Mappings.apply(mapping, aggregate.groupSet);
        ImmutableList<ImmutableBitSet> groupSets = Mappings.apply2(mapping, aggregate.groupSets);
        List<AggregateCall> aggregateCalls2 = Util.transform(aggregate.aggCalls, call -> call.transform(mapping));
        return MutableAggregate.of(input, groupSet, groupSets, aggregateCalls2);
    }

    public static MutableRel unifyAggregates(MutableAggregate query, MutableAggregate target) {
        MutableRel result;
        if (query.groupSets.equals(target.groupSets)) {
            ArrayList<Integer> projects = new ArrayList<Integer>();
            int groupCount = query.groupSet.cardinality();
            for (int i = 0; i < groupCount; ++i) {
                projects.add(i);
            }
            for (AggregateCall aggregateCall : query.aggCalls) {
                int i = target.aggCalls.indexOf(aggregateCall);
                if (i < 0) {
                    return null;
                }
                projects.add(groupCount + i);
            }
            result = MutableRels.createProject(target, projects);
        } else if (target.getGroupType() == Aggregate.Group.SIMPLE) {
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            target.groupSet.forEach(k -> map.put((Integer)k, map.size()));
            for (int c : query.groupSet) {
                if (map.containsKey(c)) continue;
                return null;
            }
            ImmutableBitSet groupSet = query.groupSet.permute(map);
            ImmutableList<ImmutableBitSet> groupSets = null;
            if (query.getGroupType() != Aggregate.Group.SIMPLE) {
                groupSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute(query.groupSets, map));
            }
            ArrayList<AggregateCall> aggregateCalls2 = new ArrayList<AggregateCall>();
            for (AggregateCall aggregateCall : query.aggCalls) {
                if (aggregateCall.isDistinct()) {
                    return null;
                }
                int i = target.aggCalls.indexOf(aggregateCall);
                if (i < 0) {
                    return null;
                }
                aggregateCalls2.add(AggregateCall.create(SubstitutionVisitor.getRollup(aggregateCall.getAggregation()), aggregateCall.isDistinct(), aggregateCall.isApproximate(), aggregateCall.ignoreNulls(), ImmutableList.of(Integer.valueOf(target.groupSet.cardinality() + i)), -1, aggregateCall.collation, aggregateCall.type, aggregateCall.name));
            }
            result = MutableAggregate.of(target, groupSet, groupSets, aggregateCalls2);
        } else {
            return null;
        }
        return MutableRels.createCastRel(result, query.rowType, true);
    }

    public static SqlAggFunction getRollup(SqlAggFunction aggregation) {
        if (aggregation == SqlStdOperatorTable.SUM || aggregation == SqlStdOperatorTable.MIN || aggregation == SqlStdOperatorTable.MAX || aggregation == SqlStdOperatorTable.SUM0 || aggregation == SqlStdOperatorTable.ANY_VALUE) {
            return aggregation;
        }
        if (aggregation == SqlStdOperatorTable.COUNT) {
            return SqlStdOperatorTable.SUM0;
        }
        return null;
    }

    protected static RexShuttle getRexShuttle(MutableProject target) {
        final HashMap<RexNode, Integer> map = new HashMap<RexNode, Integer>();
        for (RexNode e : target.projects) {
            map.put(e, map.size());
        }
        return new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef ref) {
                Integer integer = (Integer)map.get(ref);
                if (integer != null) {
                    return new RexInputRef(integer, ref.getType());
                }
                throw MatchFailed.INSTANCE;
            }

            @Override
            public RexNode visitCall(RexCall call) {
                Integer integer = (Integer)map.get(call);
                if (integer != null) {
                    return new RexInputRef(integer, call.getType());
                }
                return super.visitCall(call);
            }

            @Override
            public RexNode visitLiteral(RexLiteral literal) {
                Integer integer = (Integer)map.get(literal);
                if (integer != null) {
                    return new RexInputRef(integer, literal.getType());
                }
                return super.visitLiteral(literal);
            }
        };
    }

    protected boolean isWeaker(MutableRel rel0, MutableRel rel) {
        MutableRel relinput;
        if (rel0 == rel || this.equivalents.get(rel0).contains(rel)) {
            return false;
        }
        if (!(rel0 instanceof MutableFilter) || !(rel instanceof MutableFilter)) {
            return false;
        }
        if (!rel.rowType.equals(rel0.rowType)) {
            return false;
        }
        MutableRel rel0input = ((MutableFilter)rel0).getInput();
        if (rel0input != (relinput = ((MutableFilter)rel).getInput()) && !this.equivalents.get(rel0input).contains(relinput)) {
            return false;
        }
        RexExecutorImpl rexImpl = (RexExecutorImpl)rel.cluster.getPlanner().getExecutor();
        RexImplicationChecker rexImplicationChecker = new RexImplicationChecker(rel.cluster.getRexBuilder(), rexImpl, rel.rowType);
        return rexImplicationChecker.implies(((MutableFilter)rel0).condition, ((MutableFilter)rel).condition);
    }

    public static boolean equalType(String desc0, MutableRel rel0, String desc1, MutableRel rel1, Litmus litmus) {
        return RelOptUtil.equal(desc0, rel0.rowType, desc1, rel1.rowType, litmus);
    }

    public static class FilterOnProjectRule
    extends RelOptRule {
        public static final FilterOnProjectRule INSTANCE = new FilterOnProjectRule(RelFactories.LOGICAL_BUILDER);

        public FilterOnProjectRule(RelBuilderFactory relBuilderFactory) {
            super(FilterOnProjectRule.operandJ(LogicalFilter.class, null, filter -> filter.getCondition() instanceof RexInputRef, FilterOnProjectRule.some(FilterOnProjectRule.operand(LogicalProject.class, FilterOnProjectRule.any()), new RelOptRuleOperand[0])), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalFilter filter = (LogicalFilter)call.rel(0);
            LogicalProject project = (LogicalProject)call.rel(1);
            ArrayList<RexNode> newProjects = new ArrayList<RexNode>(project.getProjects());
            newProjects.add(filter.getCondition());
            RelOptCluster cluster = filter.getCluster();
            RelDataType newRowType = ((RelDataTypeFactory.FieldInfoBuilder)cluster.getTypeFactory().builder().addAll(project.getRowType().getFieldList())).add("condition", Util.last(newProjects).getType()).build();
            Project newProject = project.copy(project.getTraitSet(), project.getInput(), newProjects, newRowType);
            RexInputRef newCondition = cluster.getRexBuilder().makeInputRef(newProject, newProjects.size() - 1);
            call.transformTo(LogicalFilter.create(newProject, newCondition));
        }
    }

    private static class SlotCounter {
        int queryCount;
        int targetCount;

        private SlotCounter() {
        }

        void visit(Operand operand) {
            if (operand instanceof QueryOperand) {
                ++this.queryCount;
            } else if (operand instanceof TargetOperand) {
                ++this.targetCount;
            } else if (!(operand instanceof AnyOperand)) {
                for (Operand input : ((InternalOperand)operand).inputs) {
                    this.visit(input);
                }
            }
        }
    }

    private static class TargetOperand
    extends Operand {
        private final int ordinal;

        protected TargetOperand(int ordinal) {
            super(MutableRel.class);
            this.ordinal = ordinal;
        }

        @Override
        public boolean matches(SubstitutionVisitor visitor, MutableRel rel) {
            MutableRel rel0 = visitor.slots[this.ordinal];
            assert (rel0 != null) : "QueryOperand should have been called first";
            return rel0 == rel || visitor.equivalents.get(rel0).contains(rel);
        }

        @Override
        public boolean isWeaker(SubstitutionVisitor visitor, MutableRel rel) {
            MutableRel rel0 = visitor.slots[this.ordinal];
            assert (rel0 != null) : "QueryOperand should have been called first";
            return visitor.isWeaker(rel0, rel);
        }
    }

    private static class QueryOperand
    extends Operand {
        private final int ordinal;

        protected QueryOperand(int ordinal) {
            super(MutableRel.class);
            this.ordinal = ordinal;
        }

        @Override
        public boolean matches(SubstitutionVisitor visitor, MutableRel rel) {
            visitor.slots[this.ordinal] = rel;
            return true;
        }
    }

    private static class AnyOperand
    extends Operand {
        AnyOperand(Class<? extends MutableRel> clazz) {
            super(clazz);
        }

        @Override
        public boolean matches(SubstitutionVisitor visitor, MutableRel rel) {
            return this.clazz.isInstance(rel);
        }
    }

    private static class InternalOperand
    extends Operand {
        private final List<Operand> inputs;

        InternalOperand(Class<? extends MutableRel> clazz, List<Operand> inputs) {
            super(clazz);
            this.inputs = inputs;
        }

        @Override
        public boolean matches(SubstitutionVisitor visitor, MutableRel rel) {
            return this.clazz.isInstance(rel) && InternalOperand.allMatch(visitor, this.inputs, rel.getInputs());
        }

        @Override
        public boolean isWeaker(SubstitutionVisitor visitor, MutableRel rel) {
            return this.clazz.isInstance(rel) && InternalOperand.allWeaker(visitor, this.inputs, rel.getInputs());
        }

        private static boolean allMatch(SubstitutionVisitor visitor, List<Operand> operands, List<MutableRel> rels) {
            if (operands.size() != rels.size()) {
                return false;
            }
            for (Pair<Operand, MutableRel> pair : Pair.zip(operands, rels)) {
                if (((Operand)pair.left).matches(visitor, (MutableRel)pair.right)) continue;
                return false;
            }
            return true;
        }

        private static boolean allWeaker(SubstitutionVisitor visitor, List<Operand> operands, List<MutableRel> rels) {
            if (operands.size() != rels.size()) {
                return false;
            }
            for (Pair<Operand, MutableRel> pair : Pair.zip(operands, rels)) {
                if (((Operand)pair.left).isWeaker(visitor, (MutableRel)pair.right)) continue;
                return false;
            }
            return true;
        }
    }

    protected static abstract class Operand {
        protected final Class<? extends MutableRel> clazz;

        protected Operand(Class<? extends MutableRel> clazz) {
            this.clazz = clazz;
        }

        public abstract boolean matches(SubstitutionVisitor var1, MutableRel var2);

        public boolean isWeaker(SubstitutionVisitor visitor, MutableRel rel) {
            return false;
        }
    }

    private static class AggregateOnProjectToAggregateUnifyRule
    extends AbstractUnifyRule {
        public static final AggregateOnProjectToAggregateUnifyRule INSTANCE = new AggregateOnProjectToAggregateUnifyRule();

        private AggregateOnProjectToAggregateUnifyRule() {
            super(AggregateOnProjectToAggregateUnifyRule.operand(MutableAggregate.class, AggregateOnProjectToAggregateUnifyRule.operand(MutableProject.class, AggregateOnProjectToAggregateUnifyRule.query(0))), AggregateOnProjectToAggregateUnifyRule.operand(MutableAggregate.class, AggregateOnProjectToAggregateUnifyRule.target(0)), 1);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            MutableAggregate query = (MutableAggregate)call.query;
            MutableAggregate target = (MutableAggregate)call.target;
            if (!(query.getInput() instanceof MutableProject)) {
                return null;
            }
            MutableProject project = (MutableProject)query.getInput();
            if (project.getInput() != target.getInput()) {
                return null;
            }
            Mappings.TargetMapping mapping = project.getMapping();
            if (mapping == null) {
                return null;
            }
            Mapping inverseMapping = mapping.inverse();
            MutableAggregate aggregate2 = SubstitutionVisitor.permute(query, project.getInput(), inverseMapping);
            MutableRel unifiedAggregate = SubstitutionVisitor.unifyAggregates(aggregate2, target);
            if (unifiedAggregate == null) {
                return null;
            }
            MutableRel result = unifiedAggregate;
            if (!Mappings.keepsOrdering(mapping)) {
                ArrayList<Integer> posList = new ArrayList<Integer>();
                int fieldCount = aggregate2.rowType.getFieldCount();
                for (int group : aggregate2.groupSet) {
                    if (inverseMapping.getTargetOpt(group) == -1) continue;
                    posList.add(inverseMapping.getTarget(group));
                }
                for (int i = posList.size(); i < fieldCount; ++i) {
                    posList.add(i);
                }
                result = MutableRels.createProject(unifiedAggregate, posList);
            }
            return call.result(result);
        }
    }

    private static class AggregateToAggregateUnifyRule
    extends AbstractUnifyRule {
        public static final AggregateToAggregateUnifyRule INSTANCE = new AggregateToAggregateUnifyRule();

        private AggregateToAggregateUnifyRule() {
            super(AggregateToAggregateUnifyRule.operand(MutableAggregate.class, AggregateToAggregateUnifyRule.query(0)), AggregateToAggregateUnifyRule.operand(MutableAggregate.class, AggregateToAggregateUnifyRule.target(0)), 1);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            MutableAggregate query = (MutableAggregate)call.query;
            MutableAggregate target = (MutableAggregate)call.target;
            assert (query != target);
            if (query.getInput() != target.getInput()) {
                return null;
            }
            if (!target.groupSet.contains(query.groupSet)) {
                return null;
            }
            MutableRel result = SubstitutionVisitor.unifyAggregates(query, target);
            if (result == null) {
                return null;
            }
            return call.result(result);
        }
    }

    private static class ProjectToFilterUnifyRule
    extends AbstractUnifyRule {
        public static final ProjectToFilterUnifyRule INSTANCE = new ProjectToFilterUnifyRule();

        private ProjectToFilterUnifyRule() {
            super(ProjectToFilterUnifyRule.operand(MutableProject.class, ProjectToFilterUnifyRule.query(0)), ProjectToFilterUnifyRule.operand(MutableFilter.class, ProjectToFilterUnifyRule.target(0)), 1);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            if (call.query.getParent() instanceof MutableFilter) {
                UnifyRuleCall in2 = call.create(call.query.getParent());
                MutableFilter query = (MutableFilter)in2.query;
                MutableFilter target = (MutableFilter)in2.target;
                MutableFilter newFilter = FilterToFilterUnifyRule.INSTANCE.createFilter(call, query, target);
                if (newFilter == null) {
                    return null;
                }
                return in2.result(query.replaceInParent(newFilter));
            }
            return null;
        }
    }

    private static class FilterToFilterUnifyRule
    extends AbstractUnifyRule {
        public static final FilterToFilterUnifyRule INSTANCE = new FilterToFilterUnifyRule();

        private FilterToFilterUnifyRule() {
            super(FilterToFilterUnifyRule.operand(MutableFilter.class, FilterToFilterUnifyRule.query(0)), FilterToFilterUnifyRule.operand(MutableFilter.class, FilterToFilterUnifyRule.target(0)), 1);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            MutableFilter query = (MutableFilter)call.query;
            MutableFilter target = (MutableFilter)call.target;
            MutableFilter newFilter = this.createFilter(call, query, target);
            if (newFilter == null) {
                return null;
            }
            return call.result(newFilter);
        }

        MutableFilter createFilter(UnifyRuleCall call, MutableFilter query, MutableFilter target) {
            RexNode newCondition = SubstitutionVisitor.splitFilter(call.getSimplify(), query.condition, target.condition);
            if (newCondition == null) {
                return null;
            }
            if (newCondition.isAlwaysTrue()) {
                return target;
            }
            return MutableFilter.of(target, newCondition);
        }
    }

    private static class FilterToProjectUnifyRule
    extends AbstractUnifyRule {
        public static final FilterToProjectUnifyRule INSTANCE = new FilterToProjectUnifyRule();

        private FilterToProjectUnifyRule() {
            super(FilterToProjectUnifyRule.operand(MutableFilter.class, FilterToProjectUnifyRule.query(0)), FilterToProjectUnifyRule.operand(MutableProject.class, FilterToProjectUnifyRule.target(0)), 1);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            try {
                RexNode newCondition;
                MutableProject target = (MutableProject)call.target;
                RexShuttle shuttle = SubstitutionVisitor.getRexShuttle(target);
                MutableFilter query = (MutableFilter)call.query;
                try {
                    newCondition = query.condition.accept(shuttle);
                }
                catch (MatchFailed e) {
                    return null;
                }
                MutableFilter newFilter = MutableFilter.of(target, newCondition);
                if (query.getParent() instanceof MutableProject) {
                    MutableRel inverse = this.invert(((MutableProject)query.getParent()).getNamedProjects(), (MutableRel)newFilter, shuttle);
                    return call.create(query.getParent()).result(inverse);
                }
                MutableRel inverse = this.invert(query, (MutableRel)newFilter, target);
                return call.result(inverse);
            }
            catch (MatchFailed e) {
                return null;
            }
        }

        protected MutableRel invert(List<Pair<RexNode, String>> namedProjects, MutableRel input, RexShuttle shuttle) {
            LOGGER.trace("SubstitutionVisitor: invert:\nprojects: {}\ninput: {}\nproject: {}\n", new Object[]{namedProjects, input, shuttle});
            ArrayList<RexNode> exprList = new ArrayList<RexNode>();
            RexBuilder rexBuilder = input.cluster.getRexBuilder();
            List<RexNode> projects = Pair.left(namedProjects);
            for (RexNode rexNode : projects) {
                exprList.add(rexBuilder.makeZeroLiteral(rexNode.getType()));
            }
            for (Ord ord : Ord.zip(projects)) {
                RexNode node = ((RexNode)ord.e).accept(shuttle);
                if (node == null) {
                    throw MatchFailed.INSTANCE;
                }
                exprList.set(ord.i, node);
            }
            return MutableProject.of(input, exprList, Pair.right(namedProjects));
        }

        protected MutableRel invert(MutableRel model, MutableRel input, MutableProject project) {
            LOGGER.trace("SubstitutionVisitor: invert:\nmodel: {}\ninput: {}\nproject: {}\n", new Object[]{model, input, project});
            if (project.projects.size() < model.rowType.getFieldCount()) {
                throw MatchFailed.INSTANCE;
            }
            ArrayList<RexNode> exprList = new ArrayList<RexNode>();
            RexBuilder rexBuilder = model.cluster.getRexBuilder();
            for (int i = 0; i < model.rowType.getFieldCount(); ++i) {
                exprList.add(null);
            }
            for (Ord<RexNode> expr : Ord.zip(project.projects)) {
                int target;
                if (!(expr.e instanceof RexInputRef) || exprList.get(target = ((RexInputRef)expr.e).getIndex()) != null) continue;
                exprList.set(target, rexBuilder.ensureType(((RexNode)expr.e).getType(), RexInputRef.of(expr.i, input.rowType), false));
            }
            if (exprList.indexOf(null) != -1) {
                throw MatchFailed.INSTANCE;
            }
            return MutableProject.of(model.rowType, input, exprList);
        }
    }

    private static class ProjectToProjectUnifyRule
    extends AbstractUnifyRule {
        public static final ProjectToProjectUnifyRule INSTANCE = new ProjectToProjectUnifyRule();

        private ProjectToProjectUnifyRule() {
            super(ProjectToProjectUnifyRule.operand(MutableProject.class, ProjectToProjectUnifyRule.query(0)), ProjectToProjectUnifyRule.operand(MutableProject.class, ProjectToProjectUnifyRule.target(0)), 1);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            List<RexNode> newProjects;
            MutableProject target = (MutableProject)call.target;
            MutableProject query = (MutableProject)call.query;
            RexShuttle shuttle = SubstitutionVisitor.getRexShuttle(target);
            try {
                newProjects = shuttle.apply(query.projects);
            }
            catch (MatchFailed e) {
                return null;
            }
            MutableProject newProject = MutableProject.of(query.rowType, target, newProjects);
            MutableRel newProject2 = MutableRels.strip(newProject);
            return call.result(newProject2);
        }
    }

    private static class ScanToProjectUnifyRule
    extends AbstractUnifyRule {
        public static final ScanToProjectUnifyRule INSTANCE = new ScanToProjectUnifyRule();

        private ScanToProjectUnifyRule() {
            super(ScanToProjectUnifyRule.any(MutableScan.class), ScanToProjectUnifyRule.any(MutableProject.class), 0);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            List<RexNode> newProjects;
            MutableScan query = (MutableScan)call.query;
            MutableProject target = (MutableProject)call.target;
            if (!query.equals(target.getInput())) {
                return null;
            }
            RexShuttle shuttle = SubstitutionVisitor.getRexShuttle(target);
            RexBuilder rexBuilder = target.cluster.getRexBuilder();
            try {
                newProjects = shuttle.apply(rexBuilder.identityProjects(query.rowType));
            }
            catch (MatchFailed e) {
                return null;
            }
            MutableProject newProject = MutableProject.of(query.rowType, target, newProjects);
            MutableRel newProject2 = MutableRels.strip(newProject);
            return call.result(newProject2);
        }
    }

    private static class TrivialRule
    extends AbstractUnifyRule {
        private static final TrivialRule INSTANCE = new TrivialRule();

        private TrivialRule() {
            super(TrivialRule.any(MutableRel.class), TrivialRule.any(MutableRel.class), 0);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            if (call.query.equals(call.target)) {
                return call.result(call.target);
            }
            return null;
        }

        static /* synthetic */ TrivialRule access$000() {
            return INSTANCE;
        }
    }

    protected static abstract class AbstractUnifyRule
    extends UnifyRule {
        public AbstractUnifyRule(Operand queryOperand, Operand targetOperand, int slotCount) {
            super(slotCount, queryOperand, targetOperand);
            assert (this.isValid());
        }

        protected boolean isValid() {
            SlotCounter slotCounter = new SlotCounter();
            slotCounter.visit(this.queryOperand);
            assert (slotCounter.queryCount == this.slotCount);
            assert (slotCounter.targetCount == 0);
            slotCounter.queryCount = 0;
            slotCounter.visit(this.targetOperand);
            assert (slotCounter.queryCount == 0);
            assert (slotCounter.targetCount == this.slotCount);
            return true;
        }

        protected static Operand operand(Class<? extends MutableRel> clazz, Operand ... inputOperands) {
            return new InternalOperand(clazz, ImmutableList.copyOf(inputOperands));
        }

        protected static Operand any(Class<? extends MutableRel> clazz) {
            return new AnyOperand(clazz);
        }

        protected static Operand query(int ordinal) {
            return new QueryOperand(ordinal);
        }

        protected static Operand target(int ordinal) {
            return new TargetOperand(ordinal);
        }
    }

    protected static class UnifyResult {
        private final UnifyRuleCall call;
        private final MutableRel result;

        UnifyResult(UnifyRuleCall call, MutableRel result) {
            this.call = call;
            assert (SubstitutionVisitor.equalType("query", call.query, "result", result, Litmus.THROW));
            this.result = result;
        }
    }

    protected class UnifyRuleCall {
        protected final UnifyRule rule;
        public final MutableRel query;
        public final MutableRel target;
        protected final ImmutableList<MutableRel> slots;

        public UnifyRuleCall(UnifyRule rule, MutableRel query, MutableRel target, ImmutableList<MutableRel> slots) {
            this.rule = Objects.requireNonNull(rule);
            this.query = Objects.requireNonNull(query);
            this.target = Objects.requireNonNull(target);
            this.slots = Objects.requireNonNull(slots);
        }

        public UnifyResult result(MutableRel result) {
            assert (MutableRels.contains(result, this.target));
            assert (SubstitutionVisitor.equalType("result", result, "query", this.query, Litmus.THROW));
            MutableRel replace = SubstitutionVisitor.this.replacementMap.get(this.target);
            if (replace != null) {
                assert (false);
                SubstitutionVisitor.replace(result, this.target, replace);
            }
            SubstitutionVisitor.this.register(result, this.query);
            return new UnifyResult(this, result);
        }

        public UnifyRuleCall create(MutableRel query) {
            return new UnifyRuleCall(this.rule, query, this.target, this.slots);
        }

        public RelOptCluster getCluster() {
            return SubstitutionVisitor.this.cluster;
        }

        public RexSimplify getSimplify() {
            return SubstitutionVisitor.this.simplify;
        }
    }

    protected static abstract class UnifyRule {
        protected final int slotCount;
        protected final Operand queryOperand;
        protected final Operand targetOperand;

        protected UnifyRule(int slotCount, Operand queryOperand, Operand targetOperand) {
            this.slotCount = slotCount;
            this.queryOperand = queryOperand;
            this.targetOperand = targetOperand;
        }

        protected abstract UnifyResult apply(UnifyRuleCall var1);

        protected UnifyRuleCall match(SubstitutionVisitor visitor, MutableRel query, MutableRel target) {
            if (this.queryOperand.matches(visitor, query) && this.targetOperand.matches(visitor, target)) {
                SubstitutionVisitor substitutionVisitor = visitor;
                substitutionVisitor.getClass();
                return substitutionVisitor.new UnifyRuleCall(this, query, target, this.copy(visitor.slots, this.slotCount));
            }
            return null;
        }

        protected <E> ImmutableList<E> copy(E[] slots, int slotCount) {
            switch (slotCount) {
                case 0: {
                    return ImmutableList.of();
                }
                case 1: {
                    return ImmutableList.of(slots[0]);
                }
            }
            return ImmutableList.copyOf(slots).subList(0, slotCount);
        }
    }

    protected static class MatchFailed
    extends ControlFlowException {
        public static final MatchFailed INSTANCE = new MatchFailed();

        protected MatchFailed() {
        }
    }

    static class Replacement {
        final MutableRel before;
        final MutableRel after;

        Replacement(MutableRel before, MutableRel after) {
            this.before = before;
            this.after = after;
        }
    }
}

