/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.TemporalTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.sources.TableSourceUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import scala.Option;

public class CatalogSchemaTable
extends AbstractTable
implements TemporalTable {
    private final ObjectIdentifier tableIdentifier;
    private final CatalogBaseTable catalogBaseTable;
    private final FlinkStatistic statistic;
    private final boolean isStreamingMode;
    private final boolean isTemporary;
    @Nullable
    private final TableFactory tableFactory;

    public CatalogSchemaTable(ObjectIdentifier tableIdentifier, CatalogBaseTable catalogBaseTable, FlinkStatistic statistic2, @Nullable TableFactory tableFactory, boolean isStreaming, boolean isTemporary) {
        this.tableIdentifier = tableIdentifier;
        this.catalogBaseTable = catalogBaseTable;
        this.statistic = statistic2;
        this.tableFactory = tableFactory;
        this.isStreamingMode = isStreaming;
        this.isTemporary = isTemporary;
    }

    public Optional<TableFactory> getTableFactory() {
        return Optional.ofNullable(this.tableFactory);
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public CatalogBaseTable getCatalogTable() {
        return this.catalogBaseTable;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public boolean isStreamingMode() {
        return this.isStreamingMode;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return CatalogSchemaTable.getRowType(typeFactory, this.catalogBaseTable, this.isStreamingMode);
    }

    @Override
    public FlinkStatistic getStatistic() {
        return this.statistic;
    }

    private static RelDataType getRowType(RelDataTypeFactory typeFactory, CatalogBaseTable catalogBaseTable, boolean isStreamingMode) {
        FlinkTypeFactory flinkTypeFactory = (FlinkTypeFactory)typeFactory;
        TableSchema tableSchema = catalogBaseTable.getSchema();
        DataType[] fieldDataTypes = tableSchema.getFieldDataTypes();
        if (!isStreamingMode && catalogBaseTable instanceof ConnectorCatalogTable && ((ConnectorCatalogTable)catalogBaseTable).getTableSource().isPresent()) {
            for (int i = 0; i < fieldDataTypes.length; ++i) {
                LogicalType lt = fieldDataTypes[i].getLogicalType();
                if (!(lt instanceof TimestampType) || ((TimestampType)lt).getKind() != TimestampKind.PROCTIME && ((TimestampType)lt).getKind() != TimestampKind.ROWTIME) continue;
                int precision = ((TimestampType)lt).getPrecision();
                fieldDataTypes[i] = DataTypes.TIMESTAMP((int)precision);
            }
        }
        return TableSourceUtil.getSourceRowType(flinkTypeFactory, tableSchema, Option.empty(), isStreamingMode);
    }

    @Override
    public String getSysStartFieldName() {
        return "sys_start";
    }

    @Override
    public String getSysEndFieldName() {
        return "sys_end";
    }
}

