/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.util.StringUtils;

@Internal
public abstract class ExecutorBase
implements Executor {
    private static final String DEFAULT_JOB_NAME = "Flink Exec Table Job";
    private final StreamExecutionEnvironment executionEnvironment;
    protected TableConfig tableConfig;

    public ExecutorBase(StreamExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    public void setTableConfig(TableConfig tableConfig) {
        this.tableConfig = tableConfig;
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void apply(List<Transformation<?>> transformations) {
        transformations.forEach(arg_0 -> ((StreamExecutionEnvironment)this.getExecutionEnvironment()).addOperator(arg_0));
    }

    public abstract StreamGraph getStreamGraph(String var1);

    protected String getNonEmptyJobName(String jobName) {
        if (StringUtils.isNullOrWhitespaceOnly((String)jobName)) {
            return DEFAULT_JOB_NAME;
        }
        return jobName;
    }
}

