/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.BooleanSerializer;
import org.apache.flink.api.common.typeutils.base.ByteSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.FloatSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.ShortSerializer;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataview.MapViewSerializer;
import org.apache.flink.table.dataview.MapViewTypeInfo;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.runtime.typeutils.BinaryStringSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryStringTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalSerializer;
import org.apache.flink.table.runtime.typeutils.DecimalTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TypeInformationRawType;

public abstract class FirstValueWithRetractAggFunction<T>
extends AggregateFunction<T, GenericRow> {
    public GenericRow createAccumulator() {
        GenericRow acc = new GenericRow(4);
        acc.setField(0, null);
        acc.setField(1, null);
        acc.setField(2, (Object)new BinaryGeneric((Object)new MapView(this.getResultType(), (TypeInformation)new ListTypeInfo(Types.LONG))));
        acc.setField(3, (Object)new BinaryGeneric((Object)new MapView(Types.LONG, (TypeInformation)new ListTypeInfo(this.getResultType()))));
        return acc;
    }

    public void accumulate(GenericRow acc, Object value) throws Exception {
        if (value != null) {
            Object v = value;
            Long order = System.currentTimeMillis();
            MapView<T, List<Long>> valueToOrderMapView = this.getValueToOrderMapViewFromAcc(acc);
            ArrayList<Long> orderList = (ArrayList<Long>)valueToOrderMapView.get(v);
            if (orderList == null) {
                orderList = new ArrayList<Long>();
            }
            orderList.add(order);
            valueToOrderMapView.put(v, orderList);
            this.accumulate(acc, value, order);
        }
    }

    public void accumulate(GenericRow acc, Object value, Long order) throws Exception {
        if (value != null) {
            MapView<Long, List<T>> orderToValueMapView;
            ArrayList<Object> valueList;
            Object v = value;
            Long prevOrder = (Long)acc.getField(1);
            if (prevOrder == null || prevOrder > order) {
                acc.setField(0, v);
                acc.setLong(1, order.longValue());
            }
            if ((valueList = (ArrayList<Object>)(orderToValueMapView = this.getOrderToValueMapViewFromAcc(acc)).get((Object)order)) == null) {
                valueList = new ArrayList<Object>();
            }
            valueList.add(v);
            orderToValueMapView.put((Object)order, valueList);
        }
    }

    public void retract(GenericRow acc, Object value) throws Exception {
        if (value != null) {
            Object v = value;
            MapView<T, List<Long>> valueToOrderMapView = this.getValueToOrderMapViewFromAcc(acc);
            List orderList = (List)valueToOrderMapView.get(v);
            if (orderList != null && orderList.size() > 0) {
                Long order = (Long)orderList.get(0);
                orderList.remove(0);
                if (orderList.isEmpty()) {
                    valueToOrderMapView.remove(v);
                } else {
                    valueToOrderMapView.put(v, (Object)orderList);
                }
                this.retract(acc, value, order);
            }
        }
    }

    public void retract(GenericRow acc, Object value, Long order) throws Exception {
        if (value != null) {
            Object v = value;
            MapView<Long, List<T>> orderToValueMapView = this.getOrderToValueMapViewFromAcc(acc);
            List valueList = (List)orderToValueMapView.get((Object)order);
            if (valueList == null) {
                return;
            }
            int index = valueList.indexOf(v);
            if (index >= 0) {
                valueList.remove(index);
                if (valueList.isEmpty()) {
                    orderToValueMapView.remove((Object)order);
                } else {
                    orderToValueMapView.put((Object)order, (Object)valueList);
                }
            }
            if (v.equals(acc.getField(0))) {
                Long startKey = (Long)acc.getField(1);
                Iterator iter = orderToValueMapView.keys().iterator();
                Long nextKey = Long.MAX_VALUE;
                while (iter.hasNext()) {
                    Long key = (Long)iter.next();
                    if (key < startKey || key >= nextKey) continue;
                    nextKey = key;
                }
                if (nextKey != Long.MAX_VALUE) {
                    acc.setField(0, ((List)orderToValueMapView.get((Object)nextKey)).get(0));
                    acc.setField(1, (Object)nextKey);
                } else {
                    acc.setField(0, null);
                    acc.setField(1, null);
                }
            }
        }
    }

    public void resetAccumulator(GenericRow acc) {
        acc.setField(0, null);
        acc.setField(1, null);
        MapView<T, List<Long>> valueToOrderMapView = this.getValueToOrderMapViewFromAcc(acc);
        valueToOrderMapView.clear();
        MapView<Long, List<T>> orderToValueMapView = this.getOrderToValueMapViewFromAcc(acc);
        orderToValueMapView.clear();
    }

    public T getValue(GenericRow acc) {
        return (T)acc.getField(0);
    }

    protected abstract TypeSerializer<T> createValueSerializer();

    public TypeInformation<GenericRow> getAccumulatorType() {
        LogicalType[] fieldTypes = new LogicalType[]{TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType((TypeInformation)this.getResultType()), new BigIntType(), new TypeInformationRawType((TypeInformation)new MapViewTypeInfo(this.getResultType(), (TypeInformation)new ListTypeInfo(Types.LONG), false, false)), new TypeInformationRawType((TypeInformation)new MapViewTypeInfo(Types.LONG, (TypeInformation)new ListTypeInfo(this.getResultType()), false, false))};
        String[] fieldNames = new String[]{"firstValue", "firstOrder", "valueToOrderMapView", "orderToValueMapView"};
        return new BaseRowTypeInfo(fieldTypes, fieldNames);
    }

    private MapView<T, List<Long>> getValueToOrderMapViewFromAcc(GenericRow acc) {
        BinaryGeneric binaryGeneric = (BinaryGeneric)acc.getField(2);
        return (MapView)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)binaryGeneric, this.getValueToOrderMapViewSerializer());
    }

    private MapView<Long, List<T>> getOrderToValueMapViewFromAcc(GenericRow acc) {
        BinaryGeneric binaryGeneric = (BinaryGeneric)acc.getField(3);
        return (MapView)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)binaryGeneric, this.getOrderToValueMapViewSerializer());
    }

    private MapViewSerializer<T, List<Long>> getValueToOrderMapViewSerializer() {
        return new MapViewSerializer((TypeSerializer)new MapSerializer(this.createValueSerializer(), (TypeSerializer)new ListSerializer((TypeSerializer)LongSerializer.INSTANCE)));
    }

    private MapViewSerializer<Long, List<T>> getOrderToValueMapViewSerializer() {
        return new MapViewSerializer((TypeSerializer)new MapSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)new ListSerializer(this.createValueSerializer())));
    }

    public static class StringFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<BinaryString> {
        public TypeInformation<BinaryString> getResultType() {
            return BinaryStringTypeInfo.INSTANCE;
        }

        public void accumulate(GenericRow acc, BinaryString value) throws Exception {
            if (value != null) {
                super.accumulate(acc, value.copy());
            }
        }

        public void accumulate(GenericRow acc, BinaryString value, Long order) throws Exception {
            if (value != null) {
                super.accumulate(acc, value.copy(), order);
            }
        }

        @Override
        protected TypeSerializer<BinaryString> createValueSerializer() {
            return BinaryStringSerializer.INSTANCE;
        }
    }

    public static class DecimalFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Decimal> {
        private DecimalTypeInfo decimalTypeInfo;

        public DecimalFirstValueWithRetractAggFunction(DecimalTypeInfo decimalTypeInfo) {
            this.decimalTypeInfo = decimalTypeInfo;
        }

        public void accumulate(GenericRow acc, Decimal value) throws Exception {
            super.accumulate(acc, value);
        }

        public void accumulate(GenericRow acc, Decimal value, Long order) throws Exception {
            super.accumulate(acc, value, order);
        }

        public TypeInformation<Decimal> getResultType() {
            return this.decimalTypeInfo;
        }

        @Override
        protected TypeSerializer<Decimal> createValueSerializer() {
            return new DecimalSerializer(this.decimalTypeInfo.precision(), this.decimalTypeInfo.scale());
        }
    }

    public static class BooleanFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Boolean> {
        public TypeInformation<Boolean> getResultType() {
            return Types.BOOLEAN;
        }

        @Override
        protected TypeSerializer<Boolean> createValueSerializer() {
            return BooleanSerializer.INSTANCE;
        }
    }

    public static class DoubleFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Double> {
        public TypeInformation<Double> getResultType() {
            return Types.DOUBLE;
        }

        @Override
        protected TypeSerializer<Double> createValueSerializer() {
            return DoubleSerializer.INSTANCE;
        }
    }

    public static class FloatFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Float> {
        public TypeInformation<Float> getResultType() {
            return Types.FLOAT;
        }

        @Override
        protected TypeSerializer<Float> createValueSerializer() {
            return FloatSerializer.INSTANCE;
        }
    }

    public static class LongFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Long> {
        public TypeInformation<Long> getResultType() {
            return Types.LONG;
        }

        @Override
        protected TypeSerializer<Long> createValueSerializer() {
            return LongSerializer.INSTANCE;
        }
    }

    public static class IntFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Integer> {
        public TypeInformation<Integer> getResultType() {
            return Types.INT;
        }

        @Override
        protected TypeSerializer<Integer> createValueSerializer() {
            return IntSerializer.INSTANCE;
        }
    }

    public static class ShortFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Short> {
        public TypeInformation<Short> getResultType() {
            return Types.SHORT;
        }

        @Override
        protected TypeSerializer<Short> createValueSerializer() {
            return ShortSerializer.INSTANCE;
        }
    }

    public static class ByteFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Byte> {
        public TypeInformation<Byte> getResultType() {
            return Types.BYTE;
        }

        @Override
        protected TypeSerializer<Byte> createValueSerializer() {
            return ByteSerializer.INSTANCE;
        }
    }
}

