/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.utils;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;

public class HiveFunctionUtils {
    public static boolean isHiveFunc(Object function) {
        try {
            HiveFunctionUtils.getSetArgsMethod(function);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static Method getSetArgsMethod(Object function) throws NoSuchMethodException {
        return function.getClass().getMethod("setArgumentTypesAndConstants", Object[].class, DataType[].class);
    }

    static Serializable invokeSetArgs(Serializable function, Object[] constantArguments, LogicalType[] argTypes) {
        try {
            Method method = HiveFunctionUtils.getSetArgsMethod(function);
            method.invoke((Object)function, constantArguments, TypeConversions.fromLogicalToDataType((LogicalType[])argTypes));
            return function;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static RelDataType invokeGetResultType(Object function, Object[] constantArguments, LogicalType[] argTypes, FlinkTypeFactory typeFactory) {
        try {
            Method method = function.getClass().getMethod("getHiveResultType", Object[].class, DataType[].class);
            DataType resultType2 = (DataType)method.invoke(function, constantArguments, TypeConversions.fromLogicalToDataType((LogicalType[])argTypes));
            return typeFactory.createFieldTypeFromLogicalType(LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)resultType2));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

