/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.plan.metadata.FlinkMetadata;
import org.apache.flink.table.planner.plan.stats.ValueInterval;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.RelModifiedMonotonicity;
import org.apache.flink.util.Preconditions;

public class FlinkRelMetadataQuery
extends RelMetadataQuery {
    protected static final FlinkRelMetadataQuery PROTOTYPE = new FlinkRelMetadataQuery(false);
    private FlinkMetadata.ColumnInterval.Handler columnIntervalHandler;
    private FlinkMetadata.FilteredColumnInterval.Handler filteredColumnInterval;
    private FlinkMetadata.ColumnNullCount.Handler columnNullCountHandler;
    private FlinkMetadata.ColumnOriginNullCount.Handler columnOriginNullCountHandler;
    private FlinkMetadata.UniqueGroups.Handler uniqueGroupsHandler;
    private FlinkMetadata.FlinkDistribution.Handler distributionHandler;
    private FlinkMetadata.ModifiedMonotonicity.Handler modifiedMonotonicityHandler;

    public static FlinkRelMetadataQuery instance() {
        return new FlinkRelMetadataQuery();
    }

    public static FlinkRelMetadataQuery reuseOrCreate(RelMetadataQuery mq) {
        if (mq instanceof FlinkRelMetadataQuery) {
            return (FlinkRelMetadataQuery)mq;
        }
        return FlinkRelMetadataQuery.instance();
    }

    private FlinkRelMetadataQuery(JaninoRelMetadataProvider metadataProvider, RelMetadataQuery prototype) {
        super(metadataProvider, prototype);
    }

    private FlinkRelMetadataQuery() {
        super(RelMetadataQuery.THREAD_PROVIDERS.get(), RelMetadataQuery.EMPTY);
        this.columnIntervalHandler = FlinkRelMetadataQuery.PROTOTYPE.columnIntervalHandler;
        this.filteredColumnInterval = FlinkRelMetadataQuery.PROTOTYPE.filteredColumnInterval;
        this.columnNullCountHandler = FlinkRelMetadataQuery.PROTOTYPE.columnNullCountHandler;
        this.columnOriginNullCountHandler = FlinkRelMetadataQuery.PROTOTYPE.columnOriginNullCountHandler;
        this.uniqueGroupsHandler = FlinkRelMetadataQuery.PROTOTYPE.uniqueGroupsHandler;
        this.distributionHandler = FlinkRelMetadataQuery.PROTOTYPE.distributionHandler;
        this.modifiedMonotonicityHandler = FlinkRelMetadataQuery.PROTOTYPE.modifiedMonotonicityHandler;
    }

    private FlinkRelMetadataQuery(boolean dummy) {
        super(RelMetadataQuery.THREAD_PROVIDERS.get(), RelMetadataQuery.EMPTY);
        this.columnIntervalHandler = RelMetadataQuery.initialHandler(FlinkMetadata.ColumnInterval.Handler.class);
        this.filteredColumnInterval = RelMetadataQuery.initialHandler(FlinkMetadata.FilteredColumnInterval.Handler.class);
        this.columnNullCountHandler = RelMetadataQuery.initialHandler(FlinkMetadata.ColumnNullCount.Handler.class);
        this.columnOriginNullCountHandler = RelMetadataQuery.initialHandler(FlinkMetadata.ColumnOriginNullCount.Handler.class);
        this.uniqueGroupsHandler = RelMetadataQuery.initialHandler(FlinkMetadata.UniqueGroups.Handler.class);
        this.distributionHandler = RelMetadataQuery.initialHandler(FlinkMetadata.FlinkDistribution.Handler.class);
        this.modifiedMonotonicityHandler = RelMetadataQuery.initialHandler(FlinkMetadata.ModifiedMonotonicity.Handler.class);
    }

    public ValueInterval getColumnInterval(RelNode rel, int index) {
        while (true) {
            try {
                return this.columnIntervalHandler.getColumnInterval(rel, this, index);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.columnIntervalHandler = (FlinkMetadata.ColumnInterval.Handler)this.revise(e.relClass, FlinkMetadata.ColumnInterval.DEF);
                continue;
            }
            break;
        }
    }

    public ValueInterval getFilteredColumnInterval(RelNode rel, int columnIndex, int filterArg) {
        while (true) {
            try {
                return this.filteredColumnInterval.getFilteredColumnInterval(rel, this, columnIndex, filterArg);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.filteredColumnInterval = (FlinkMetadata.FilteredColumnInterval.Handler)this.revise(e.relClass, FlinkMetadata.FilteredColumnInterval.DEF);
                continue;
            }
            break;
        }
    }

    public Double getColumnNullCount(RelNode rel, int index) {
        while (true) {
            try {
                return this.columnNullCountHandler.getColumnNullCount(rel, this, index);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.columnNullCountHandler = (FlinkMetadata.ColumnNullCount.Handler)this.revise(e.relClass, FlinkMetadata.ColumnNullCount.DEF);
                continue;
            }
            break;
        }
    }

    public Double getColumnOriginNullCount(RelNode rel, int index) {
        while (true) {
            try {
                return this.columnOriginNullCountHandler.getColumnOriginNullCount(rel, this, index);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.columnOriginNullCountHandler = (FlinkMetadata.ColumnOriginNullCount.Handler)this.revise(e.relClass, FlinkMetadata.ColumnOriginNullCount.DEF);
                continue;
            }
            break;
        }
    }

    public ImmutableBitSet getUniqueGroups(RelNode rel, ImmutableBitSet columns) {
        while (true) {
            try {
                Preconditions.checkArgument((columns != null ? 1 : 0) != 0);
                if (columns.isEmpty()) {
                    return columns;
                }
                ImmutableBitSet uniqueGroups = this.uniqueGroupsHandler.getUniqueGroups(rel, this, columns);
                Preconditions.checkArgument((uniqueGroups != null && !uniqueGroups.isEmpty() ? 1 : 0) != 0);
                Preconditions.checkArgument((boolean)columns.contains(uniqueGroups));
                return uniqueGroups;
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.uniqueGroupsHandler = (FlinkMetadata.UniqueGroups.Handler)this.revise(e.relClass, FlinkMetadata.UniqueGroups.DEF);
                continue;
            }
            break;
        }
    }

    public FlinkRelDistribution flinkDistribution(RelNode rel) {
        while (true) {
            try {
                return this.distributionHandler.flinkDistribution(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.distributionHandler = (FlinkMetadata.FlinkDistribution.Handler)this.revise(e.relClass, FlinkMetadata.FlinkDistribution.DEF);
                continue;
            }
            break;
        }
    }

    public RelModifiedMonotonicity getRelModifiedMonotonicity(RelNode rel) {
        while (true) {
            try {
                return this.modifiedMonotonicityHandler.getRelModifiedMonotonicity(rel, this);
            }
            catch (JaninoRelMetadataProvider.NoHandler e) {
                this.modifiedMonotonicityHandler = (FlinkMetadata.ModifiedMonotonicity.Handler)this.revise(e.relClass, FlinkMetadata.ModifiedMonotonicity.DEF);
                continue;
            }
            break;
        }
    }
}

