/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Collections;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSort;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.planner.plan.rules.logical.PushLimitIntoTableSourceScanRule$;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.sources.LimitableTableSource;
import org.apache.flink.table.sources.TableSource;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001'\t\u0001\u0003+^:i\u0019&l\u0017\u000e^%oi>$\u0016M\u00197f'>,(oY3TG\u0006t'+\u001e7f\u0015\t\u0019A!A\u0004m_\u001eL7-\u00197\u000b\u0005\u00151\u0011!\u0002:vY\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001635\taC\u0003\u0002\b/)\u0011\u0001DD\u0001\bG\u0006d7-\u001b;f\u0013\tQbC\u0001\u0006SK2|\u0005\u000f\u001e*vY\u0016DQ\u0001\b\u0001\u0005\u0002u\ta\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0002\t\u000b\u0005\u0002A\u0011\t\u0012\u0002\u000f5\fGo\u00195fgR\u00111%\u000b\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\b\u0005>|G.Z1o\u0011\u0015Q\u0003\u00051\u0001,\u0003\u0011\u0019\u0017\r\u001c7\u0011\u0005Ua\u0013BA\u0017\u0017\u00059\u0011V\r\\(qiJ+H.Z\"bY2DQa\f\u0001\u0005BA\nqa\u001c8NCR\u001c\u0007\u000e\u0006\u00022iA\u0011AEM\u0005\u0003g\u0015\u0012A!\u00168ji\")!F\fa\u0001W!)a\u0007\u0001C\u0005o\u0005Q\u0011\r\u001d9ms2KW.\u001b;\u0015\taRu\n\u0016\u0019\u0003s\u0005\u00032AO\u001f@\u001b\u0005Y$B\u0001\u001f\u0007\u0003\u0019\u00198\r[3nC&\u0011ah\u000f\u0002\u0011)\u0006\u0014G.Z*pkJ\u001cW\rV1cY\u0016\u0004\"\u0001Q!\r\u0001\u0011I!)NA\u0001\u0002\u0003\u0015\ta\u0011\u0002\u0004?\u00122\u0014C\u0001#H!\t!S)\u0003\u0002GK\t9aj\u001c;iS:<\u0007C\u0001\u0013I\u0013\tIUEA\u0002B]fDQaS\u001bA\u00021\u000bQ\u0001\\5nSR\u0004\"\u0001J'\n\u00059+#\u0001\u0002'p]\u001eDQ\u0001U\u001bA\u0002E\u000b1B]3m\u001fB$H+\u00192mKB\u0011!HU\u0005\u0003'n\u0012qC\u00127j].\u0004&/\u001a9be&tw\rV1cY\u0016\u0014\u0015m]3\t\u000bU+\u0004\u0019\u0001,\u0002\u0015I,GNQ;jY\u0012,'\u000f\u0005\u0002X56\t\u0001L\u0003\u0002Z/\u0005)Ao\\8mg&\u00111\f\u0017\u0002\u000b%\u0016d')^5mI\u0016\u0014x!B/\u0003\u0011\u0003q\u0016\u0001\t)vg\"d\u0015.\\5u\u0013:$x\u000eV1cY\u0016\u001cv.\u001e:dKN\u001b\u0017M\u001c*vY\u0016\u0004\"aH0\u0007\u000b\u0005\u0011\u0001\u0012\u00011\u0014\u0005}\u000b\u0007C\u0001\u0013c\u0013\t\u0019WE\u0001\u0004B]f\u0014VM\u001a\u0005\u00069}#\t!\u001a\u000b\u0002=\"9qm\u0018b\u0001\n\u0003A\u0017\u0001C%O'R\u000bejQ#\u0016\u0003QAaA[0!\u0002\u0013!\u0012!C%O'R\u000bejQ#!\u0001")
public class PushLimitIntoTableSourceScanRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return PushLimitIntoTableSourceScanRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        boolean onlyLimit;
        Sort sort = (Sort)call.rel(0);
        boolean bl = onlyLimit = sort.getCollation().getFieldCollations().isEmpty() && sort.fetch != null;
        if (onlyLimit) {
            TableSourceTable tableSourceTable = ((TableScan)call.rel(1)).getTable().unwrap(TableSourceTable.class);
            if (tableSourceTable != null) {
                TableSourceTable tableSourceTable2 = tableSourceTable;
                TableSource tableSource = tableSourceTable2.tableSource();
                if (tableSource instanceof LimitableTableSource) {
                    TableSource tableSource2 = tableSource;
                    return !((LimitableTableSource)tableSource2).isLimitPushedDown();
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        FlinkLogicalTableSourceScan scan = (FlinkLogicalTableSourceScan)call.rel(1);
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        int offset = sort.offset == null ? 0 : RexLiteral.intValue(sort.offset);
        int limit = offset + RexLiteral.intValue(sort.fetch);
        RelBuilder relBuilder = call.builder();
        TableSourceTable<?> newRelOptTable = this.applyLimit(limit, tableSourceTable, relBuilder);
        FlinkLogicalTableSourceScan newScan = scan.copy(scan.getTraitSet(), newRelOptTable);
        TableSource newTableSource = newRelOptTable.unwrap(TableSourceTable.class).tableSource();
        TableSource oldTableSource = tableSourceTable.unwrap(TableSourceTable.class).tableSource();
        if (((LimitableTableSource)newTableSource).isLimitPushedDown() && newTableSource.explainSource().equals(oldTableSource.explainSource())) {
            throw new TableException("Failed to push limit into table source! table source with pushdown capability must override and change explainSource() API to explain the pushdown applied!");
        }
        call.transformTo(sort.copy(sort.getTraitSet(), Collections.singletonList(newScan)));
    }

    private TableSourceTable<?> applyLimit(long limit, FlinkPreparingTableBase relOptTable, RelBuilder relBuilder) {
        TableSourceTable tableSourceTable = relOptTable.unwrap(TableSourceTable.class);
        LimitableTableSource limitedSource = (LimitableTableSource)tableSourceTable.tableSource();
        TableSource newTableSource = limitedSource.applyLimit(limit);
        FlinkStatistic statistic2 = relOptTable.getStatistic();
        long newRowCount = statistic2.getRowCount() == null ? limit : Math.min(limit, (long)Predef$.MODULE$.Double2double(statistic2.getRowCount()));
        TableStats newTableStats = new TableStats(newRowCount);
        FlinkStatistic newStatistic = FlinkStatistic$.MODULE$.builder().statistic(statistic2).tableStats(newTableStats).build();
        return tableSourceTable.copy(newTableSource, newStatistic);
    }

    public PushLimitIntoTableSourceScanRule() {
        super(RelOptRule.operand(FlinkLogicalSort.class, RelOptRule.operand(FlinkLogicalTableSourceScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushLimitIntoTableSourceScanRule");
    }
}

