/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.flink.table.planner.plan.rules.logical.SimplifyJoinConditionRule$;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u2A!\u0001\u0002\u0001'\tI2+[7qY&4\u0017PS8j]\u000e{g\u000eZ5uS>t'+\u001e7f\u0015\t\u0019A!A\u0004m_\u001eL7-\u00197\u000b\u0005\u00151\u0011!\u0002:vY\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001635\taC\u0003\u0002\b/)\u0011\u0001DD\u0001\bG\u0006d7-\u001b;f\u0013\tQbC\u0001\u0006SK2|\u0005\u000f\u001e*vY\u0016DQ\u0001\b\u0001\u0005\u0002u\ta\u0001P5oSRtD#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0002\t\u000b\u0005\u0002A\u0011\t\u0012\u0002\u000f=tW*\u0019;dQR\u00111%\u000b\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0005+:LG\u000fC\u0003+A\u0001\u00071&\u0001\u0003dC2d\u0007CA\u000b-\u0013\ticC\u0001\bSK2|\u0005\u000f\u001e*vY\u0016\u001c\u0015\r\u001c7\b\u000b=\u0012\u0001\u0012\u0001\u0019\u00023MKW\u000e\u001d7jMfTu.\u001b8D_:$\u0017\u000e^5p]J+H.\u001a\t\u0003?E2Q!\u0001\u0002\t\u0002I\u001a\"!M\u001a\u0011\u0005\u0011\"\u0014BA\u001b&\u0005\u0019\te.\u001f*fM\")A$\rC\u0001oQ\t\u0001\u0007C\u0004:c\t\u0007I\u0011\u0001\u001e\u0002\u0011%s5\u000bV!O\u0007\u0016+\u0012A\b\u0005\u0007yE\u0002\u000b\u0011\u0002\u0010\u0002\u0013%s5\u000bV!O\u0007\u0016\u0003\u0003")
public class SimplifyJoinConditionRule
extends RelOptRule {
    public static SimplifyJoinConditionRule INSTANCE() {
        return SimplifyJoinConditionRule$.MODULE$.INSTANCE();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalJoin join = (LogicalJoin)call.rel(0);
        RexNode condition = join.getCondition();
        if (join.getCondition().isAlwaysTrue()) {
            return;
        }
        RexNode simpleCondExp = FlinkRexUtil$.MODULE$.simplify(join.getCluster().getRexBuilder(), condition);
        RexNode newCondExp = RexUtil.pullFactors(join.getCluster().getRexBuilder(), simpleCondExp);
        if (newCondExp.toString().equals(condition.toString())) {
            return;
        }
        LogicalJoin newJoin = join.copy(join.getTraitSet(), newCondExp, join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone());
        call.transformTo(newJoin);
        call.getPlanner().setImportance(join, 0.0);
    }

    public SimplifyJoinConditionRule() {
        super(RelOptRule.operand(LogicalJoin.class, RelOptRule.any()), "SimplifyJoinConditionRule");
    }
}

