/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.util.Collection;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRel;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSnapshot;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamExecJoin;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamExecJoinRule$;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution$;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil$;
import org.apache.flink.table.planner.plan.utils.WindowJoinUtil;
import org.apache.flink.table.planner.plan.utils.WindowJoinUtil$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001+\t\u00112\u000b\u001e:fC6,\u00050Z2K_&t'+\u001e7f\u0015\t\u0019A!\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003\u000b\u0019\t\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u0006\u0003\u000f!\tQA];mKNT!!\u0003\u0006\u0002\tAd\u0017M\u001c\u0006\u0003\u00171\tq\u0001\u001d7b]:,'O\u0003\u0002\u000e\u001d\u0005)A/\u00192mK*\u0011q\u0002E\u0001\u0006M2Lgn\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001c\u001b\u0005A\"BA\u0005\u001a\u0015\tQ\u0002#A\u0004dC2\u001c\u0017\u000e^3\n\u0005qA\"A\u0003*fY>\u0003HOU;mK\")a\u0004\u0001C\u0001?\u00051A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011A\u0001\u0005\u0006G\u0001!\t\u0005J\u0001\b[\u0006$8\r[3t)\t)3\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsEA\u0004C_>dW-\u00198\t\u000b1\u0012\u0003\u0019A\u0017\u0002\t\r\fG\u000e\u001c\t\u0003/9J!a\f\r\u0003\u001dI+Gn\u00149u%VdWmQ1mY\")\u0011\u0007\u0001C!e\u00059qN\\'bi\u000eDGCA\u001a7!\t1C'\u0003\u00026O\t!QK\\5u\u0011\u0015a\u0003\u00071\u0001.\u000f\u0015A$\u0001#\u0001:\u0003I\u0019FO]3b[\u0016CXm\u0019&pS:\u0014V\u000f\\3\u0011\u0005\u0005Rd!B\u0001\u0003\u0011\u0003Y4C\u0001\u001e=!\t1S(\u0003\u0002?O\t1\u0011I\\=SK\u001aDQA\b\u001e\u0005\u0002\u0001#\u0012!\u000f\u0005\b\u0005j\u0012\r\u0011\"\u0001D\u0003!Iej\u0015+B\u001d\u000e+U#\u0001\f\t\r\u0015S\u0004\u0015!\u0003\u0017\u0003%Iej\u0015+B\u001d\u000e+\u0005\u0005")
public class StreamExecJoinRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return StreamExecJoinRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalJoin join = (FlinkLogicalJoin)call.rel(0);
        if (join.getJoinType().projectsRight()) {
            FlinkLogicalRel left = (FlinkLogicalRel)call.rel(1);
            FlinkLogicalRel right = (FlinkLogicalRel)call.rel(2);
            TableConfig tableConfig = call.getPlanner().getContext().unwrap(FlinkContext.class).getTableConfig();
            RelDataType joinRowType = join.getRowType();
            if (left instanceof FlinkLogicalSnapshot) {
                throw new TableException("Temporal table join only support apply FOR SYSTEM_TIME AS OF on the right table.");
            }
            if (right instanceof FlinkLogicalSnapshot || TemporalJoinUtil$.MODULE$.containsTemporalJoinCondition(join.getCondition())) {
                return false;
            }
            Tuple2<Option<WindowJoinUtil.WindowBounds>, Option<RexNode>> tuple2 = WindowJoinUtil$.MODULE$.extractWindowBoundsFromPredicate(join.getCondition(), join.getLeft().getRowType().getFieldCount(), joinRowType, join.getCluster().getRexBuilder(), tableConfig);
            if (tuple2 != null) {
                Tuple2 tuple22;
                Option windowBounds = (Option)tuple2._1();
                Option remainingPreds = (Option)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)windowBounds, (Object)remainingPreds);
                Option windowBounds2 = (Option)tuple23._1();
                Option remainingPreds2 = (Option)tuple23._2();
                if (windowBounds2.isDefined()) {
                    return false;
                }
                boolean remainingPredsAccessTime = remainingPreds2.isDefined() && WindowJoinUtil$.MODULE$.accessesTimeAttribute((RexNode)remainingPreds2.get(), joinRowType);
                boolean rowTimeAttrInOutput = JavaConversions$.MODULE$.asScalaBuffer(joinRowType.getFieldList()).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(RelDataTypeField f) {
                        return FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(f.getType());
                    }
                });
                if (rowTimeAttrInOutput) {
                    throw new TableException("Rowtime attributes must not be in the input rows of a regular join. As a workaround you can cast the time attributes of input tables to TIMESTAMP before.");
                }
                return !remainingPredsAccessTime;
            }
            throw new MatchError(tuple2);
        }
        return true;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalJoin join = (FlinkLogicalJoin)call.rel(0);
        RelNode left = join.getLeft();
        RelNode right = join.getRight();
        JoinInfo joinInfo = join.analyzeCondition();
        Tuple2 tuple2 = new Tuple2((Object)this.toHashTraitByColumns$1(joinInfo.leftKeys, left.getTraitSet()), (Object)this.toHashTraitByColumns$1(joinInfo.rightKeys, right.getTraitSet()));
        if (tuple2 != null) {
            Tuple2 tuple22;
            RelTraitSet leftRequiredTrait = (RelTraitSet)tuple2._1();
            RelTraitSet rightRequiredTrait = (RelTraitSet)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)leftRequiredTrait, (Object)rightRequiredTrait);
            RelTraitSet leftRequiredTrait2 = (RelTraitSet)tuple23._1();
            RelTraitSet rightRequiredTrait2 = (RelTraitSet)tuple23._2();
            RelTraitSet providedTraitSet = join.getTraitSet().replace(FlinkConventions$.MODULE$.STREAM_PHYSICAL());
            RelNode newLeft = RelOptRule.convert(left, leftRequiredTrait2);
            RelNode newRight = RelOptRule.convert(right, rightRequiredTrait2);
            StreamExecJoin newJoin = new StreamExecJoin(join.getCluster(), providedTraitSet, newLeft, newRight, join.getCondition(), join.getJoinType());
            call.transformTo(newJoin);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final RelTraitSet toHashTraitByColumns$1(Collection columns, RelTraitSet inputTraitSets) {
        FlinkRelDistribution distribution = columns.isEmpty() ? FlinkRelDistribution$.MODULE$.SINGLETON() : FlinkRelDistribution$.MODULE$.hash(columns, FlinkRelDistribution$.MODULE$.hash$default$2());
        return inputTraitSets.replace(FlinkConventions$.MODULE$.STREAM_PHYSICAL()).replace(distribution);
    }

    public StreamExecJoinRule() {
        super(RelOptRule.operand(FlinkLogicalJoin.class, RelOptRule.operand(FlinkLogicalRel.class, RelOptRule.any()), RelOptRule.operand(FlinkLogicalRel.class, RelOptRule.any())), "StreamExecJoinRule");
    }
}

