/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.type;

import java.util.ArrayList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeUtil;

public class NumericOrDefaultReturnTypeInference
implements SqlReturnTypeInference {
    private int defaultTypeIdx;
    private int startTypeIdx;

    public NumericOrDefaultReturnTypeInference(int defaultTypeIdx) {
        this(defaultTypeIdx, 0);
    }

    public NumericOrDefaultReturnTypeInference(int defaultTypeIdx, int startTypeIdx) {
        this.defaultTypeIdx = defaultTypeIdx;
        this.startTypeIdx = startTypeIdx;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        int nOperands = opBinding.getOperandCount();
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        for (int i = this.startTypeIdx; i < nOperands; ++i) {
            RelDataType type = opBinding.getOperandType(i);
            if (!SqlTypeUtil.isNumeric(type)) {
                return opBinding.getOperandType(this.defaultTypeIdx);
            }
            types.add(type);
        }
        return opBinding.getTypeFactory().leastRestrictive(types);
    }
}

