/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.keyselector.BaseRowKeySelector;
import org.apache.flink.table.runtime.keyselector.BinaryRowKeySelector;
import org.apache.flink.table.runtime.keyselector.NullBinaryRowKeySelector;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class KeySelectorUtil {
    public static BaseRowKeySelector getBaseRowSelector(int[] keyFields, BaseRowTypeInfo rowType) {
        if (keyFields.length > 0) {
            LogicalType[] inputFieldTypes = rowType.getLogicalTypes();
            LogicalType[] keyFieldTypes = new LogicalType[keyFields.length];
            for (int i = 0; i < keyFields.length; ++i) {
                keyFieldTypes[i] = inputFieldTypes[keyFields[i]];
            }
            RowType returnType = RowType.of((LogicalType[])keyFieldTypes);
            RowType inputType = rowType.toRowType();
            GeneratedProjection generatedProjection = ProjectionCodeGenerator.generateProjection(CodeGeneratorContext.apply(new TableConfig()), "KeyProjection", inputType, returnType, keyFields);
            BaseRowTypeInfo keyRowType = BaseRowTypeInfo.of((RowType)returnType);
            return new BinaryRowKeySelector(keyRowType, generatedProjection);
        }
        return NullBinaryRowKeySelector.INSTANCE;
    }
}

