/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBase;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBinary;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBoolean;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDouble;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataLong;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataString;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;

public class CatalogTableStatisticsConverter {
    public static TableStats convertToTableStats(CatalogTableStatistics tableStatistics, CatalogColumnStatistics columnStatistics) {
        long rowCount = tableStatistics != null && tableStatistics.getRowCount() >= 0L ? tableStatistics.getRowCount() : TableStats.UNKNOWN.getRowCount();
        Map<String, ColumnStats> columnStatsMap = columnStatistics != null ? CatalogTableStatisticsConverter.convertToColumnStatsMap(columnStatistics.getColumnStatisticsData()) : new HashMap<String, ColumnStats>();
        return new TableStats(rowCount, columnStatsMap);
    }

    private static Map<String, ColumnStats> convertToColumnStatsMap(Map<String, CatalogColumnStatisticsDataBase> columnStatisticsData) {
        HashMap<String, ColumnStats> columnStatsMap = new HashMap<String, ColumnStats>();
        for (Map.Entry<String, CatalogColumnStatisticsDataBase> entry : columnStatisticsData.entrySet()) {
            ColumnStats columnStats = CatalogTableStatisticsConverter.convertToColumnStats(entry.getValue());
            columnStatsMap.put(entry.getKey(), columnStats);
        }
        return columnStatsMap;
    }

    private static ColumnStats convertToColumnStats(CatalogColumnStatisticsDataBase columnStatisticsData) {
        Long ndv = null;
        Long nullCount = columnStatisticsData.getNullCount();
        Double avgLen = null;
        Integer maxLen = null;
        Comparable<Long> max = null;
        Comparable<Long> min = null;
        if (columnStatisticsData instanceof CatalogColumnStatisticsDataBoolean) {
            CatalogColumnStatisticsDataBoolean booleanData = (CatalogColumnStatisticsDataBoolean)columnStatisticsData;
            avgLen = 1.0;
            maxLen = 1;
            ndv = null == booleanData.getFalseCount() || null == booleanData.getTrueCount() ? Long.valueOf(2L) : (booleanData.getFalseCount() == 0L && booleanData.getTrueCount() > 0L || booleanData.getFalseCount() > 0L && booleanData.getTrueCount() == 0L ? Long.valueOf(1L) : Long.valueOf(2L));
        } else if (columnStatisticsData instanceof CatalogColumnStatisticsDataLong) {
            CatalogColumnStatisticsDataLong longData = (CatalogColumnStatisticsDataLong)columnStatisticsData;
            ndv = longData.getNdv();
            avgLen = 8.0;
            maxLen = 8;
            max = longData.getMax();
            min = longData.getMin();
        } else if (columnStatisticsData instanceof CatalogColumnStatisticsDataDouble) {
            CatalogColumnStatisticsDataDouble doubleData = (CatalogColumnStatisticsDataDouble)columnStatisticsData;
            ndv = doubleData.getNdv();
            avgLen = 8.0;
            maxLen = 8;
            max = doubleData.getMax();
            min = doubleData.getMin();
        } else if (columnStatisticsData instanceof CatalogColumnStatisticsDataString) {
            CatalogColumnStatisticsDataString strData = (CatalogColumnStatisticsDataString)columnStatisticsData;
            ndv = strData.getNdv();
            avgLen = strData.getAvgLength();
            maxLen = null == strData.getMaxLength() ? null : Integer.valueOf(strData.getMaxLength().intValue());
        } else if (columnStatisticsData instanceof CatalogColumnStatisticsDataBinary) {
            CatalogColumnStatisticsDataBinary binaryData = (CatalogColumnStatisticsDataBinary)columnStatisticsData;
            avgLen = binaryData.getAvgLength();
            maxLen = null == binaryData.getMaxLength() ? null : Integer.valueOf(binaryData.getMaxLength().intValue());
        } else if (columnStatisticsData instanceof CatalogColumnStatisticsDataDate) {
            CatalogColumnStatisticsDataDate dateData = (CatalogColumnStatisticsDataDate)columnStatisticsData;
            ndv = dateData.getNdv();
            if (dateData.getMax() != null) {
                max = Date.valueOf(DateTimeUtils.unixDateToString((int)dateData.getMax().getDaysSinceEpoch()));
            }
            if (dateData.getMin() != null) {
                min = Date.valueOf(DateTimeUtils.unixDateToString((int)dateData.getMin().getDaysSinceEpoch()));
            }
        } else {
            throw new TableException("Unsupported CatalogColumnStatisticsDataBase: " + columnStatisticsData.getClass().getCanonicalName());
        }
        return ColumnStats.Builder.builder().setNdv(ndv).setNullCount(nullCount).setAvgLen(avgLen).setMaxLen(maxLen).setMax((Comparable)max).setMin((Comparable)min).build();
    }
}

