/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Litmus;

public class SqlUserDefinedTypeNameSpec
extends SqlTypeNameSpec {
    public SqlUserDefinedTypeNameSpec(SqlIdentifier typeName, SqlParserPos pos) {
        super(typeName, pos);
    }

    public SqlUserDefinedTypeNameSpec(String name, SqlParserPos pos) {
        this(new SqlIdentifier(name, pos), pos);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator) {
        return validator.getValidatedNodeType(this.getTypeName());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        String name = (String)this.getTypeName().names.get(0);
        if (name.startsWith("_")) {
            writer.keyword(name.substring(1));
        } else {
            this.getTypeName().unparse(writer, leftPrec, rightPrec);
        }
    }

    @Override
    public boolean equalsDeep(SqlTypeNameSpec spec, Litmus litmus) {
        if (!(spec instanceof SqlUserDefinedTypeNameSpec)) {
            return litmus.fail("{} != {}", this, spec);
        }
        SqlUserDefinedTypeNameSpec that = (SqlUserDefinedTypeNameSpec)spec;
        if (!this.getTypeName().equalsDeep((SqlNode)that.getTypeName(), litmus)) {
            return litmus.fail("{} != {}", this, spec);
        }
        return litmus.succeed();
    }
}

