/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dml;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlInsertKeyword;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.NlsString;
import org.apache.flink.sql.parser.ExtendedSqlNode;
import org.apache.flink.sql.parser.SqlProperty;
import org.apache.flink.sql.parser.dml.RichSqlInsertKeyword;
import org.apache.flink.sql.parser.error.SqlValidateException;

public class RichSqlInsert
extends SqlInsert
implements ExtendedSqlNode {
    private final SqlNodeList staticPartitions;
    private final SqlNodeList extendedKeywords;

    public RichSqlInsert(SqlParserPos pos, SqlNodeList keywords, SqlNodeList extendedKeywords, SqlNode targetTable, SqlNode source, SqlNodeList columnList, SqlNodeList staticPartitions) {
        super(pos, keywords, targetTable, source, columnList);
        this.extendedKeywords = extendedKeywords;
        this.staticPartitions = staticPartitions;
    }

    public SqlNodeList getStaticPartitions() {
        return this.staticPartitions;
    }

    public LinkedHashMap<String, String> getStaticPartitionKVs() {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (this.staticPartitions.size() == 0) {
            return ret;
        }
        for (SqlNode node : this.staticPartitions.getList()) {
            SqlProperty sqlProperty = (SqlProperty)node;
            Comparable comparable = SqlLiteral.value(sqlProperty.getValue());
            String value = comparable instanceof NlsString ? ((NlsString)comparable).getValue() : comparable.toString();
            ret.put(sqlProperty.getKey().getSimple(), value);
        }
        return ret;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        String insertKeyword = "INSERT INTO";
        if (this.isUpsert()) {
            insertKeyword = "UPSERT INTO";
        } else if (this.isOverwrite()) {
            insertKeyword = "INSERT OVERWRITE";
        }
        writer.sep(insertKeyword);
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.getTargetTable().unparse(writer, opLeft, opRight);
        if (this.getTargetColumnList() != null) {
            this.getTargetColumnList().unparse(writer, opLeft, opRight);
        }
        writer.newlineAndIndent();
        if (this.staticPartitions != null && this.staticPartitions.size() > 0) {
            writer.keyword("PARTITION");
            this.staticPartitions.unparse(writer, opLeft, opRight);
            writer.newlineAndIndent();
        }
        this.getSource().unparse(writer, 0, 0);
    }

    public static boolean isUpsert(List<SqlLiteral> keywords) {
        for (SqlNode sqlNode : keywords) {
            SqlInsertKeyword keyword2 = ((SqlLiteral)sqlNode).symbolValue(SqlInsertKeyword.class);
            if (keyword2 != SqlInsertKeyword.UPSERT) continue;
            return true;
        }
        return false;
    }

    public boolean isOverwrite() {
        return this.getModifierNode(RichSqlInsertKeyword.OVERWRITE) != null;
    }

    private SqlNode getModifierNode(RichSqlInsertKeyword modifier) {
        for (SqlNode keyword : this.extendedKeywords) {
            RichSqlInsertKeyword keyword2 = ((SqlLiteral)keyword).symbolValue(RichSqlInsertKeyword.class);
            if (keyword2 != modifier) continue;
            return keyword;
        }
        return null;
    }

    @Override
    public void validate() throws SqlValidateException {
    }
}

