/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverter;
import org.apache.flink.table.planner.plan.FlinkCalciteCatalogReader;

public class SqlExprToRexConverterImpl
implements SqlExprToRexConverter {
    private static final String TEMPORARY_TABLE_NAME = "__temp_table__";
    private static final String QUERY_FORMAT = "SELECT %s FROM __temp_table__";
    private final FlinkPlannerImpl planner;

    public SqlExprToRexConverterImpl(FrameworkConfig config, FlinkTypeFactory typeFactory, RelOptCluster cluster, RelDataType tableRowType) {
        this.planner = new FlinkPlannerImpl(config, isLenient -> SqlExprToRexConverterImpl.createSingleTableCatalogReader(isLenient, config, typeFactory, tableRowType), typeFactory, cluster);
    }

    @Override
    public RexNode convertToRexNode(String expr) {
        return this.convertToRexNodes(new String[]{expr})[0];
    }

    @Override
    public RexNode[] convertToRexNodes(String[] exprs) {
        String query = String.format(QUERY_FORMAT, String.join((CharSequence)",", exprs));
        SqlNode parsed = this.planner.parser().parse(query);
        SqlNode validated = this.planner.validate(parsed);
        RelNode rel = this.planner.rel((SqlNode)validated).rel;
        if (rel instanceof LogicalProject && rel.getInput(0) != null && rel.getInput(0) instanceof TableScan) {
            return ((LogicalProject)rel).getProjects().toArray(new RexNode[0]);
        }
        throw new IllegalStateException("The root RelNode should be LogicalProject, but is " + rel.toString());
    }

    private static CalciteCatalogReader createSingleTableCatalogReader(boolean lenientCaseSensitivity, FrameworkConfig config, FlinkTypeFactory typeFactory, RelDataType rowType) {
        boolean caseSensitive = !lenientCaseSensitivity && config.getParserConfig().caseSensitive();
        Properties properties = new Properties();
        properties.put(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(caseSensitive));
        CalciteConnectionConfigImpl connectionConfig = new CalciteConnectionConfigImpl(properties);
        RowTypeSpecifiedTable table = new RowTypeSpecifiedTable(rowType);
        Map<String, Table> tableMap = Collections.singletonMap(TEMPORARY_TABLE_NAME, table);
        CalciteSchema schema = CalciteSchemaBuilder.asRootSchema(new TableSpecifiedSchema(tableMap));
        return new FlinkCalciteCatalogReader(schema, (List<List<String>>)new ArrayList<List<String>>(new ArrayList()), (RelDataTypeFactory)typeFactory, (CalciteConnectionConfig)connectionConfig);
    }

    private static class TableSpecifiedSchema
    extends AbstractSchema {
        private final Map<String, Table> tableMap;

        TableSpecifiedSchema(Map<String, Table> tableMap) {
            this.tableMap = Objects.requireNonNull(tableMap);
        }

        @Override
        protected Map<String, Table> getTableMap() {
            return this.tableMap;
        }
    }

    private static class RowTypeSpecifiedTable
    extends AbstractTable {
        private final RelDataType rowType;

        RowTypeSpecifiedTable(RelDataType rowType) {
            this.rowType = Objects.requireNonNull(rowType);
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return this.rowType;
        }
    }
}

