/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.TemporalTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.sources.TableSourceUtil;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import scala.Option;

public class CatalogSchemaTable
extends AbstractTable
implements TemporalTable {
    private final ObjectIdentifier tableIdentifier;
    private final CatalogBaseTable catalogBaseTable;
    private final FlinkStatistic statistic;
    private final boolean isStreamingMode;
    private final boolean isTemporary;
    @Nullable
    private final TableFactory tableFactory;

    public CatalogSchemaTable(ObjectIdentifier tableIdentifier, CatalogBaseTable catalogBaseTable, FlinkStatistic statistic2, @Nullable TableFactory tableFactory, boolean isStreaming, boolean isTemporary) {
        this.tableIdentifier = tableIdentifier;
        this.catalogBaseTable = catalogBaseTable;
        this.statistic = statistic2;
        this.tableFactory = tableFactory;
        this.isStreamingMode = isStreaming;
        this.isTemporary = isTemporary;
    }

    public Optional<TableFactory> getTableFactory() {
        return Optional.ofNullable(this.tableFactory);
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public CatalogBaseTable getCatalogTable() {
        return this.catalogBaseTable;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public boolean isStreamingMode() {
        return this.isStreamingMode;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.getRowType(typeFactory, this.catalogBaseTable, this.isStreamingMode);
    }

    @Override
    public FlinkStatistic getStatistic() {
        return this.statistic;
    }

    private RelDataType getRowType(RelDataTypeFactory typeFactory, CatalogBaseTable catalogBaseTable, boolean isStreamingMode) {
        TableSource<?> source;
        FlinkTypeFactory flinkTypeFactory = (FlinkTypeFactory)typeFactory;
        TableSchema tableSchema = catalogBaseTable.getSchema();
        DataType[] fieldDataTypes = tableSchema.getFieldDataTypes();
        if (!isStreamingMode && catalogBaseTable instanceof ConnectorCatalogTable && ((ConnectorCatalogTable)catalogBaseTable).getTableSource().isPresent()) {
            for (int i = 0; i < fieldDataTypes.length; ++i) {
                LogicalType lt = fieldDataTypes[i].getLogicalType();
                if (!(lt instanceof TimestampType) || ((TimestampType)lt).getKind() != TimestampKind.PROCTIME && ((TimestampType)lt).getKind() != TimestampKind.ROWTIME) continue;
                int precision = ((TimestampType)lt).getPrecision();
                fieldDataTypes[i] = DataTypes.TIMESTAMP((int)precision);
            }
        }
        Optional<TableSource<?>> sourceOpt = this.findAndCreateTableSource();
        if (isStreamingMode && tableSchema.getTableColumns().stream().noneMatch(TableColumn::isGenerated) && tableSchema.getWatermarkSpecs().isEmpty() && sourceOpt.isPresent() && (TableSourceValidation.hasProctimeAttribute(source = sourceOpt.get()) || TableSourceValidation.hasRowtimeAttribute(source))) {
            tableSchema = ConnectorCatalogTable.calculateSourceSchema(source, (boolean)false);
        }
        return TableSourceUtil.getSourceRowType(flinkTypeFactory, tableSchema, Option.empty(), isStreamingMode);
    }

    @Override
    public String getSysStartFieldName() {
        return "sys_start";
    }

    @Override
    public String getSysEndFieldName() {
        return "sys_end";
    }

    private Optional<TableSource<?>> findAndCreateTableSource() {
        Optional<TableSource<?>> tableSource;
        block4: {
            tableSource = Optional.empty();
            try {
                if (!(this.catalogBaseTable instanceof CatalogTableImpl)) break block4;
                TableSource source = TableFactoryUtil.findAndCreateTableSource((CatalogTable)((CatalogTable)this.catalogBaseTable));
                if (source instanceof StreamTableSource) {
                    if (!this.isStreamingMode && !((StreamTableSource)source).isBounded()) {
                        throw new ValidationException("Cannot query on an unbounded source in batch mode, but " + this.tableIdentifier.asSummaryString() + " is unbounded.");
                    }
                    tableSource = Optional.of(source);
                    break block4;
                }
                throw new ValidationException("Catalog tables only support StreamTableSource and InputFormatTableSource.");
            }
            catch (Exception e) {
                tableSource = Optional.empty();
            }
        }
        return tableSource;
    }
}

