/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem$;
import org.apache.flink.table.planner.expressions.BinaryArithmetic;
import org.apache.flink.table.planner.expressions.Ceil;
import org.apache.flink.table.planner.expressions.Div;
import org.apache.flink.table.planner.expressions.Floor;
import org.apache.flink.table.planner.expressions.Literal;
import org.apache.flink.table.planner.expressions.Minus;
import org.apache.flink.table.planner.expressions.Mul;
import org.apache.flink.table.planner.expressions.PlannerExpression;
import org.apache.flink.table.planner.expressions.Plus;
import org.apache.flink.table.planner.expressions.Round;
import org.apache.flink.table.planner.expressions.UnaryExpression;
import org.apache.flink.table.planner.typeutils.TypeCoercion$;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalTypeInfo;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;

public final class ReturnTypeInference$ {
    public static final ReturnTypeInference$ MODULE$;
    private FlinkTypeSystem org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeSystem;
    private FlinkTypeFactory org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeFactory;
    private volatile byte bitmap$0;

    static {
        new ReturnTypeInference$();
    }

    private FlinkTypeSystem org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeSystem$lzycompute() {
        ReturnTypeInference$ returnTypeInference$ = this;
        synchronized (returnTypeInference$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeSystem = new FlinkTypeSystem();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeSystem;
        }
    }

    private FlinkTypeFactory org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeFactory$lzycompute() {
        ReturnTypeInference$ returnTypeInference$ = this;
        synchronized (returnTypeInference$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeFactory = new FlinkTypeFactory(this.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeSystem());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeFactory;
        }
    }

    public FlinkTypeSystem org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeSystem() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeSystem$lzycompute() : this.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeSystem;
    }

    public FlinkTypeFactory org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeFactory() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeFactory$lzycompute() : this.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeFactory;
    }

    public TypeInformation<?> inferMinus(Minus minus) {
        return this.inferPlusOrMinus(minus);
    }

    public TypeInformation<?> inferPlus(Plus plus) {
        return this.inferPlusOrMinus(plus);
    }

    private TypeInformation<?> inferPlusOrMinus(BinaryArithmetic op) {
        Serializable decimalTypeInference = new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final TypeInformation<? super Object> apply(RelDataType leftType, RelDataType rightType, LogicalType wideResultType) {
                TypeInformation typeInformation;
                if (SqlTypeUtil.isExactNumeric(leftType) && SqlTypeUtil.isExactNumeric(rightType) && (SqlTypeUtil.isDecimal(leftType) || SqlTypeUtil.isDecimal(rightType))) {
                    DecimalTypeInfo decimalTypeInfo;
                    int lp = leftType.getPrecision();
                    int ls = leftType.getScale();
                    int rp = rightType.getPrecision();
                    int rs = rightType.getScale();
                    int scale = Math.max(ls, rs);
                    Predef$.MODULE$.assert(scale <= ReturnTypeInference$.MODULE$.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeSystem().getMaxNumericScale());
                    int precision = Math.max(lp - ls, rp - rs) + scale + 1;
                    precision = Math.min(precision, ReturnTypeInference$.MODULE$.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeSystem().getMaxNumericPrecision());
                    Predef$.MODULE$.assert(precision > 0);
                    TypeInformation typeInformation2 = TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)wideResultType);
                    if (typeInformation2 instanceof DecimalTypeInfo) {
                        decimalTypeInfo = DecimalTypeInfo.of((int)precision, (int)scale);
                    } else {
                        if (!(typeInformation2 instanceof BigDecimalTypeInfo)) throw new MatchError((Object)typeInformation2);
                        decimalTypeInfo = BigDecimalTypeInfo.of((int)precision, (int)scale);
                    }
                    typeInformation = decimalTypeInfo;
                    return typeInformation;
                } else {
                    RelDataType resultType2 = ReturnTypeInference$.MODULE$.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeFactory().leastRestrictive((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelDataType[]{leftType, rightType}))).asJava());
                    typeInformation = TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(resultType2));
                }
                return typeInformation;
            }
        };
        return this.inferBinaryArithmetic(op, (Function3<RelDataType, RelDataType, LogicalType, TypeInformation<?>>)decimalTypeInference, (Function1<LogicalType, TypeInformation<?>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(LogicalType t) {
                return TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)t);
            }
        });
    }

    public TypeInformation<?> inferMul(Mul mul) {
        Serializable decimalTypeInference = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RelDataType apply(RelDataType leftType, RelDataType rightType) {
                return ReturnTypeInference$.MODULE$.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeFactory().createDecimalProduct(leftType, rightType);
            }
        };
        return this.inferDivOrMul(mul, (Function2<RelDataType, RelDataType, RelDataType>)decimalTypeInference);
    }

    public TypeInformation<?> inferDiv(Div div) {
        Serializable decimalTypeInference = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RelDataType apply(RelDataType leftType, RelDataType rightType) {
                return ReturnTypeInference$.MODULE$.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeFactory().createDecimalQuotient(leftType, rightType);
            }
        };
        return this.inferDivOrMul(div, (Function2<RelDataType, RelDataType, RelDataType>)decimalTypeInference);
    }

    private TypeInformation<?> inferDivOrMul(BinaryArithmetic op, Function2<RelDataType, RelDataType, RelDataType> decimalTypeInfer) {
        Serializable decimalFunc = new Serializable(decimalTypeInfer){
            public static final long serialVersionUID = 0L;
            private final Function2 decimalTypeInfer$1;

            public final TypeInformation<?> apply(RelDataType leftType, RelDataType rightType, LogicalType x$1) {
                TypeInformation typeInformation;
                RelDataType decimalType = (RelDataType)this.decimalTypeInfer$1.apply((Object)leftType, (Object)rightType);
                if (decimalType == null) {
                    RelDataType resultType2 = ReturnTypeInference$.MODULE$.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeFactory().leastRestrictive((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelDataType[]{leftType, rightType}))).asJava());
                    typeInformation = TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(resultType2));
                } else {
                    typeInformation = TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(decimalType));
                }
                return typeInformation;
            }
            {
                this.decimalTypeInfer$1 = decimalTypeInfer$1;
            }
        };
        Serializable nonDecimalType = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(LogicalType t) {
                return TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)t);
            }
        };
        return this.inferBinaryArithmetic(op, (Function3<RelDataType, RelDataType, LogicalType, TypeInformation<?>>)decimalFunc, (Function1<LogicalType, TypeInformation<?>>)nonDecimalType);
    }

    private TypeInformation<?> inferBinaryArithmetic(BinaryArithmetic binaryOp, Function3<RelDataType, RelDataType, LogicalType, TypeInformation<?>> decimalInfer, Function1<LogicalType, TypeInformation<?>> nonDecimalInfer) {
        Option<LogicalType> option;
        block6: {
            TypeInformation typeInformation;
            block5: {
                Some some;
                boolean bl;
                block4: {
                    LogicalType leftType = TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType(binaryOp.left().resultType());
                    LogicalType rightType = TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType(binaryOp.right().resultType());
                    bl = false;
                    some = null;
                    option = TypeCoercion$.MODULE$.widerTypeOf(leftType, rightType);
                    if (!(option instanceof Some)) break block4;
                    bl = true;
                    some = (Some)option;
                    LogicalType t = (LogicalType)some.x();
                    if (!(t instanceof DecimalType)) break block4;
                    DecimalType decimalType = (DecimalType)t;
                    RelDataType leftRelDataType = this.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeFactory().createFieldTypeFromLogicalType(leftType);
                    RelDataType rightRelDataType = this.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeFactory().createFieldTypeFromLogicalType(rightType);
                    typeInformation = (TypeInformation)decimalInfer.apply((Object)leftRelDataType, (Object)rightRelDataType, (Object)decimalType);
                    break block5;
                }
                if (!bl) break block6;
                LogicalType t = (LogicalType)some.x();
                typeInformation = (TypeInformation)nonDecimalInfer.apply((Object)t);
            }
            return typeInformation;
        }
        if (None$.MODULE$.equals(option)) {
            throw new TableException("This will not happen here!");
        }
        throw new MatchError(option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TypeInformation<?> inferRound(Round round) {
        int n;
        TypeInformation numType = round.left().resultType();
        TypeInformation typeInformation = numType;
        boolean bl = typeInformation instanceof DecimalTypeInfo ? true : typeInformation instanceof BigDecimalTypeInfo;
        if (!bl) return typeInformation;
        PlannerExpression plannerExpression = round.right();
        if (!(plannerExpression instanceof Literal)) throw new TableException("This will not happen here!");
        Literal literal = (Literal)plannerExpression;
        Object v = literal.value();
        TypeInformation<?> typeInformation2 = literal.resultType();
        if (!(v instanceof Integer)) throw new TableException("This will not happen here!");
        int n2 = BoxesRunTime.unboxToInt((Object)v);
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
        TypeInformation<?> typeInformation3 = typeInformation2;
        if (basicTypeInfo == null) {
            if (typeInformation3 != null) {
                throw new TableException("This will not happen here!");
            }
        } else if (!basicTypeInfo.equals(typeInformation3)) throw new TableException("This will not happen here!");
        int lenValue = n = n2;
        LogicalType numLogicalType = TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType(numType);
        RelDataType numRelDataType = this.org$apache$flink$table$planner$expressions$ReturnTypeInference$$typeFactory().createFieldTypeFromLogicalType(numLogicalType);
        int p = numRelDataType.getPrecision();
        int s = numRelDataType.getScale();
        DecimalType dt = FlinkTypeSystem$.MODULE$.inferRoundType(p, s, lenValue);
        return TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)dt);
    }

    public TypeInformation<?> inferFloor(Floor floor) {
        return this.getArg0OrExactNoScale(floor);
    }

    public TypeInformation<?> inferCeil(Ceil ceil) {
        return this.getArg0OrExactNoScale(ceil);
    }

    private TypeInformation<?> getArg0OrExactNoScale(UnaryExpression op) {
        DecimalTypeInfo decimalTypeInfo;
        DecimalTypeInfo childType = op.child().resultType();
        DecimalTypeInfo decimalTypeInfo2 = childType;
        if (decimalTypeInfo2 instanceof DecimalTypeInfo) {
            DecimalTypeInfo decimalTypeInfo3 = decimalTypeInfo2;
            decimalTypeInfo = DecimalTypeInfo.of((int)decimalTypeInfo3.precision(), (int)0);
        } else if (decimalTypeInfo2 instanceof BigDecimalTypeInfo) {
            BigDecimalTypeInfo bigDecimalTypeInfo = (BigDecimalTypeInfo)decimalTypeInfo2;
            decimalTypeInfo = BigDecimalTypeInfo.of((int)bigDecimalTypeInfo.precision(), (int)0);
        } else {
            decimalTypeInfo = childType;
        }
        return decimalTypeInfo;
    }

    private ReturnTypeInference$() {
        MODULE$ = this;
    }
}

