/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.Arrays;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.aggfunctions.RankLikeAggFunctionBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.LogicalTypeDataTypeConverter;

public class RankAggFunction
extends RankLikeAggFunctionBase {
    private UnresolvedReferenceExpression currNumber = ApiExpressionUtils.unresolvedRef((String)"currNumber");

    public RankAggFunction(LogicalType[] orderKeyTypes) {
        super(orderKeyTypes);
    }

    @Override
    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        UnresolvedReferenceExpression[] aggBufferAttrs = new UnresolvedReferenceExpression[2 + this.lastValues.length];
        aggBufferAttrs[0] = this.currNumber;
        aggBufferAttrs[1] = this.sequence;
        System.arraycopy(this.lastValues, 0, aggBufferAttrs, 2, this.lastValues.length);
        return aggBufferAttrs;
    }

    @Override
    public DataType[] getAggBufferTypes() {
        DataType[] aggBufferTypes2 = new DataType[2 + this.orderKeyTypes.length];
        aggBufferTypes2[0] = DataTypes.BIGINT();
        aggBufferTypes2[1] = DataTypes.BIGINT();
        System.arraycopy(Arrays.stream(this.orderKeyTypes).map(LogicalTypeDataTypeConverter::toDataType).toArray(DataType[]::new), 0, aggBufferTypes2, 2, this.orderKeyTypes.length);
        return aggBufferTypes2;
    }

    @Override
    public Expression[] initialValuesExpressions() {
        Expression[] initExpressions = new Expression[2 + this.orderKeyTypes.length];
        initExpressions[0] = ExpressionBuilder.literal(0L);
        initExpressions[1] = ExpressionBuilder.literal(0L);
        for (int i = 0; i < this.orderKeyTypes.length; ++i) {
            initExpressions[i + 2] = this.generateInitLiteral(this.orderKeyTypes[i]);
        }
        return initExpressions;
    }

    @Override
    public Expression[] accumulateExpressions() {
        Expression[] accExpressions = new Expression[2 + this.operands().length];
        accExpressions[0] = ExpressionBuilder.plus((Expression)this.currNumber, (Expression)ExpressionBuilder.literal(1L));
        accExpressions[1] = ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.and(this.orderKeyEqualsExpression(), (Expression)ExpressionBuilder.not((Expression)ExpressionBuilder.equalTo((Expression)this.sequence, (Expression)ExpressionBuilder.literal(0L)))), (Expression)this.sequence, (Expression)this.currNumber);
        UnresolvedReferenceExpression[] operands = this.operands();
        System.arraycopy(operands, 0, accExpressions, 2, operands.length);
        return accExpressions;
    }
}

