/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Optionality;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.util.Preconditions;

public final class FlinkAggregateExpandDistinctAggregatesRule
extends RelOptRule {
    public static final FlinkAggregateExpandDistinctAggregatesRule INSTANCE = new FlinkAggregateExpandDistinctAggregatesRule(LogicalAggregate.class, true, RelFactories.LOGICAL_BUILDER);
    public static final FlinkAggregateExpandDistinctAggregatesRule JOIN = new FlinkAggregateExpandDistinctAggregatesRule(LogicalAggregate.class, false, RelFactories.LOGICAL_BUILDER);
    public final boolean useGroupingSets;

    public FlinkAggregateExpandDistinctAggregatesRule(Class<? extends Aggregate> clazz, boolean useGroupingSets, RelBuilderFactory relBuilderFactory) {
        super(FlinkAggregateExpandDistinctAggregatesRule.operand(clazz, FlinkAggregateExpandDistinctAggregatesRule.any()), relBuilderFactory, null);
        this.useGroupingSets = useGroupingSets;
    }

    @Deprecated
    public FlinkAggregateExpandDistinctAggregatesRule(Class<? extends LogicalAggregate> clazz, boolean useGroupingSets, RelFactories.JoinFactory joinFactory) {
        this(clazz, useGroupingSets, RelBuilder.proto(Contexts.of((Object)joinFactory)));
    }

    @Deprecated
    public FlinkAggregateExpandDistinctAggregatesRule(Class<? extends LogicalAggregate> clazz, RelFactories.JoinFactory joinFactory) {
        this(clazz, false, RelBuilder.proto(Contexts.of((Object)joinFactory)));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        if (!AggregateUtil.containsAccurateDistinctCall(aggregate.getAggCallList())) {
            return;
        }
        if (AggregateUtil.containsApproximateDistinctCall(aggregate.getAggCallList())) {
            throw new TableException("There are both Distinct AggCall and Approximate Distinct AggCall in one sql statement, it is not supported yet.\nPlease choose one of them.");
        }
        if (aggregate.getGroupSets().size() > 1) {
            return;
        }
        int nonDistinctAggCallCount = 0;
        int nonDistinctAggCallExcludingIgnoredCount = 0;
        int filterCount = 0;
        int unsupportedNonDistinctAggCallCount = 0;
        LinkedHashSet<Pair<List<Integer>, Integer>> argLists = new LinkedHashSet<Pair<List<Integer>, Integer>>();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            if (aggCall.filterArg >= 0) {
                ++filterCount;
            }
            if (!aggCall.isDistinct()) {
                ++nonDistinctAggCallCount;
                SqlKind aggCallKind = aggCall.getAggregation().getKind();
                switch (aggCallKind) {
                    case COUNT: 
                    case SUM: 
                    case SUM0: 
                    case MIN: 
                    case MAX: {
                        break;
                    }
                    default: {
                        ++unsupportedNonDistinctAggCallCount;
                    }
                }
                if (aggCall.getAggregation().getDistinctOptionality() == Optionality.IGNORED) {
                    argLists.add(Pair.of(aggCall.getArgList(), aggCall.filterArg));
                    continue;
                }
                ++nonDistinctAggCallExcludingIgnoredCount;
                continue;
            }
            argLists.add(Pair.of(aggCall.getArgList(), aggCall.filterArg));
        }
        int distinctAggCallCount = aggregate.getAggCallList().size() - nonDistinctAggCallCount;
        Preconditions.checkState((argLists.size() > 0 ? 1 : 0) != 0, (Object)"containsDistinctCall lied");
        if (nonDistinctAggCallExcludingIgnoredCount == 0 && argLists.size() == 1 && aggregate.getGroupType() == Aggregate.Group.SIMPLE) {
            Pair pair = (Pair)Iterables.getOnlyElement(argLists);
            RelBuilder relBuilder = call.builder();
            this.convertMonopole(relBuilder, aggregate, (List)pair.left, (Integer)pair.right);
            call.transformTo(relBuilder.build());
            return;
        }
        if (this.useGroupingSets) {
            this.rewriteUsingGroupingSets(call, aggregate);
            return;
        }
        if (distinctAggCallCount == 1 && filterCount == 0 && unsupportedNonDistinctAggCallCount == 0 && nonDistinctAggCallCount > 0) {
            RelBuilder relBuilder = call.builder();
            this.convertSingletonDistinct(relBuilder, aggregate, argLists);
            call.transformTo(relBuilder.build());
            return;
        }
        List<RelDataTypeField> aggFields = aggregate.getRowType().getFieldList();
        ArrayList<RexInputRef> refs = new ArrayList<RexInputRef>();
        List<String> fieldNames = aggregate.getRowType().getFieldNames();
        ImmutableBitSet groupSet = aggregate.getGroupSet();
        int groupCount = aggregate.getGroupCount();
        for (int i2 : Util.range(groupCount)) {
            refs.add(RexInputRef.of(i2, aggFields));
        }
        ArrayList<AggregateCall> newAggCallList = new ArrayList<AggregateCall>();
        int i = -1;
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            ++i;
            if (aggCall.isDistinct()) {
                refs.add(null);
                continue;
            }
            refs.add(new RexInputRef(groupCount + newAggCallList.size(), aggFields.get(groupCount + i).getType()));
            newAggCallList.add(aggCall);
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push(aggregate.getInput());
        int n = 0;
        if (!newAggCallList.isEmpty()) {
            RelBuilder.GroupKey groupKey = relBuilder.groupKey(groupSet, aggregate.getGroupSets());
            relBuilder.aggregate(groupKey, (List<AggregateCall>)newAggCallList);
            ++n;
        }
        for (Pair pair : argLists) {
            this.doRewrite(relBuilder, aggregate, n++, (List)pair.left, (Integer)pair.right, refs);
        }
        relBuilder.project(refs, fieldNames);
        call.transformTo(relBuilder.build());
    }

    private RelBuilder convertSingletonDistinct(RelBuilder relBuilder, Aggregate aggregate, Set<Pair<List<Integer>, Integer>> argLists) {
        Preconditions.checkArgument((argLists.size() == 1 ? 1 : 0) != 0);
        relBuilder.push(aggregate.getInput());
        List<AggregateCall> originalAggCalls = aggregate.getAggCallList();
        ImmutableBitSet originalGroupSet = aggregate.getGroupSet();
        TreeSet<Integer> bottomGroupSet = new TreeSet<Integer>();
        bottomGroupSet.addAll(aggregate.getGroupSet().asList());
        for (AggregateCall aggregateCall : originalAggCalls) {
            if (!aggregateCall.isDistinct()) continue;
            bottomGroupSet.addAll(aggregateCall.getArgList());
            break;
        }
        ArrayList<AggregateCall> bottomAggregateCalls = new ArrayList<AggregateCall>();
        for (AggregateCall aggCall : originalAggCalls) {
            if (aggCall.isDistinct()) continue;
            AggregateCall newCall = AggregateCall.create(aggCall.getAggregation(), false, aggCall.isApproximate(), false, aggCall.getArgList(), -1, RelCollations.EMPTY, ImmutableBitSet.of(bottomGroupSet).cardinality(), relBuilder.peek(), null, aggCall.name);
            bottomAggregateCalls.add(newCall);
        }
        relBuilder.push(aggregate.copy(aggregate.getTraitSet(), relBuilder.build(), ImmutableBitSet.of(bottomGroupSet), null, bottomAggregateCalls));
        ArrayList<AggregateCall> arrayList = Lists.newArrayList();
        int nonDistinctAggCallProcessedSoFar = 0;
        for (AggregateCall aggCall : originalAggCalls) {
            AggregateCall newCall;
            if (aggCall.isDistinct()) {
                ArrayList<Integer> newArgList = new ArrayList<Integer>();
                for (int arg : aggCall.getArgList()) {
                    newArgList.add(bottomGroupSet.headSet(arg).size());
                }
                newCall = AggregateCall.create(aggCall.getAggregation(), false, aggCall.isApproximate(), false, newArgList, -1, RelCollations.EMPTY, originalGroupSet.cardinality(), relBuilder.peek(), aggCall.getType(), aggCall.name);
            } else {
                ArrayList<Integer> newArgs = Lists.newArrayList(bottomGroupSet.size() + nonDistinctAggCallProcessedSoFar);
                newCall = aggCall.getAggregation().getKind() == SqlKind.COUNT ? AggregateCall.create(new SqlSumEmptyIsZeroAggFunction(), false, aggCall.isApproximate(), false, newArgs, -1, RelCollations.EMPTY, originalGroupSet.cardinality(), relBuilder.peek(), aggCall.getType(), aggCall.getName()) : AggregateCall.create(aggCall.getAggregation(), false, aggCall.isApproximate(), false, newArgs, -1, RelCollations.EMPTY, originalGroupSet.cardinality(), relBuilder.peek(), aggCall.getType(), aggCall.name);
                ++nonDistinctAggCallProcessedSoFar;
            }
            arrayList.add(newCall);
        }
        HashSet<Integer> topGroupSet = new HashSet<Integer>();
        int groupSetToAdd = 0;
        Iterator iterator = bottomGroupSet.iterator();
        while (iterator.hasNext()) {
            int bottomGroup = (Integer)iterator.next();
            if (originalGroupSet.get(bottomGroup)) {
                topGroupSet.add(groupSetToAdd);
            }
            ++groupSetToAdd;
        }
        relBuilder.push(aggregate.copy(aggregate.getTraitSet(), relBuilder.build(), ImmutableBitSet.of(topGroupSet), null, arrayList));
        return relBuilder;
    }

    private void rewriteUsingGroupingSets(RelOptRuleCall call, Aggregate aggregate) {
        TreeSet<ImmutableBitSet> groupSetTreeSet = new TreeSet<ImmutableBitSet>(ImmutableBitSet.ORDERING);
        HashMap<ImmutableBitSet, Integer> groupSetToDistinctAggCallFilterArg = new HashMap<ImmutableBitSet, Integer>();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            if (!aggCall.isDistinct()) {
                groupSetTreeSet.add(aggregate.getGroupSet());
                continue;
            }
            ImmutableBitSet groupSet = ImmutableBitSet.of(aggCall.getArgList()).setIf(aggCall.filterArg, aggCall.filterArg >= 0).union(aggregate.getGroupSet());
            groupSetToDistinctAggCallFilterArg.put(groupSet, aggCall.filterArg);
            groupSetTreeSet.add(groupSet);
        }
        ImmutableList<ImmutableBitSet> groupSets = ImmutableList.copyOf(groupSetTreeSet);
        ImmutableBitSet fullGroupSet = ImmutableBitSet.union(groupSets);
        ArrayList<AggregateCall> distinctAggCalls = new ArrayList<AggregateCall>();
        for (Pair<AggregateCall, String> aggCall : aggregate.getNamedAggCalls()) {
            if (((AggregateCall)aggCall.left).isDistinct()) continue;
            AggregateCall newAggCall = ((AggregateCall)aggCall.left).adaptTo(aggregate.getInput(), ((AggregateCall)aggCall.left).getArgList(), ((AggregateCall)aggCall.left).filterArg, aggregate.getGroupCount(), fullGroupSet.cardinality());
            distinctAggCalls.add(newAggCall.rename((String)aggCall.right));
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push(aggregate.getInput());
        int groupCount = fullGroupSet.cardinality();
        LinkedHashMap filters = new LinkedHashMap();
        int z = groupCount + distinctAggCalls.size();
        distinctAggCalls.add(AggregateCall.create(SqlStdOperatorTable.GROUPING, false, false, false, ImmutableIntList.copyOf(fullGroupSet), -1, RelCollations.EMPTY, groupSets.size(), relBuilder.peek(), null, "$g"));
        for (Ord<ImmutableBitSet> groupSet : Ord.zip(groupSets)) {
            filters.put(groupSet.e, z + groupSet.i);
        }
        relBuilder.aggregate(relBuilder.groupKey(fullGroupSet, groupSets), (List<AggregateCall>)distinctAggCalls);
        RelNode distinct = relBuilder.peek();
        if (!filters.isEmpty()) {
            ArrayList<RexNode> nodes = new ArrayList<RexNode>(relBuilder.fields());
            RexNode nodeZ = (RexNode)nodes.remove(nodes.size() - 1);
            for (Map.Entry entry : filters.entrySet()) {
                RexNode expr;
                long v = FlinkAggregateExpandDistinctAggregatesRule.groupValue(fullGroupSet, (ImmutableBitSet)entry.getKey());
                int distinctAggCallFilterArg = FlinkAggregateExpandDistinctAggregatesRule.remap(fullGroupSet, groupSetToDistinctAggCallFilterArg.getOrDefault(entry.getKey(), -1));
                if (distinctAggCallFilterArg < 0) {
                    expr = relBuilder.equals(nodeZ, relBuilder.literal(v));
                } else {
                    RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
                    expr = relBuilder.and(relBuilder.equals(nodeZ, relBuilder.literal(v)), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_TRUE, relBuilder.field(distinctAggCallFilterArg)));
                }
                nodes.add(relBuilder.alias(expr, "$g_" + v));
            }
            relBuilder.project(nodes);
        }
        int aggCallIdx = 0;
        int x = groupCount;
        ArrayList<AggregateCall> newCalls = new ArrayList<AggregateCall>();
        ArrayList<Integer> needDefaultValueAggCalls = new ArrayList<Integer>();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            int newFilterArg;
            ImmutableIntList newArgList;
            SqlAggFunction aggregation;
            if (!aggCall.isDistinct()) {
                aggregation = SqlStdOperatorTable.MIN;
                newArgList = ImmutableIntList.of(x++);
                newFilterArg = (Integer)filters.get(aggregate.getGroupSet());
                switch (aggCall.getAggregation().getKind()) {
                    case COUNT: {
                        needDefaultValueAggCalls.add(aggCallIdx);
                        break;
                    }
                }
            } else {
                aggregation = aggCall.getAggregation();
                newArgList = FlinkAggregateExpandDistinctAggregatesRule.remap(fullGroupSet, aggCall.getArgList());
                newFilterArg = (Integer)filters.get(ImmutableBitSet.of(aggCall.getArgList()).setIf(aggCall.filterArg, aggCall.filterArg >= 0).union(aggregate.getGroupSet()));
            }
            AggregateCall newCall = AggregateCall.create(aggregation, false, aggCall.isApproximate(), false, newArgList, newFilterArg, RelCollations.EMPTY, aggregate.getGroupCount(), distinct, null, aggCall.name);
            newCalls.add(newCall);
            ++aggCallIdx;
        }
        relBuilder.aggregate(relBuilder.groupKey(FlinkAggregateExpandDistinctAggregatesRule.remap(fullGroupSet, aggregate.getGroupSet()), FlinkAggregateExpandDistinctAggregatesRule.remap(fullGroupSet, aggregate.getGroupSets())), (List<AggregateCall>)newCalls);
        if (!needDefaultValueAggCalls.isEmpty() && aggregate.getGroupCount() == 0) {
            int i;
            Aggregate newAgg = (Aggregate)relBuilder.peek();
            ArrayList<RexInputRef> nodes = new ArrayList<RexInputRef>();
            for (i = 0; i < newAgg.getGroupCount(); ++i) {
                nodes.add(RexInputRef.of(i, newAgg.getRowType()));
            }
            for (i = 0; i < newAgg.getAggCallList().size(); ++i) {
                RexInputRef inputRef;
                RexNode newNode = inputRef = RexInputRef.of(newAgg.getGroupCount() + i, newAgg.getRowType());
                if (needDefaultValueAggCalls.contains(i)) {
                    SqlKind originalFunKind = aggregate.getAggCallList().get(i).getAggregation().getKind();
                    switch (originalFunKind) {
                        case COUNT: {
                            newNode = relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, relBuilder.isNotNull(inputRef), inputRef, relBuilder.literal(BigDecimal.ZERO));
                            break;
                        }
                    }
                }
                nodes.add((RexInputRef)newNode);
            }
            relBuilder.project(nodes);
        }
        relBuilder.convert(aggregate.getRowType(), true);
        call.transformTo(relBuilder.build());
    }

    private static long groupValue(ImmutableBitSet fullGroupSet, ImmutableBitSet groupSet) {
        long v = 0L;
        long x = 1L << fullGroupSet.cardinality() - 1;
        assert (fullGroupSet.contains(groupSet));
        for (int i : fullGroupSet) {
            if (!groupSet.get(i)) {
                v |= x;
            }
            x >>= 1;
        }
        return v;
    }

    private static ImmutableBitSet remap(ImmutableBitSet groupSet, ImmutableBitSet bitSet) {
        ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
        for (Integer bit : bitSet) {
            builder.set(FlinkAggregateExpandDistinctAggregatesRule.remap(groupSet, bit));
        }
        return builder.build();
    }

    private static ImmutableList<ImmutableBitSet> remap(ImmutableBitSet groupSet, Iterable<ImmutableBitSet> bitSets) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ImmutableBitSet bitSet : bitSets) {
            builder.add(FlinkAggregateExpandDistinctAggregatesRule.remap(groupSet, bitSet));
        }
        return builder.build();
    }

    private static List<Integer> remap(ImmutableBitSet groupSet, List<Integer> argList) {
        ImmutableIntList list = ImmutableIntList.of();
        for (int arg : argList) {
            list = list.append(FlinkAggregateExpandDistinctAggregatesRule.remap(groupSet, arg));
        }
        return list;
    }

    private static int remap(ImmutableBitSet groupSet, int arg) {
        return arg < 0 ? -1 : groupSet.indexOf(arg);
    }

    private RelBuilder convertMonopole(RelBuilder relBuilder, Aggregate aggregate, List<Integer> argList, int filterArg) {
        HashMap<Integer, Integer> sourceOf = new HashMap<Integer, Integer>();
        this.createSelectDistinct(relBuilder, aggregate, argList, filterArg, sourceOf);
        ArrayList<AggregateCall> newAggCalls = Lists.newArrayList(aggregate.getAggCallList());
        FlinkAggregateExpandDistinctAggregatesRule.rewriteAggCalls(newAggCalls, argList, sourceOf);
        int cardinality = aggregate.getGroupSet().cardinality();
        relBuilder.push(aggregate.copy(aggregate.getTraitSet(), relBuilder.build(), ImmutableBitSet.range(cardinality), null, newAggCalls));
        return relBuilder;
    }

    private void doRewrite(RelBuilder relBuilder, Aggregate aggregate, int n, List<Integer> argList, int filterArg, List<RexInputRef> refs) {
        RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
        List<RelDataTypeField> leftFields = n == 0 ? null : relBuilder.peek().getRowType().getFieldList();
        HashMap<Integer, Integer> sourceOf = new HashMap<Integer, Integer>();
        this.createSelectDistinct(relBuilder, aggregate, argList, filterArg, sourceOf);
        ArrayList<AggregateCall> aggCallList = new ArrayList<AggregateCall>();
        List<AggregateCall> aggCalls = aggregate.getAggCallList();
        int groupCount = aggregate.getGroupCount();
        int i = groupCount - 1;
        for (AggregateCall aggregateCall : aggCalls) {
            ++i;
            if (!aggregateCall.isDistinct() || !aggregateCall.getArgList().equals(argList)) continue;
            int argCount = aggregateCall.getArgList().size();
            ArrayList<Integer> newArgs = new ArrayList<Integer>(argCount);
            for (int j2 = 0; j2 < argCount; ++j2) {
                Integer arg = aggregateCall.getArgList().get(j2);
                newArgs.add((Integer)sourceOf.get(arg));
            }
            int newFilterArg = aggregateCall.filterArg >= 0 ? (Integer)sourceOf.get(aggregateCall.filterArg) : -1;
            AggregateCall newAggCall = AggregateCall.create(aggregateCall.getAggregation(), false, aggregateCall.isApproximate(), false, newArgs, newFilterArg, RelCollations.EMPTY, aggregateCall.getType(), aggregateCall.getName());
            assert (refs.get(i) == null);
            if (n == 0) {
                refs.set(i, new RexInputRef(groupCount + aggCallList.size(), newAggCall.getType()));
            } else {
                refs.set(i, new RexInputRef(leftFields.size() + groupCount + aggCallList.size(), newAggCall.getType()));
            }
            aggCallList.add(newAggCall);
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (Integer key : aggregate.getGroupSet()) {
            map.put(key, map.size());
        }
        ImmutableBitSet immutableBitSet = aggregate.getGroupSet().permute(map);
        assert (immutableBitSet.equals(ImmutableBitSet.range(aggregate.getGroupSet().cardinality())));
        relBuilder.push(aggregate.copy(aggregate.getTraitSet(), relBuilder.build(), immutableBitSet, null, aggCallList));
        if (n == 0) {
            return;
        }
        List<RelDataTypeField> distinctFields = relBuilder.peek().getRowType().getFieldList();
        ArrayList<RexNode> conditions = Lists.newArrayList();
        for (i = 0; i < groupCount; ++i) {
            conditions.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, RexInputRef.of(i, leftFields), new RexInputRef(leftFields.size() + i, distinctFields.get(i).getType())));
        }
        relBuilder.join(JoinRelType.INNER, conditions);
    }

    private static void rewriteAggCalls(List<AggregateCall> newAggCalls, List<Integer> argList, Map<Integer, Integer> sourceOf) {
        for (int i = 0; i < newAggCalls.size(); ++i) {
            AggregateCall aggCall = newAggCalls.get(i);
            if (!aggCall.isDistinct() && aggCall.getAggregation().getDistinctOptionality() != Optionality.IGNORED || !aggCall.getArgList().equals(argList)) continue;
            int argCount = aggCall.getArgList().size();
            ArrayList<Integer> newArgs = new ArrayList<Integer>(argCount);
            for (int j2 = 0; j2 < argCount; ++j2) {
                Integer arg = aggCall.getArgList().get(j2);
                newArgs.add(sourceOf.get(arg));
            }
            AggregateCall newAggCall = AggregateCall.create(aggCall.getAggregation(), false, aggCall.isApproximate(), false, newArgs, -1, RelCollations.EMPTY, aggCall.getType(), aggCall.getName());
            newAggCalls.set(i, newAggCall);
        }
    }

    private RelBuilder createSelectDistinct(RelBuilder relBuilder, Aggregate aggregate, List<Integer> argList, int filterArg, Map<Integer, Integer> sourceOf) {
        relBuilder.push(aggregate.getInput());
        ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
        List<RelDataTypeField> childFields = relBuilder.peek().getRowType().getFieldList();
        for (int i : aggregate.getGroupSet()) {
            sourceOf.put(i, projects.size());
            projects.add(RexInputRef.of2(i, childFields));
        }
        if (filterArg >= 0) {
            sourceOf.put(filterArg, projects.size());
            projects.add(RexInputRef.of2(filterArg, childFields));
        }
        for (Integer arg : argList) {
            if (filterArg >= 0) {
                RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
                RexInputRef filterRef = RexInputRef.of(filterArg, childFields);
                Pair<RexNode, String> argRef = RexInputRef.of2(arg, childFields);
                RexNode condition = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, filterRef, (RexNode)argRef.left, rexBuilder.makeNullLiteral(((RexNode)argRef.left).getType()));
                sourceOf.put(arg, projects.size());
                projects.add(Pair.of(condition, "i$" + (String)argRef.right));
                continue;
            }
            if (sourceOf.get(arg) != null) continue;
            sourceOf.put(arg, projects.size());
            projects.add(RexInputRef.of2(arg, childFields));
        }
        relBuilder.project(Pair.left(projects), Pair.right(projects));
        relBuilder.push(aggregate.copy(aggregate.getTraitSet(), relBuilder.build(), ImmutableBitSet.range(projects.size()), null, ImmutableList.of()));
        return relBuilder;
    }
}

