/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder$;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverterFactory;
import org.apache.flink.table.planner.catalog.CatalogSchemaTable;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001E\u0011!cQ1uC2|wmU8ve\u000e,G+\u00192mK*\u00111\u0001B\u0001\u0007g\u000eDW-\\1\u000b\u0005\u00151\u0011\u0001\u00029mC:T!a\u0002\u0005\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u0001QC\u0001\nZ'\t\u00011\u0003\u0005\u0002\u0015+5\t!!\u0003\u0002\u0017\u0005\t9b\t\\5oWB\u0013X\r]1sS:<G+\u00192mK\n\u000b7/\u001a\u0005\t1\u0001\u0011\t\u0011)A\u00053\u0005a!/\u001a7PaR\u001c6\r[3nCB\u0011!DH\u0007\u00027)\u0011Q\u0001\b\u0006\u0003;1\tqaY1mG&$X-\u0003\u0002 7\ta!+\u001a7PaR\u001c6\r[3nC\"A\u0011\u0005\u0001B\u0001B\u0003%!%A\u0003oC6,7\u000fE\u0002$Q)j\u0011\u0001\n\u0006\u0003K\u0019\nA!\u001e;jY*\tq%\u0001\u0003kCZ\f\u0017BA\u0015%\u0005\u0011a\u0015n\u001d;\u0011\u0005-\ndB\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj\u0013A\u0002)sK\u0012,g-\u0003\u00023g\t11\u000b\u001e:j]\u001eT!\u0001M\u0017\t\u0011U\u0002!\u0011!Q\u0001\nY\nqA]8x)f\u0004X\r\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005!A/\u001f9f\u0015\tYD$A\u0002sK2L!!\u0010\u001d\u0003\u0017I+G\u000eR1uCRK\b/\u001a\u0005\t\u007f\u0001\u0011)\u0019!C\u0001\u0001\u0006Y1o\u00195f[\u0006$\u0016M\u00197f+\u0005\t\u0005C\u0001\"F\u001b\u0005\u0019%B\u0001#\u0007\u0003\u001d\u0019\u0017\r^1m_\u001eL!AR\"\u0003%\r\u000bG/\u00197pON\u001b\u0007.Z7b)\u0006\u0014G.\u001a\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0003\u0006a1o\u00195f[\u0006$\u0016M\u00197fA!A!\n\u0001BC\u0002\u0013\u00051*\u0001\u0007dCR\fGn\\4UC\ndW-F\u0001M!\tiu*D\u0001O\u0015\t!\u0005\"\u0003\u0002Q\u001d\na1)\u0019;bY><G+\u00192mK\"A!\u000b\u0001B\u0001B\u0003%A*A\u0007dCR\fGn\\4UC\ndW\r\t\u0005\u0006)\u0002!\t!V\u0001\u0007y%t\u0017\u000e\u001e \u0015\rY\u00137\rZ3g!\r!\u0002a\u0016\t\u00031fc\u0001\u0001B\u0003[\u0001\t\u00071LA\u0001U#\tav\f\u0005\u0002-;&\u0011a,\f\u0002\b\u001d>$\b.\u001b8h!\ta\u0003-\u0003\u0002b[\t\u0019\u0011I\\=\t\u000ba\u0019\u0006\u0019A\r\t\u000b\u0005\u001a\u0006\u0019\u0001\u0012\t\u000bU\u001a\u0006\u0019\u0001\u001c\t\u000b}\u001a\u0006\u0019A!\t\u000b)\u001b\u0006\u0019\u0001'\t\u0011!\u0004\u0001R1A\u0005\u0002%\f1bY8mk6tW\t\u001f9sgV\t!\u000e\u0005\u0003,W*R\u0013B\u000174\u0005\ri\u0015\r\u001d\u0005\t]\u0002A\t\u0011)Q\u0005U\u0006a1m\u001c7v[:,\u0005\u0010\u001d:tA!A\u0001\u000f\u0001EC\u0002\u0013\u0005\u0011/A\u0006uC\ndWmU8ve\u000e,W#\u0001:\u0011\u0007M4x+D\u0001u\u0015\t)\b\"A\u0004t_V\u00148-Z:\n\u0005]$(a\u0003+bE2,7k\\;sG\u0016D\u0001\"\u001f\u0001\t\u0002\u0003\u0006KA]\u0001\ri\u0006\u0014G.Z*pkJ\u001cW\r\t\u0005\u0006w\u0002!\t\u0005`\u0001\u0011O\u0016$\u0018+^1mS\u001aLW\r\u001a(b[\u0016$\u0012A\t\u0005\u0006}\u0002!\te`\u0001\u0006i>\u0014V\r\u001c\u000b\u0005\u0003\u0003\tI\u0001\u0005\u0003\u0002\u0004\u0005\u0015Q\"\u0001\u001e\n\u0007\u0005\u001d!HA\u0004SK2tu\u000eZ3\t\u000f\u0005-Q\u00101\u0001\u0002\u000e\u000591m\u001c8uKb$\b\u0003BA\b\u0003+q1AGA\t\u0013\r\t\u0019bG\u0001\f%\u0016dw\n\u001d;UC\ndW-\u0003\u0003\u0002\u0018\u0005e!\u0001\u0004+p%\u0016d7i\u001c8uKb$(bAA\n7!9\u0011Q\u0004\u0001\u0005\n\u0005}\u0011\u0001\u00074j]\u0012\fe\u000eZ\"sK\u0006$X\rV1cY\u0016\u001cv.\u001e:dKR\u0011\u0011\u0011\u0005\u0019\u0005\u0003G\t9\u0003\u0005\u0003tm\u0006\u0015\u0002c\u0001-\u0002(\u0011Y\u0011\u0011FA\u000e\u0003\u0003\u0005\tQ!\u0001\\\u0005\ryF%\r\u0005\b\u0003[\u0001A\u0011KA\u0018\u0003U)\u0007\u0010\u001d7bS:\u001cv.\u001e:dK\u0006\u001b8\u000b\u001e:j]\u001e$2AIA\u0019\u0011!\t\u0019$a\u000bA\u0002\u0005U\u0012A\u0001;ta\u0011\t9$a\u000f\u0011\tM4\u0018\u0011\b\t\u00041\u0006mBaCA\u001f\u0003c\t\t\u0011!A\u0003\u0002m\u00131a\u0018\u00133\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007\n!#\u001a:bg\u0016$\u0016.\\3J]\u0012L7-\u0019;peR9a'!\u0012\u0002J\u0005]\u0003bBA$\u0003\u007f\u0001\rAN\u0001\fe\u0016dG)\u0019;b)f\u0004X\r\u0003\u0005\u0002L\u0005}\u0002\u0019AA'\u0003\u001d1\u0017m\u0019;pef\u0004B!a\u0014\u0002T5\u0011\u0011\u0011\u000b\u0006\u0003;\u0019IA!!\u0016\u0002R\t\u0001b\t\\5oWRK\b/\u001a$bGR|'/\u001f\u0005\ba\u0006}\u0002\u0019AA-a\u0011\tY&a\u0018\u0011\tM4\u0018Q\f\t\u00041\u0006}CaCA1\u0003/\n\t\u0011!A\u0003\u0002m\u00131a\u0018\u00135\u0001")
public class CatalogSourceTable<T>
extends FlinkPreparingTableBase {
    private final RelOptSchema relOptSchema;
    private final RelDataType rowType;
    private final CatalogSchemaTable schemaTable;
    private final CatalogTable catalogTable;
    private Map<String, String> columnExprs;
    private TableSource<T> tableSource;
    private volatile byte bitmap$0;

    private Map columnExprs$lzycompute() {
        CatalogSourceTable catalogSourceTable = this;
        synchronized (catalogSourceTable) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.columnExprs = ((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(this.catalogTable().getSchema().getTableColumns()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(TableColumn column) {
                        return column.isGenerated();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(TableColumn column) {
                        return new Tuple2((Object)column.getName(), column.getExpr().get());
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.columnExprs;
        }
    }

    private TableSource tableSource$lzycompute() {
        CatalogSourceTable catalogSourceTable = this;
        synchronized (catalogSourceTable) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.tableSource = this.findAndCreateTableSource();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.tableSource;
        }
    }

    public CatalogSchemaTable schemaTable() {
        return this.schemaTable;
    }

    public CatalogTable catalogTable() {
        return this.catalogTable;
    }

    public Map<String, String> columnExprs() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.columnExprs$lzycompute() : this.columnExprs;
    }

    public TableSource<T> tableSource() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.tableSource$lzycompute() : this.tableSource;
    }

    @Override
    public List<String> getQualifiedName() {
        return this.explainSourceAsString(this.tableSource());
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context) {
        Object object;
        Object object2;
        RelOptCluster cluster = context.getCluster();
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)cluster.getTypeFactory();
        RelDataType erasedRowType = this.eraseTimeIndicator(this.rowType, typeFactory, this.tableSource());
        TableSourceTable<T> tableSourceTable = new TableSourceTable<T>(this.relOptSchema, this.schemaTable().getTableIdentifier(), erasedRowType, this.statistic, this.tableSource(), this.schemaTable().isStreamingMode(), this.catalogTable());
        int[] physicalFields = (int[])((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(this.getRowType().getFieldList()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogSourceTable $outer;

            public final boolean apply(RelDataTypeField f) {
                return !this.$outer.columnExprs().contains((Object)f.getName());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(RelDataTypeField f) {
                return f.getIndex();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        TableSourceTable<T> newRelTable = tableSourceTable.copy(this.tableSource(), physicalFields);
        LogicalTableScan scan = LogicalTableScan.create(cluster, newRelTable);
        FlinkRelBuilder relBuilder = FlinkRelBuilder$.MODULE$.of(cluster, this.getRelOptSchema());
        relBuilder.push(scan);
        SqlExprToRexConverterFactory toRexFactory = cluster.getPlanner().getContext().unwrap(FlinkContext.class).getSqlExprToRexConverterFactory();
        Buffer fieldNames = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(erasedRowType.getFieldNames()).asScala();
        if (this.columnExprs().nonEmpty()) {
            String[] fieldExprs = (String[])((TraversableOnce)fieldNames.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CatalogSourceTable $outer;

                public final String apply(String name) {
                    return this.$outer.columnExprs().contains((Object)name) ? (String)this.$outer.columnExprs().apply((Object)name) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
            RexNode[] rexNodes = toRexFactory.create(newRelTable.getRowType()).convertToRexNodes(fieldExprs);
            object2 = relBuilder.projectNamed(JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.refArrayOps((Object[])rexNodes).toList()), JavaConversions$.MODULE$.bufferAsJavaList(fieldNames), true);
        } else {
            object2 = BoxedUnit.UNIT;
        }
        Option watermarkSpec = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.catalogTable().getSchema().getWatermarkSpecs()).asScala()).headOption();
        if (this.schemaTable().isStreamingMode() && watermarkSpec.nonEmpty()) {
            if (TableSourceValidation.hasRowtimeAttribute(this.tableSource())) {
                throw new TableException("If watermark is specified in DDL, the underlying TableSource of connector shouldn't return an non-empty list of RowtimeAttributeDescriptor via DefinedRowtimeAttributes interface.");
            }
            String rowtime2 = ((WatermarkSpec)watermarkSpec.get()).getRowtimeAttribute();
            if (rowtime2.contains(".")) {
                throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Nested field '", "' as rowtime attribute is not supported right now."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowtime2})));
            }
            int rowtimeIndex = fieldNames.indexOf((Object)rowtime2);
            RexNode watermarkRexNode = toRexFactory.create(erasedRowType).convertToRexNode(((WatermarkSpec)watermarkSpec.get()).getWatermarkExpr());
            object = relBuilder.watermark(rowtimeIndex, watermarkRexNode);
        } else {
            object = BoxedUnit.UNIT;
        }
        return relBuilder.build();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TableSource<?> findAndCreateTableSource() {
        void var2_5;
        TableSource tableSource;
        Optional<TableFactory> tableFactoryOpt = this.schemaTable().getTableFactory();
        if (tableFactoryOpt.isPresent()) {
            TableSource tableSource2;
            TableFactory tableFactory = tableFactoryOpt.get();
            if (!(tableFactory instanceof TableSourceFactory)) throw new TableException("Cannot query a sink-only table. TableFactory provided by catalog must implement TableSourceFactory");
            TableSourceFactory tableSourceFactory = (TableSourceFactory)tableFactory;
            tableSource = tableSource2 = tableSourceFactory.createTableSource(this.schemaTable().getTableIdentifier().toObjectPath(), this.catalogTable());
        } else {
            tableSource = TableFactoryUtil.findAndCreateTableSource((CatalogTable)this.catalogTable());
        }
        TableSource tableSource3 = tableSource;
        String tableName = this.schemaTable().getTableIdentifier().asSummaryString();
        TableSource tableSource4 = tableSource3;
        if (!(tableSource4 instanceof StreamTableSource)) throw new ValidationException("Catalog tables only support StreamTableSource and InputFormatTableSource");
        StreamTableSource streamTableSource = (StreamTableSource)tableSource4;
        if (!this.schemaTable().isStreamingMode() && !streamTableSource.isBounded()) void var6_6;
        throw new ValidationException(new StringBuilder().append((Object)"Cannot query on an unbounded source in batch mode, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but '", "' is unbounded."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_6}))).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return var2_5;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> explainSourceAsString(TableSource<?> ts) {
        void var2_2;
        ArrayList<String> ret = new ArrayList<String>(super.explainSourceAsString(ts));
        ret.add(new StringBuilder().append((Object)"class: ").append((Object)CatalogSourceTable.class.getSimpleName()).toString());
        return var2_2;
    }

    private RelDataType eraseTimeIndicator(RelDataType relDataType, FlinkTypeFactory factory, TableSource<?> tableSource) {
        RelDataType relDataType2;
        boolean hasLegacyTimeAttributes;
        boolean bl = hasLegacyTimeAttributes = TableSourceValidation.hasRowtimeAttribute(tableSource) || TableSourceValidation.hasProctimeAttribute(tableSource);
        if (this.columnExprs().isEmpty() && this.catalogTable().getSchema().getWatermarkSpecs().isEmpty() && hasLegacyTimeAttributes) {
            relDataType2 = relDataType;
        } else {
            RowType logicalRowType = FlinkTypeFactory$.MODULE$.toLogicalRowType(relDataType);
            List fieldNames = logicalRowType.getFieldNames();
            Buffer fieldTypes = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(logicalRowType.getFields()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final LogicalType apply(RowType.RowField f) {
                    LogicalType logicalType;
                    if (FlinkTypeFactory$.MODULE$.isTimeIndicatorType(f.getType())) {
                        TimestampType timeIndicatorType = (TimestampType)f.getType();
                        logicalType = new TimestampType(timeIndicatorType.isNullable(), TimestampKind.REGULAR, timeIndicatorType.getPrecision());
                    } else {
                        logicalType = f.getType();
                    }
                    return logicalType;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            relDataType2 = factory.buildRelNodeRowType((Seq<String>)JavaConversions$.MODULE$.asScalaBuffer(fieldNames), (Seq<LogicalType>)fieldTypes);
        }
        return relDataType2;
    }

    public CatalogSourceTable(RelOptSchema relOptSchema, List<String> names, RelDataType rowType, CatalogSchemaTable schemaTable, CatalogTable catalogTable) {
        this.relOptSchema = relOptSchema;
        this.rowType = rowType;
        this.schemaTable = schemaTable;
        this.catalogTable = catalogTable;
        super(relOptSchema, rowType, names, schemaTable.getStatistic());
    }
}

