/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;

public class RelOptUtils {
    public static RelNode createCastRel(RelNode rel, RelDataType castRowType) {
        RelNode input;
        List<RexNode> rhsExps;
        RelFactories.ProjectFactory projectFactory = RelFactories.DEFAULT_PROJECT_FACTORY;
        RelDataType oriRowType = rel.getRowType();
        if (RelOptUtil.areRowTypesEqual(oriRowType, castRowType, true)) {
            return rel;
        }
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        List<RelDataTypeField> fieldList = oriRowType.getFieldList();
        int n = fieldList.size();
        assert (n == castRowType.getFieldCount()) : "field count: lhs [" + castRowType + "] rhs [" + oriRowType + "]";
        if (rel instanceof Project) {
            rhsExps = ((Project)rel).getProjects();
            input = rel.getInput(0);
        } else {
            rhsExps = new ArrayList<RexNode>();
            for (RelDataTypeField field : fieldList) {
                rhsExps.add(rexBuilder.makeInputRef(field.getType(), field.getIndex()));
            }
            input = rel;
        }
        List<RexNode> castExps = RexUtil.generateCastExpressions(rexBuilder, castRowType, rhsExps);
        return projectFactory.createProject(input, castExps, castRowType.getFieldNames());
    }
}

