/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.mapping;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Permutation;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.apache.flink.calcite.shaded.com.google.common.primitives.Ints;

public abstract class Mappings {
    private Mappings() {
    }

    public static Mapping create(MappingType mappingType, int sourceCount, int targetCount) {
        switch (mappingType) {
            case BIJECTION: {
                assert (sourceCount == targetCount);
                return new Permutation(sourceCount);
            }
            case INVERSE_SURJECTION: {
                assert (sourceCount >= targetCount);
                return new SurjectionWithInverse(sourceCount, targetCount);
            }
            case PARTIAL_SURJECTION: 
            case SURJECTION: {
                return new PartialMapping(sourceCount, targetCount, mappingType);
            }
            case PARTIAL_FUNCTION: 
            case FUNCTION: {
                return new PartialFunctionImpl(sourceCount, targetCount, mappingType);
            }
            case INVERSE_FUNCTION: 
            case INVERSE_PARTIAL_FUNCTION: {
                return new InverseMapping(Mappings.create(mappingType.inverse(), targetCount, sourceCount));
            }
        }
        throw Util.needToImplement("no known implementation for mapping type " + (Object)((Object)mappingType));
    }

    public static IdentityMapping createIdentity(int fieldCount) {
        return new IdentityMapping(fieldCount);
    }

    public static Mapping invert(Mapping mapping) {
        if (mapping instanceof InverseMapping) {
            return ((InverseMapping)mapping).parent;
        }
        return new InverseMapping(mapping);
    }

    public static Mapping divide(Mapping mapping1, Mapping mapping2) {
        if (mapping1.getSourceCount() != mapping2.getSourceCount()) {
            throw new IllegalArgumentException();
        }
        Mapping remaining = Mappings.create(MappingType.INVERSE_SURJECTION, mapping2.getTargetCount(), mapping1.getTargetCount());
        for (int target = 0; target < mapping1.getTargetCount(); ++target) {
            int source = mapping1.getSourceOpt(target);
            if (source < 0) continue;
            int x = mapping2.getTarget(source);
            remaining.set(x, target);
        }
        return remaining;
    }

    public static Mapping multiply(Mapping mapping1, Mapping mapping2) {
        if (mapping1.getTargetCount() != mapping2.getSourceCount()) {
            throw new IllegalArgumentException();
        }
        Mapping product2 = Mappings.create(MappingType.INVERSE_SURJECTION, mapping1.getSourceCount(), mapping2.getTargetCount());
        for (int source = 0; source < mapping1.getSourceCount(); ++source) {
            int x = mapping1.getTargetOpt(source);
            if (x < 0) continue;
            int target = mapping2.getTarget(x);
            product2.set(source, target);
        }
        return product2;
    }

    public static BitSet apply(Mapping mapping, BitSet bitSet) {
        BitSet newBitSet = new BitSet();
        for (int source : BitSets.toIter(bitSet)) {
            int target = mapping.getTarget(source);
            newBitSet.set(target);
        }
        if (newBitSet.equals(bitSet)) {
            return bitSet;
        }
        return newBitSet;
    }

    public static ImmutableBitSet apply(Mapping mapping, ImmutableBitSet bitSet) {
        ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
        for (int source : bitSet) {
            int target = mapping.getTarget(source);
            builder.set(target);
        }
        return builder.build(bitSet);
    }

    public static ImmutableList<ImmutableBitSet> apply2(Mapping mapping, Iterable<ImmutableBitSet> bitSets) {
        return ImmutableList.copyOf(ImmutableBitSet.ORDERING.sortedCopy(Iterables.transform(bitSets, input1 -> Mappings.apply(mapping, input1))));
    }

    public static <T> List<T> apply(Mapping mapping, List<T> list) {
        if (mapping.getSourceCount() != list.size()) {
            throw new IllegalArgumentException("mapping source count " + mapping.getSourceCount() + " does not match list size " + list.size());
        }
        int targetCount = mapping.getTargetCount();
        ArrayList<T> list2 = new ArrayList<T>(targetCount);
        for (int target = 0; target < targetCount; ++target) {
            int source = mapping.getSource(target);
            list2.add(list.get(source));
        }
        return list2;
    }

    public static List<Integer> apply2(final Mapping mapping, final List<Integer> list) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                int source = (Integer)list.get(index);
                return mapping.getTarget(source);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static <T> List<T> apply3(final Mapping mapping, final List<T> list) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return list.get(mapping.getSource(index));
            }

            @Override
            public int size() {
                return mapping.getTargetCount();
            }
        };
    }

    public static <T> List<T> permute(final List<T> list, final TargetMapping mapping) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return list.get(mapping.getTarget(index));
            }

            @Override
            public int size() {
                return mapping.getSourceCount();
            }
        };
    }

    public static List<Integer> asList(final TargetMapping mapping) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int source) {
                int target = mapping.getTargetOpt(source);
                return target < 0 ? null : Integer.valueOf(target);
            }

            @Override
            public int size() {
                return mapping.getSourceCount();
            }
        };
    }

    public static TargetMapping target(Map<Integer, Integer> map, int sourceCount, int targetCount) {
        PartialFunctionImpl mapping = new PartialFunctionImpl(sourceCount, targetCount, MappingType.FUNCTION);
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            mapping.set(entry.getKey(), entry.getValue());
        }
        return mapping;
    }

    public static TargetMapping target(IntFunction<Integer> function, int sourceCount, int targetCount) {
        PartialFunctionImpl mapping = new PartialFunctionImpl(sourceCount, targetCount, MappingType.FUNCTION);
        for (int source = 0; source < sourceCount; ++source) {
            Integer target = function.apply(source);
            if (target == null) continue;
            mapping.set(source, target);
        }
        return mapping;
    }

    public static Mapping target(Iterable<IntPair> pairs, int sourceCount, int targetCount) {
        PartialFunctionImpl mapping = new PartialFunctionImpl(sourceCount, targetCount, MappingType.FUNCTION);
        for (IntPair pair : pairs) {
            mapping.set(pair.source, pair.target);
        }
        return mapping;
    }

    public static Mapping source(List<Integer> targets, int targetCount) {
        int sourceCount = targets.size();
        PartialFunctionImpl mapping = new PartialFunctionImpl(sourceCount, targetCount, MappingType.FUNCTION);
        for (int source = 0; source < sourceCount; ++source) {
            int target = targets.get(source);
            mapping.set(source, target);
        }
        return mapping;
    }

    public static Mapping target(List<Integer> sources, int sourceCount) {
        int targetCount = sources.size();
        PartialFunctionImpl mapping = new PartialFunctionImpl(sourceCount, targetCount, MappingType.FUNCTION);
        for (int target = 0; target < targetCount; ++target) {
            int source = sources.get(target);
            mapping.set(source, target);
        }
        return mapping;
    }

    public static Mapping bijection(List<Integer> targets) {
        return new Permutation(Ints.toArray(targets));
    }

    public static Mapping bijection(Map<Integer, Integer> targets) {
        ArrayList<Integer> targetList = new ArrayList<Integer>();
        for (int i = 0; i < targets.size(); ++i) {
            targetList.add(targets.get(i));
        }
        return new Permutation(Ints.toArray(targetList));
    }

    public static boolean isIdentity(TargetMapping mapping) {
        if (mapping.getSourceCount() != mapping.getTargetCount()) {
            return false;
        }
        for (int i = 0; i < mapping.getSourceCount(); ++i) {
            if (mapping.getTargetOpt(i) == i) continue;
            return false;
        }
        return true;
    }

    public static boolean keepsOrdering(TargetMapping mapping) {
        int prevTarget = -1;
        for (int i = 0; i < mapping.getSourceCount(); ++i) {
            int target = mapping.getTargetOpt(i);
            if (target == -1) continue;
            if (target < prevTarget) {
                return false;
            }
            prevTarget = target;
        }
        return true;
    }

    public static TargetMapping createShiftMapping(int sourceCount, int ... ints) {
        int targetCount = 0;
        assert (ints.length % 3 == 0);
        for (int i = 0; i < ints.length; i += 3) {
            int target = ints[i];
            int length = ints[i + 2];
            int top = target + length;
            targetCount = Math.max(targetCount, top);
        }
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, sourceCount, targetCount);
        for (int i = 0; i < ints.length; i += 3) {
            int target = ints[i];
            int source = ints[i + 1];
            int length = ints[i + 2];
            assert (source + length <= sourceCount);
            for (int j2 = 0; j2 < length; ++j2) {
                assert (mapping.getTargetOpt(source + j2) == -1);
                mapping.set(source + j2, target + j2);
            }
        }
        return mapping;
    }

    public static TargetMapping append(TargetMapping mapping0, TargetMapping mapping1) {
        int t;
        int s;
        int s0 = mapping0.getSourceCount();
        int s1 = mapping1.getSourceCount();
        int t0 = mapping0.getTargetCount();
        int t1 = mapping1.getTargetCount();
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, s0 + s1, t0 + t1);
        for (s = 0; s < s0; ++s) {
            t = mapping0.getTargetOpt(s);
            if (t < 0) continue;
            mapping.set(s, t);
        }
        for (s = 0; s < s1; ++s) {
            t = mapping1.getTargetOpt(s);
            if (t < 0) continue;
            mapping.set(s0 + s, t0 + t);
        }
        return mapping;
    }

    public static TargetMapping merge(TargetMapping mapping0, TargetMapping mapping1) {
        int t;
        int s;
        int s0 = mapping0.getSourceCount();
        int s1 = mapping1.getSourceCount();
        int sMin = Math.min(s0, s1);
        int sMax = Math.max(s0, s1);
        int t0 = mapping0.getTargetCount();
        int t1 = mapping1.getTargetCount();
        int tMax = Math.max(t0, t1);
        Mapping mapping = Mappings.create(MappingType.INVERSE_SURJECTION, sMax, tMax);
        for (s = 0; s < sMin; ++s) {
            t = mapping0.getTargetOpt(s);
            if (t >= 0) {
                mapping.set(s, t);
                assert (mapping1.getTargetOpt(s) < 0);
                continue;
            }
            t = mapping1.getTargetOpt(s);
            if (t < 0) continue;
            mapping.set(s, t);
        }
        for (s = sMin; s < sMax; ++s) {
            int n = t = s < s0 ? mapping0.getTargetOpt(s) : -1;
            if (t >= 0) {
                mapping.set(s, t);
                assert (s >= s1 || mapping1.getTargetOpt(s) < 0);
                continue;
            }
            int n2 = t = s < s1 ? mapping1.getTargetOpt(s) : -1;
            if (t < 0) continue;
            mapping.set(s, t);
        }
        return mapping;
    }

    public static TargetMapping offsetSource(TargetMapping mapping, int offset) {
        return Mappings.offsetSource(mapping, offset, mapping.getSourceCount() + offset);
    }

    public static TargetMapping offsetSource(TargetMapping mapping, int offset, int sourceCount) {
        if (sourceCount < mapping.getSourceCount() + offset) {
            throw new IllegalArgumentException("new source count too low");
        }
        return Mappings.target((int source) -> {
            int source2 = source - offset;
            return source2 < 0 || source2 >= mapping.getSourceCount() ? null : Integer.valueOf(mapping.getTargetOpt(source2));
        }, sourceCount, mapping.getTargetCount());
    }

    public static TargetMapping offsetTarget(TargetMapping mapping, int offset) {
        return Mappings.offsetTarget(mapping, offset, mapping.getTargetCount() + offset);
    }

    public static TargetMapping offsetTarget(TargetMapping mapping, int offset, int targetCount) {
        if (targetCount < mapping.getTargetCount() + offset) {
            throw new IllegalArgumentException("new target count too low");
        }
        return Mappings.target((int source) -> {
            int target = mapping.getTargetOpt(source);
            return target < 0 ? null : Integer.valueOf(target + offset);
        }, mapping.getSourceCount(), targetCount);
    }

    public static TargetMapping offset(TargetMapping mapping, int offset, int sourceCount) {
        if (sourceCount < mapping.getSourceCount() + offset) {
            throw new IllegalArgumentException("new source count too low");
        }
        return Mappings.target((int source) -> {
            int source2 = source - offset;
            if (source2 < 0 || source2 >= mapping.getSourceCount()) {
                return null;
            }
            int target = mapping.getTargetOpt(source2);
            if (target < 0) {
                return null;
            }
            return target + offset;
        }, sourceCount, mapping.getTargetCount() + offset);
    }

    public static boolean isIdentity(List<Integer> list, int count) {
        if (list.size() != count) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            Integer o = list.get(i);
            if (o != null && o == i) continue;
            return false;
        }
        return true;
    }

    public static Iterable<IntPair> invert(Iterable<IntPair> pairs) {
        return () -> Mappings.invert(pairs.iterator());
    }

    public static Iterator<IntPair> invert(final Iterator<IntPair> pairs) {
        return new Iterator<IntPair>(){

            @Override
            public boolean hasNext() {
                return pairs.hasNext();
            }

            @Override
            public IntPair next() {
                IntPair pair = (IntPair)pairs.next();
                return IntPair.of(pair.target, pair.source);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public static int apply(TargetMapping mapping, int i) {
        return i < 0 ? i : mapping.getTarget(i);
    }

    private static class InverseMapping
    implements Mapping {
        private final Mapping parent;

        InverseMapping(Mapping parent) {
            this.parent = parent;
        }

        @Override
        public Iterator<IntPair> iterator() {
            final Iterator<IntPair> parentIter = this.parent.iterator();
            return new Iterator<IntPair>(){

                @Override
                public boolean hasNext() {
                    return parentIter.hasNext();
                }

                @Override
                public IntPair next() {
                    IntPair parentPair = (IntPair)parentIter.next();
                    return new IntPair(parentPair.target, parentPair.source);
                }

                @Override
                public void remove() {
                    parentIter.remove();
                }
            };
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public int getSourceCount() {
            return this.parent.getTargetCount();
        }

        @Override
        public int getTargetCount() {
            return this.parent.getSourceCount();
        }

        @Override
        public MappingType getMappingType() {
            return this.parent.getMappingType().inverse();
        }

        @Override
        public boolean isIdentity() {
            return this.parent.isIdentity();
        }

        @Override
        public int getTargetOpt(int source) {
            return this.parent.getSourceOpt(source);
        }

        @Override
        public int getTarget(int source) {
            return this.parent.getSource(source);
        }

        @Override
        public int getSource(int target) {
            return this.parent.getTarget(target);
        }

        @Override
        public int getSourceOpt(int target) {
            return this.parent.getTargetOpt(target);
        }

        @Override
        public Mapping inverse() {
            return this.parent;
        }

        @Override
        public void set(int source, int target) {
            this.parent.set(target, source);
        }
    }

    private static class PartialFunctionImpl
    extends AbstractMapping
    implements TargetMapping {
        private final int sourceCount;
        private final int targetCount;
        private final MappingType mappingType;
        private final int[] targets;

        PartialFunctionImpl(int sourceCount, int targetCount, MappingType mappingType) {
            if (sourceCount < 0) {
                throw new IllegalArgumentException("Sources must be finite");
            }
            this.sourceCount = sourceCount;
            this.targetCount = targetCount;
            this.mappingType = mappingType;
            if (!mappingType.isSingleTarget()) {
                throw new IllegalArgumentException("Must have at most one target");
            }
            this.targets = new int[sourceCount];
            Arrays.fill(this.targets, -1);
        }

        @Override
        public int getSourceCount() {
            return this.sourceCount;
        }

        @Override
        public int getTargetCount() {
            return this.targetCount;
        }

        @Override
        public void clear() {
            Arrays.fill(this.targets, -1);
        }

        @Override
        public int size() {
            int size = 0;
            for (int target : this.targets) {
                if (target < 0) continue;
                ++size;
            }
            return size;
        }

        @Override
        public Iterator<IntPair> iterator() {
            return new Iterator<IntPair>(){
                int i = -1;
                {
                    this.advance();
                }

                private void advance() {
                    do {
                        ++this.i;
                    } while (this.i < sourceCount && targets[this.i] < 0);
                }

                @Override
                public boolean hasNext() {
                    return this.i < sourceCount;
                }

                @Override
                public IntPair next() {
                    IntPair pair = new IntPair(this.i, targets[this.i]);
                    this.advance();
                    return pair;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public MappingType getMappingType() {
            return this.mappingType;
        }

        @Override
        public Mapping inverse() {
            return Mappings.target(Mappings.invert(this), this.targetCount, this.sourceCount);
        }

        @Override
        public void set(int source, int target) {
            if (target < 0 && this.mappingType.isMandatorySource()) {
                throw new IllegalArgumentException("Target is required");
            }
            if (target >= this.targetCount && this.targetCount >= 0) {
                throw new IllegalArgumentException("Target must be less than target count, " + this.targetCount);
            }
            this.targets[source] = target;
        }

        public void setAll(Mapping mapping) {
            for (IntPair pair : mapping) {
                this.set(pair.source, pair.target);
            }
        }

        @Override
        public int getTargetOpt(int source) {
            return this.targets[source];
        }
    }

    public static class OverridingTargetMapping
    extends AbstractMapping
    implements TargetMapping {
        private final TargetMapping parent;
        private final int target;
        private final int source;

        public OverridingTargetMapping(TargetMapping parent, int target, int source) {
            this.parent = parent;
            this.target = target;
            this.source = source;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Mapping is read-only");
        }

        @Override
        public int size() {
            return this.parent.getTargetOpt(this.source) >= 0 ? this.parent.size() : this.parent.size() + 1;
        }

        @Override
        public void set(int source, int target) {
            this.parent.set(source, target);
        }

        @Override
        public Mapping inverse() {
            return new OverridingSourceMapping(this.parent.inverse(), this.source, this.target);
        }

        @Override
        public MappingType getMappingType() {
            return this.parent.getMappingType();
        }

        @Override
        public boolean isIdentity() {
            return this.source == this.target && ((Mapping)this.parent).isIdentity();
        }

        @Override
        public int getTarget(int source) {
            if (source == this.source) {
                return this.target;
            }
            return this.parent.getTarget(source);
        }

        @Override
        public Iterator<IntPair> iterator() {
            throw Util.needToImplement(this);
        }
    }

    public static class OverridingSourceMapping
    extends AbstractMapping
    implements SourceMapping {
        private final SourceMapping parent;
        private final int source;
        private final int target;

        public OverridingSourceMapping(SourceMapping parent, int source, int target) {
            this.parent = parent;
            this.source = source;
            this.target = target;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Mapping is read-only");
        }

        @Override
        public int size() {
            return this.parent.getSourceOpt(this.target) >= 0 ? this.parent.size() : this.parent.size() + 1;
        }

        @Override
        public Mapping inverse() {
            return new OverridingTargetMapping(this.parent.inverse(), this.target, this.source);
        }

        @Override
        public MappingType getMappingType() {
            return this.parent.getMappingType();
        }

        @Override
        public int getSource(int target) {
            if (target == this.target) {
                return this.source;
            }
            return this.parent.getSource(target);
        }

        @Override
        public boolean isIdentity() {
            return this.source == this.target && this.parent.isIdentity();
        }

        @Override
        public Iterator<IntPair> iterator() {
            throw Util.needToImplement(this);
        }
    }

    public static class IdentityMapping
    extends AbstractMapping
    implements FunctionMapping,
    TargetMapping,
    SourceMapping {
        private final int size;

        public IdentityMapping(int size) {
            this.size = size;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Mapping is read-only");
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Mapping inverse() {
            return this;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public void set(int source, int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MappingType getMappingType() {
            return MappingType.BIJECTION;
        }

        @Override
        public int getSourceCount() {
            return this.size;
        }

        @Override
        public int getTargetCount() {
            return this.size;
        }

        @Override
        public int getTarget(int source) {
            return source;
        }

        @Override
        public int getTargetOpt(int source) {
            return source;
        }

        @Override
        public int getSource(int target) {
            return target;
        }

        @Override
        public int getSourceOpt(int target) {
            return target;
        }

        @Override
        public Iterator<IntPair> iterator() {
            return new Iterator<IntPair>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return size < 0 || this.i < size;
                }

                @Override
                public IntPair next() {
                    int x = this.i++;
                    return new IntPair(x, x);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static class SurjectionWithInverse
    extends PartialMapping {
        SurjectionWithInverse(int sourceCount, int targetCount) {
            super(sourceCount, targetCount, MappingType.INVERSE_SURJECTION);
        }

        @Override
        public void set(int source, int target) {
            assert (this.isValid());
            int prevTarget = this.targets[source];
            if (prevTarget != -1) {
                throw new IllegalArgumentException("source #" + source + " is already mapped to target #" + target);
            }
            this.targets[source] = target;
            this.sources[target] = source;
        }

        @Override
        public int getSource(int target) {
            return this.sources[target];
        }
    }

    public static class PartialMapping
    extends FiniteAbstractMapping
    implements Mapping,
    FunctionMapping,
    TargetMapping {
        protected final int[] sources;
        protected final int[] targets;
        private final MappingType mappingType;

        public PartialMapping(int sourceCount, int targetCount, MappingType mappingType) {
            this.mappingType = mappingType;
            assert (mappingType.isSingleSource()) : mappingType;
            assert (mappingType.isSingleTarget()) : mappingType;
            this.sources = new int[targetCount];
            this.targets = new int[sourceCount];
            Arrays.fill(this.sources, -1);
            Arrays.fill(this.targets, -1);
        }

        public PartialMapping(List<Integer> sourceList, int sourceCount, MappingType mappingType) {
            this.mappingType = mappingType;
            assert (mappingType.isSingleSource());
            assert (mappingType.isSingleTarget());
            int targetCount = sourceList.size();
            this.targets = new int[sourceCount];
            this.sources = new int[targetCount];
            Arrays.fill(this.sources, -1);
            for (int i = 0; i < sourceList.size(); ++i) {
                int source;
                this.sources[i] = source = sourceList.get(i).intValue();
                if (source >= 0) {
                    this.targets[source] = i;
                    continue;
                }
                assert (!this.mappingType.isMandatorySource());
            }
        }

        private PartialMapping(int[] sources, int[] targets, MappingType mappingType) {
            this.sources = sources;
            this.targets = targets;
            this.mappingType = mappingType;
        }

        @Override
        public MappingType getMappingType() {
            return this.mappingType;
        }

        @Override
        public int getSourceCount() {
            return this.targets.length;
        }

        @Override
        public int getTargetCount() {
            return this.sources.length;
        }

        @Override
        public void clear() {
            Arrays.fill(this.sources, -1);
            Arrays.fill(this.targets, -1);
        }

        @Override
        public int size() {
            int[] a;
            int size = 0;
            for (int i1 : a = this.sources.length < this.targets.length ? this.sources : this.targets) {
                if (i1 < 0) continue;
                ++size;
            }
            return size;
        }

        @Override
        public Mapping inverse() {
            return new PartialMapping((int[])this.targets.clone(), (int[])this.sources.clone(), this.mappingType.inverse());
        }

        @Override
        public Iterator<IntPair> iterator() {
            return new MappingItr();
        }

        protected boolean isValid() {
            PartialMapping.assertPartialValid(this.sources, this.targets);
            PartialMapping.assertPartialValid(this.targets, this.sources);
            return true;
        }

        private static void assertPartialValid(int[] sources, int[] targets) {
            for (int i = 0; i < sources.length; ++i) {
                int source = sources[i];
                assert (source >= -1);
                assert (source < targets.length);
                assert (source == -1 || targets[source] == i);
            }
        }

        @Override
        public void set(int source, int target) {
            assert (this.isValid());
            int prevTarget = this.targets[source];
            this.targets[source] = target;
            int prevSource = this.sources[target];
            this.sources[target] = source;
            if (prevTarget != -1) {
                this.sources[prevTarget] = prevSource;
            }
            if (prevSource != -1) {
                this.targets[prevSource] = prevTarget;
            }
            assert (this.isValid());
        }

        @Override
        public int getSourceOpt(int target) {
            return this.sources[target];
        }

        @Override
        public int getTargetOpt(int source) {
            return this.targets[source];
        }

        @Override
        public boolean isIdentity() {
            if (this.sources.length != this.targets.length) {
                return false;
            }
            for (int i = 0; i < this.sources.length; ++i) {
                int source = this.sources[i];
                if (source == i) continue;
                return false;
            }
            return true;
        }

        private class MappingItr
        implements Iterator<IntPair> {
            int i = -1;

            MappingItr() {
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.i < PartialMapping.this.targets.length;
            }

            private void advance() {
                do {
                    ++this.i;
                } while (this.i < PartialMapping.this.targets.length && PartialMapping.this.targets[this.i] == -1);
            }

            @Override
            public IntPair next() {
                IntPair pair = new IntPair(this.i, PartialMapping.this.targets[this.i]);
                this.advance();
                return pair;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class NoElementException
    extends RuntimeException {
        public NoElementException(String message) {
            super(message);
        }
    }

    public static class TooManyElementsException
    extends RuntimeException {
    }

    static class FunctionMappingIter
    implements Iterator<IntPair> {
        private int i = 0;
        private final FunctionMapping mapping;

        FunctionMappingIter(FunctionMapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.mapping.getSourceCount() || this.mapping.getSourceCount() == -1;
        }

        @Override
        public IntPair next() {
            int x = this.i++;
            return new IntPair(x, this.mapping.getTarget(x));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class FiniteAbstractMapping
    extends AbstractMapping {
        @Override
        public Iterator<IntPair> iterator() {
            return new FunctionMappingIter(this);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Mapping && this.toString().equals(obj.toString());
        }
    }

    public static abstract class AbstractMapping
    implements Mapping {
        @Override
        public void set(int source, int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getTargetOpt(int source) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getTarget(int source) {
            int target = this.getTargetOpt(source);
            if (target == -1) {
                throw new NoElementException("source #" + source + " has no target in mapping " + this.toString());
            }
            return target;
        }

        @Override
        public int getSourceOpt(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSource(int target) {
            int source = this.getSourceOpt(target);
            if (source == -1) {
                throw new NoElementException("target #" + target + " has no source in mapping " + this.toString());
            }
            return source;
        }

        @Override
        public int getSourceCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getTargetCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isIdentity() {
            int targetCount;
            int sourceCount = this.getSourceCount();
            if (sourceCount != (targetCount = this.getTargetCount())) {
                return false;
            }
            for (int i = 0; i < sourceCount; ++i) {
                if (this.getSource(i) == i) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("[size=").append(this.size()).append(", sourceCount=").append(this.getSourceCount()).append(", targetCount=").append(this.getTargetCount()).append(", elements=[");
            int i = 0;
            for (IntPair pair : this) {
                if (i++ > 0) {
                    buf.append(", ");
                }
                buf.append(pair.source).append(':').append(pair.target);
            }
            buf.append("]]");
            return buf.toString();
        }
    }

    public static interface TargetMapping
    extends FunctionMapping {
        @Override
        public int getSourceCount();

        public int getSourceOpt(int var1);

        public int getTargetCount();

        @Override
        public int getTarget(int var1);

        @Override
        public int getTargetOpt(int var1);

        public void set(int var1, int var2);

        public Mapping inverse();
    }

    public static interface SourceMapping
    extends CoreMapping {
        public int getSourceCount();

        public int getSource(int var1);

        public int getSourceOpt(int var1);

        public int getTargetCount();

        public int getTargetOpt(int var1);

        @Override
        public MappingType getMappingType();

        public boolean isIdentity();

        public Mapping inverse();
    }

    public static interface FunctionMapping
    extends CoreMapping {
        public int getTargetOpt(int var1);

        public int getTarget(int var1);

        @Override
        public MappingType getMappingType();

        public int getSourceCount();
    }

    public static interface CoreMapping
    extends Iterable<IntPair> {
        public MappingType getMappingType();

        public int size();
    }
}

