/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.data.JoinedRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext$;
import org.apache.flink.table.planner.codegen.OperatorCodeGenerator$;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator$;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.GeneratedOperator;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.hashtable.LongHashPartition;
import org.apache.flink.table.runtime.hashtable.LongHybridHashTable;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class LongHashJoinGenerator$ {
    public static final LongHashJoinGenerator$ MODULE$;

    static {
        new LongHashJoinGenerator$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean support(HashJoinType joinType, RowType keyType, boolean[] filterNulls2) {
        boolean bl;
        HashJoinType hashJoinType = joinType;
        HashJoinType hashJoinType2 = HashJoinType.INNER;
        if (hashJoinType == null ? hashJoinType2 != null : !hashJoinType.equals(hashJoinType2)) {
            HashJoinType hashJoinType3 = joinType;
            HashJoinType hashJoinType4 = HashJoinType.SEMI;
            if (hashJoinType3 == null ? hashJoinType4 != null : !hashJoinType3.equals(hashJoinType4)) {
                HashJoinType hashJoinType5 = joinType;
                HashJoinType hashJoinType6 = HashJoinType.ANTI;
                if (hashJoinType5 == null ? hashJoinType6 != null : !hashJoinType5.equals(hashJoinType6)) {
                    HashJoinType hashJoinType7 = joinType;
                    HashJoinType hashJoinType8 = HashJoinType.PROBE_OUTER;
                    if (hashJoinType7 == null) {
                        if (hashJoinType8 != null) {
                            return false;
                        }
                    } else if (!hashJoinType7.equals(hashJoinType8)) return false;
                }
            }
        }
        if (!Predef$.MODULE$.booleanArrayOps(filterNulls2).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean b) {
                return b;
            }
        })) return false;
        if (keyType.getFieldCount() != 1) return false;
        LogicalTypeRoot logicalTypeRoot = keyType.getTypeAt(0).getTypeRoot();
        if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            return true;
        }
        if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            return true;
        }
        if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            return true;
        }
        if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            return true;
        }
        if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            return true;
        }
        if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            return true;
        }
        if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            return true;
        }
        if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) {
            return true;
        }
        if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            TimestampType timestampType = (TimestampType)keyType.getTypeAt(0);
            bl = TimestampData.isCompact((int)timestampType.getPrecision());
        } else {
            if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) return false;
            LocalZonedTimestampType lzTs = (LocalZonedTimestampType)keyType.getTypeAt(0);
            bl = TimestampData.isCompact((int)lzTs.getPrecision());
        }
        if (!bl) return false;
        return true;
    }

    private String genGetLongKey(CodeGeneratorContext ctx, RowType keyType, int[] keyMapping, String rowTerm) {
        LogicalType singleType = keyType.getTypeAt(0);
        String getCode = CodeGenUtils$.MODULE$.rowFieldReadAccess(ctx, keyMapping[0], rowTerm, singleType);
        LogicalTypeRoot logicalTypeRoot = singleType.getTypeRoot();
        String string = LogicalTypeRoot.FLOAT.equals(logicalTypeRoot) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Float.floatToIntBits(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{getCode})) : (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Double.doubleToLongBits(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{getCode})) : (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{getCode})) : (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMillisecond()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{getCode})) : getCode)));
        String term2 = string;
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"return ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2}));
    }

    public Tuple2<String, String> genAnyNullsInKeys(int[] keyMapping, String rowTerm) {
        StringBuilder builder = new StringBuilder();
        String anyNullTerm = CodeGenUtils$.MODULE$.newName("anyNull");
        Predef$.MODULE$.intArrayOps(keyMapping).foreach((Function1)new Serializable(rowTerm, builder, anyNullTerm){
            public static final long serialVersionUID = 0L;
            private final String rowTerm$1;
            private final StringBuilder builder$1;
            private final String anyNullTerm$1;

            public final StringBuilder apply(int key) {
                return this.builder$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " |= ", ".isNullAt(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.anyNullTerm$1, this.rowTerm$1, BoxesRunTime.boxToInteger((int)key)})));
            }
            {
                this.rowTerm$1 = rowTerm$1;
                this.builder$1 = builder$1;
                this.anyNullTerm$1 = anyNullTerm$1;
            }
        });
        return new Tuple2((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |boolean ", " = false;\n       |", "\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{anyNullTerm, builder})))).stripMargin(), (Object)anyNullTerm);
    }

    public GeneratedProjection genProjection(TableConfig conf, LogicalType[] types) {
        RowType rowType = RowType.of((LogicalType[])types);
        return ProjectionCodeGenerator$.MODULE$.generateProjection(CodeGeneratorContext$.MODULE$.apply(conf), "Projection", rowType, rowType, (int[])Predef$.MODULE$.refArrayOps((Object[])types).indices().toArray(ClassTag$.MODULE$.Int()));
    }

    public CodeGenOperatorFactory<RowData> gen(TableConfig conf, HashJoinType hashJoinType, RowType keyType, RowType buildType, RowType probeType, int[] buildKeyMapping, int[] probeKeyMapping, int buildRowSize, long buildRowCount, boolean reverseJoinFunction, GeneratedJoinCondition condFunc) {
        Tuple2<String, String> tuple2;
        block2: {
            Tuple2<String, String> tuple22;
            block3: {
                HashJoinType hashJoinType2;
                block8: {
                    String string;
                    String nullCheckProbeTerm;
                    String nullCheckProbeCode;
                    String nullCheckBuildTerm;
                    String nullCheckBuildCode;
                    CodeGeneratorContext ctx;
                    block5: {
                        String applyCond;
                        block7: {
                            block6: {
                                block4: {
                                    Tuple2 tuple23;
                                    Tuple2 tuple24;
                                    BinaryRowDataSerializer buildSer = new BinaryRowDataSerializer(buildType.getFieldCount());
                                    BinaryRowDataSerializer probeSer = new BinaryRowDataSerializer(probeType.getFieldCount());
                                    String tableTerm = CodeGenUtils$.MODULE$.newName("LongHashTable");
                                    ctx = CodeGeneratorContext$.MODULE$.apply(conf);
                                    String buildSerTerm = ctx.addReusableObject(buildSer, "buildSer", ctx.addReusableObject$default$3());
                                    String probeSerTerm = ctx.addReusableObject(probeSer, "probeSer", ctx.addReusableObject$default$3());
                                    GeneratedProjection bGenProj = this.genProjection(conf, (LogicalType[])buildType.getChildren().toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(LogicalType.class))));
                                    ctx.addReusableInnerClass(bGenProj.getClassName(), bGenProj.getCode());
                                    GeneratedProjection pGenProj = this.genProjection(conf, (LogicalType[])probeType.getChildren().toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(LogicalType.class))));
                                    ctx.addReusableInnerClass(pGenProj.getClassName(), pGenProj.getCode());
                                    ctx.addReusableInnerClass(condFunc.getClassName(), condFunc.getCode());
                                    ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " buildToBinaryRow;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bGenProj.getClassName()})));
                                    String buildProjRefs = ctx.addReusableObject(bGenProj.getReferences(), "buildProjRefs", ctx.addReusableObject$default$3());
                                    ctx.addReusableInitStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"buildToBinaryRow = new ", "(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bGenProj.getClassName(), buildProjRefs})));
                                    ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " probeToBinaryRow;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pGenProj.getClassName()})));
                                    String probeProjRefs = ctx.addReusableObject(pGenProj.getReferences(), "probeProjRefs", ctx.addReusableObject$default$3());
                                    ctx.addReusableInitStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"probeToBinaryRow = new ", "(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pGenProj.getClassName(), probeProjRefs})));
                                    ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " condFunc;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{condFunc.getClassName()})));
                                    String condRefs = ctx.addReusableObject(condFunc.getReferences(), "condRefs", ctx.addReusableObject$default$3());
                                    ctx.addReusableInitStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"condFunc = new ", "(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{condFunc.getClassName(), condRefs})));
                                    ctx.addReusableOpenStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"condFunc.setRuntimeContext(getRuntimeContext());"})).s((Seq)Nil$.MODULE$));
                                    ctx.addReusableOpenStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"condFunc.open(new ", "());"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(Configuration.class))})));
                                    ctx.addReusableCloseStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"condFunc.close();"})).s((Seq)Nil$.MODULE$));
                                    String gauge = Gauge.class.getCanonicalName();
                                    ctx.addReusableOpenStatement(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |getMetricGroup().gauge(\"memoryUsedSizeInBytes\", new ", "<Long>() {\n         |  @Override\n         |  public Long getValue() {\n         |    return table.getUsedMemoryInBytes();\n         |  }\n         |});\n         |getMetricGroup().gauge(\"numSpillFiles\", new ", "<Long>() {\n         |  @Override\n         |  public Long getValue() {\n         |    return table.getNumSpillFiles();\n         |  }\n         |});\n         |getMetricGroup().gauge(\"spillInBytes\", new ", "<Long>() {\n         |  @Override\n         |  public Long getValue() {\n         |    return table.getSpillInBytes();\n         |  }\n         |});\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{gauge, gauge, gauge})))).stripMargin());
                                    String tableCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |public class ", " extends ", " {\n         |\n         |  public ", "() {\n         |    super(getContainingTask().getJobConfiguration(), getContainingTask(),\n         |      ", ", ", ",\n         |      getContainingTask().getEnvironment().getMemoryManager(),\n         |      computeMemorySize(),\n         |      getContainingTask().getEnvironment().getIOManager(),\n         |      ", ",\n         |      ", "L / getRuntimeContext().getNumberOfParallelSubtasks());\n         |  }\n         |\n         |  @Override\n         |  public long getBuildLongKey(", " row) {\n         |    ", "\n         |  }\n         |\n         |  @Override\n         |  public long getProbeLongKey(", " row) {\n         |    ", "\n         |  }\n         |\n         |  @Override\n         |  public ", " probeToBinary(", " row) {\n         |    if (row instanceof ", ") {\n         |      return (", ") row;\n         |    } else {\n         |      return probeToBinaryRow.apply(row);\n         |    }\n         |  }\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableTerm, LongHybridHashTable.class.getCanonicalName(), tableTerm, buildSerTerm, probeSerTerm, BoxesRunTime.boxToInteger((int)buildRowSize), BoxesRunTime.boxToLong((long)buildRowCount), CodeGenUtils$.MODULE$.ROW_DATA(), this.genGetLongKey(ctx, keyType, buildKeyMapping, "row"), CodeGenUtils$.MODULE$.ROW_DATA(), this.genGetLongKey(ctx, keyType, probeKeyMapping, "row"), CodeGenUtils$.MODULE$.BINARY_ROW(), CodeGenUtils$.MODULE$.ROW_DATA(), CodeGenUtils$.MODULE$.BINARY_ROW(), CodeGenUtils$.MODULE$.BINARY_ROW()})))).stripMargin();
                                    ctx.addReusableInnerClass(tableTerm, tableCode);
                                    ctx.addReusableNullRow("buildSideNullRow", buildSer.getArity());
                                    ctx.addReusableOutputRecord((LogicalType)RowType.of((LogicalType[])new LogicalType[0]), JoinedRowData.class, "joinedRow", ctx.addReusableOutputRecord$default$4());
                                    ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " table;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableTerm})));
                                    ctx.addReusableOpenStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table = new ", "();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableTerm})));
                                    tuple2 = this.genAnyNullsInKeys(buildKeyMapping, "row");
                                    if (tuple2 == null) break block2;
                                    String nullCheckBuildCode2 = (String)tuple2._1();
                                    String nullCheckBuildTerm2 = (String)tuple2._2();
                                    Tuple2 tuple25 = tuple24 = new Tuple2((Object)nullCheckBuildCode2, (Object)nullCheckBuildTerm2);
                                    nullCheckBuildCode = (String)tuple25._1();
                                    nullCheckBuildTerm = (String)tuple25._2();
                                    tuple22 = this.genAnyNullsInKeys(probeKeyMapping, "row");
                                    if (tuple22 == null) break block3;
                                    String nullCheckProbeCode2 = (String)tuple22._1();
                                    String nullCheckProbeTerm2 = (String)tuple22._2();
                                    Tuple2 tuple26 = tuple23 = new Tuple2((Object)nullCheckProbeCode2, (Object)nullCheckProbeTerm2);
                                    nullCheckProbeCode = (String)tuple26._1();
                                    nullCheckProbeTerm = (String)tuple26._2();
                                    applyCond = reverseJoinFunction ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"condFunc.apply(probeRow, buildIter.getRow())"})).s((Seq)Nil$.MODULE$) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"condFunc.apply(buildIter.getRow(), probeRow)"})).s((Seq)Nil$.MODULE$);
                                    hashJoinType2 = hashJoinType;
                                    if (!HashJoinType.INNER.equals(hashJoinType2)) break block4;
                                    string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |while (buildIter.advanceNext()) {\n           |  if (", ") {\n           |    ", "\n           |  }\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{applyCond, this.collectCode$1("buildIter.getRow()", "probeRow", reverseJoinFunction)})))).stripMargin();
                                    break block5;
                                }
                                if (!HashJoinType.SEMI.equals(hashJoinType2)) break block6;
                                string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |while (buildIter.advanceNext()) {\n           |  if (", ") {\n           |    ", "\n           |    break;\n           |  }\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{applyCond, OperatorCodeGenerator$.MODULE$.generateCollect("probeRow")})))).stripMargin();
                                break block5;
                            }
                            if (!HashJoinType.ANTI.equals(hashJoinType2)) break block7;
                            string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean matched = false;\n           |while (buildIter.advanceNext()) {\n           |  if (", ") {\n           |    matched = true;\n           |    break;\n           |  }\n           |}\n           |if (!matched) {\n           |  ", "\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{applyCond, OperatorCodeGenerator$.MODULE$.generateCollect("probeRow")})))).stripMargin();
                            break block5;
                        }
                        if (!HashJoinType.PROBE_OUTER.equals(hashJoinType2)) break block8;
                        string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean matched = false;\n           |while (buildIter.advanceNext()) {\n           |  if (", ") {\n           |    ", "\n           |    matched = true;\n           |  }\n           |}\n           |if (!matched) {\n           |  ", "\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{applyCond, this.collectCode$1("buildIter.getRow()", "probeRow", reverseJoinFunction), this.collectCode$1("buildSideNullRow", "probeRow", reverseJoinFunction)})))).stripMargin();
                    }
                    String joinCode = string;
                    HashJoinType hashJoinType3 = hashJoinType;
                    String string2 = HashJoinType.ANTI.equals(hashJoinType3) ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |else {\n           |  ", "\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{OperatorCodeGenerator$.MODULE$.generateCollect("row")})))).stripMargin() : (HashJoinType.PROBE_OUTER.equals(hashJoinType3) ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |else {\n           |  ", "\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.collectCode$1("buildSideNullRow", "row", reverseJoinFunction)})))).stripMargin() : "");
                    String nullOuterJoin = string2;
                    ctx.addReusableMember(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |private void joinWithNextKey() throws Exception {\n         |  ", " buildIter =\n         |      table.getBuildSideIterator();\n         |  ", " probeRow = table.getCurrentProbeRow();\n         |  if (probeRow == null) {\n         |    throw new RuntimeException(\"ProbeRow should not be null\");\n         |  }\n         |  ", "\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LongHashPartition.MatchIterator.class.getCanonicalName(), CodeGenUtils$.MODULE$.ROW_DATA(), joinCode})))).stripMargin());
                    ctx.addReusableCloseStatement(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |if (this.table != null) {\n         |  this.table.close();\n         |  this.table.free();\n         |  this.table = null;\n         |}\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
                    String buildEnd = CodeGenUtils$.MODULE$.newName("buildEnd");
                    ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"private transient boolean ", " = false;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buildEnd})));
                    CodeGeneratorContext x$3 = ctx;
                    String x$4 = "LongHashJoinOperator";
                    String x$5 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " row = (", ") element.getValue();\n         |", "\n         |if (!", ") {\n         |  table.putBuildRow(row instanceof ", " ?\n         |    (", ") row : buildToBinaryRow.apply(row));\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.ROW_DATA(), CodeGenUtils$.MODULE$.ROW_DATA(), nullCheckBuildCode, nullCheckBuildTerm, CodeGenUtils$.MODULE$.BINARY_ROW(), CodeGenUtils$.MODULE$.BINARY_ROW()})))).stripMargin();
                    String x$6 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " row = (", ") element.getValue();\n         |", "\n         |if (!", ") {\n         |  if (table.tryProbe(row)) {\n         |    joinWithNextKey();\n         |  }\n         |}\n         |", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenUtils$.MODULE$.ROW_DATA(), CodeGenUtils$.MODULE$.ROW_DATA(), nullCheckProbeCode, nullCheckProbeTerm, nullOuterJoin})))).stripMargin();
                    RowType x$7 = buildType;
                    RowType x$8 = probeType;
                    Some x$9 = new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |if (", ") {\n           |  return ", ".SECOND;\n           |} else {\n           |  return ", ".FIRST;\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buildEnd, OperatorCodeGenerator$.MODULE$.INPUT_SELECTION(), OperatorCodeGenerator$.MODULE$.INPUT_SELECTION()})))).stripMargin());
                    Some x$10 = new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |LOG.info(\"Finish build phase.\");\n           |table.endBuild();\n           |", " = true;\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buildEnd})))).stripMargin());
                    Some x$11 = new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |LOG.info(\"Finish probe phase.\");\n           |while (this.table.nextMatching()) {\n           |  joinWithNextKey();\n           |}\n           |LOG.info(\"Finish rebuild phase.\");\n         "})).s((Seq)Nil$.MODULE$))).stripMargin());
                    String x$12 = OperatorCodeGenerator$.MODULE$.generateTwoInputStreamOperator$default$7();
                    String x$13 = OperatorCodeGenerator$.MODULE$.generateTwoInputStreamOperator$default$8();
                    boolean x$14 = OperatorCodeGenerator$.MODULE$.generateTwoInputStreamOperator$default$12();
                    GeneratedOperator genOp = OperatorCodeGenerator$.MODULE$.generateTwoInputStreamOperator(x$3, x$4, x$5, x$6, (LogicalType)x$7, (LogicalType)x$8, x$12, x$13, (Option<String>)x$9, (Option<String>)x$10, (Option<String>)x$11, x$14);
                    return new CodeGenOperatorFactory(genOp);
                }
                throw new MatchError((Object)hashJoinType2);
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError(tuple2);
    }

    private final String collectCode$1(String term1, String term2, boolean reverseJoinFunction$1) {
        return reverseJoinFunction$1 ? OperatorCodeGenerator$.MODULE$.generateCollect(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinedRow.replace(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term2, term1}))) : OperatorCodeGenerator$.MODULE$.generateCollect(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"joinedRow.replace(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{term1, term2})));
    }

    private LongHashJoinGenerator$() {
        MODULE$ = this;
    }
}

