/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionDefaultVisitor;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.FunctionRequirement;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableAggregateFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedAggregateFunction;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.functions.utils.AggSqlFunction;
import org.apache.flink.table.types.utils.TypeConversions;
import scala.Option;

public class SqlAggFunctionVisitor
extends ExpressionDefaultVisitor<SqlAggFunction> {
    private static final Map<FunctionDefinition, SqlAggFunction> AGG_DEF_SQL_OPERATOR_MAPPING = new IdentityHashMap<FunctionDefinition, SqlAggFunction>();
    private final FlinkTypeFactory typeFactory;

    public SqlAggFunctionVisitor(FlinkTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public SqlAggFunction visit(CallExpression call) {
        FunctionDefinition def;
        if (!ApiExpressionUtils.isFunctionOfKind((Expression)call, (FunctionKind)FunctionKind.AGGREGATE) && !ApiExpressionUtils.isFunctionOfKind((Expression)call, (FunctionKind)FunctionKind.TABLE_AGGREGATE)) {
            this.defaultMethod((Expression)call);
        }
        if (AGG_DEF_SQL_OPERATOR_MAPPING.containsKey(def = call.getFunctionDefinition())) {
            return AGG_DEF_SQL_OPERATOR_MAPPING.get(def);
        }
        if (BuiltInFunctionDefinitions.DISTINCT == def) {
            Expression innerAgg = (Expression)call.getChildren().get(0);
            return (SqlAggFunction)innerAgg.accept((ExpressionVisitor)this);
        }
        if (ApiExpressionUtils.isFunctionOfKind((Expression)call, (FunctionKind)FunctionKind.AGGREGATE)) {
            AggregateFunctionDefinition aggDef = (AggregateFunctionDefinition)def;
            AggregateFunction aggFunc = aggDef.getAggregateFunction();
            FunctionIdentifier identifier = call.getFunctionIdentifier().orElse(FunctionIdentifier.of((String)aggFunc.functionIdentifier()));
            return new AggSqlFunction(identifier, aggFunc.toString(), (UserDefinedAggregateFunction<?, ?>)aggFunc, TypeConversions.fromLegacyInfoToDataType((TypeInformation)aggDef.getResultTypeInfo()), TypeConversions.fromLegacyInfoToDataType((TypeInformation)aggDef.getAccumulatorTypeInfo()), this.typeFactory, aggFunc.getRequirements().contains(FunctionRequirement.OVER_WINDOW_ONLY), (Option<SqlReturnTypeInference>)Option.empty());
        }
        TableAggregateFunctionDefinition aggDef = (TableAggregateFunctionDefinition)def;
        TableAggregateFunction aggFunc = aggDef.getTableAggregateFunction();
        FunctionIdentifier identifier = call.getFunctionIdentifier().orElse(FunctionIdentifier.of((String)aggFunc.functionIdentifier()));
        return new AggSqlFunction(identifier, aggFunc.toString(), (UserDefinedAggregateFunction<?, ?>)aggFunc, TypeConversions.fromLegacyInfoToDataType((TypeInformation)aggDef.getResultTypeInfo()), TypeConversions.fromLegacyInfoToDataType((TypeInformation)aggDef.getAccumulatorTypeInfo()), this.typeFactory, false, (Option<SqlReturnTypeInference>)Option.empty());
    }

    protected SqlAggFunction defaultMethod(Expression expression2) {
        throw new TableException("Unexpected expression: " + expression2);
    }

    static {
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.AVG, FlinkSqlOperatorTable.AVG);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.COUNT, FlinkSqlOperatorTable.COUNT);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.MAX, FlinkSqlOperatorTable.MAX);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.MIN, FlinkSqlOperatorTable.MIN);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.SUM, FlinkSqlOperatorTable.SUM);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.SUM0, FlinkSqlOperatorTable.SUM0);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.STDDEV_POP, FlinkSqlOperatorTable.STDDEV_POP);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.STDDEV_SAMP, FlinkSqlOperatorTable.STDDEV_SAMP);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.VAR_POP, FlinkSqlOperatorTable.VAR_POP);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.VAR_SAMP, FlinkSqlOperatorTable.VAR_SAMP);
        AGG_DEF_SQL_OPERATOR_MAPPING.put((FunctionDefinition)BuiltInFunctionDefinitions.COLLECT, FlinkSqlOperatorTable.COLLECT);
    }
}

