/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.TableReferenceExpression;
import org.apache.flink.table.expressions.TypeLiteralExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.functions.InternalFunctionDefinitions;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.functions.sql.SqlThrowExceptionFunction;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;

public class CustomizedConvertRule
implements CallExpressionConvertRule {
    private static final Map<FunctionDefinition, Conversion> DEFINITION_RULE_MAP = new HashMap<FunctionDefinition, Conversion>();

    @Override
    public Optional<RexNode> convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        Conversion conversion = DEFINITION_RULE_MAP.get(call.getFunctionDefinition());
        return Optional.ofNullable(conversion).map(c -> c.convert(call, context));
    }

    private static RexNode convertCast(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 2);
        RexNode child = context.toRexNode((Expression)call.getChildren().get(0));
        TypeLiteralExpression targetType = (TypeLiteralExpression)call.getChildren().get(1);
        RelDataType targetRelDataType = context.getTypeFactory().createFieldTypeFromLogicalType(targetType.getOutputDataType().getLogicalType());
        return context.getRelBuilder().getRexBuilder().makeAbstractCast(targetRelDataType, child);
    }

    private static RexNode convertOrderAsc(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 1);
        return context.toRexNode((Expression)call.getChildren().get(0));
    }

    private static RexNode convertTimestampDiff(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 3);
        List<RexNode> childrenRexNode = ExpressionConverter.toRexNodes(context, call.getChildren());
        return context.getRelBuilder().call((SqlOperator)FlinkSqlOperatorTable.TIMESTAMP_DIFF, childrenRexNode.get(0), childrenRexNode.get(2), childrenRexNode.get(1));
    }

    private static RexNode convertNotBetween(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 3);
        List<RexNode> childrenRexNode = ExpressionConverter.toRexNodes(context, call.getChildren());
        RexNode expr = childrenRexNode.get(0);
        RexNode lowerBound = childrenRexNode.get(1);
        RexNode upperBound = childrenRexNode.get(2);
        return context.getRelBuilder().or(context.getRelBuilder().call(FlinkSqlOperatorTable.LESS_THAN, expr, lowerBound), context.getRelBuilder().call(FlinkSqlOperatorTable.GREATER_THAN, expr, upperBound));
    }

    private static RexNode convertBetween(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 3);
        List<RexNode> childrenRexNode = ExpressionConverter.toRexNodes(context, call.getChildren());
        RexNode expr = childrenRexNode.get(0);
        RexNode lowerBound = childrenRexNode.get(1);
        RexNode upperBound = childrenRexNode.get(2);
        return context.getRelBuilder().and(context.getRelBuilder().call(FlinkSqlOperatorTable.GREATER_THAN_OR_EQUAL, expr, lowerBound), context.getRelBuilder().call(FlinkSqlOperatorTable.LESS_THAN_OR_EQUAL, expr, upperBound));
    }

    private static RexNode convertCeil(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 1, 2);
        List children = call.getChildren();
        List<RexNode> childrenRexNode = ExpressionConverter.toRexNodes(context, children);
        if (children.size() == 1) {
            return context.getRelBuilder().call((SqlOperator)FlinkSqlOperatorTable.CEIL, (Iterable<? extends RexNode>)childrenRexNode);
        }
        return context.getRelBuilder().call((SqlOperator)FlinkSqlOperatorTable.CEIL, childrenRexNode.get(1), childrenRexNode.get(0));
    }

    private static RexNode convertFloor(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 1, 2);
        List children = call.getChildren();
        List<RexNode> childrenRexNode = ExpressionConverter.toRexNodes(context, children);
        if (children.size() == 1) {
            return context.getRelBuilder().call((SqlOperator)FlinkSqlOperatorTable.FLOOR, (Iterable<? extends RexNode>)childrenRexNode);
        }
        return context.getRelBuilder().call((SqlOperator)FlinkSqlOperatorTable.FLOOR, childrenRexNode.get(1), childrenRexNode.get(0));
    }

    private static RexNode convertArray(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        List<RexNode> childrenRexNode = ExpressionConverter.toRexNodes(context, call.getChildren());
        RelDataType relDataType = context.getTypeFactory().createFieldTypeFromLogicalType(call.getOutputDataType().getLogicalType());
        return context.getRelBuilder().getRexBuilder().makeCall(relDataType, FlinkSqlOperatorTable.ARRAY_VALUE_CONSTRUCTOR, childrenRexNode);
    }

    private static RexNode convertMap(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        List children = call.getChildren();
        CustomizedConvertRule.checkArgument(call, !children.isEmpty() && children.size() % 2 == 0);
        List<RexNode> childrenRexNode = ExpressionConverter.toRexNodes(context, children);
        RelDataType mapType = context.getTypeFactory().createFieldTypeFromLogicalType(call.getOutputDataType().getLogicalType());
        return context.getRelBuilder().getRexBuilder().makeCall(mapType, FlinkSqlOperatorTable.MAP_VALUE_CONSTRUCTOR, childrenRexNode);
    }

    private static RexNode convertRow(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        List<RexNode> childrenRexNode = ExpressionConverter.toRexNodes(context, call.getChildren());
        RelDataType relDataType = context.getTypeFactory().createFieldTypeFromLogicalType(call.getOutputDataType().getLogicalType());
        return context.getRelBuilder().getRexBuilder().makeCall(relDataType, FlinkSqlOperatorTable.ROW, childrenRexNode);
    }

    private static RexNode convertTemporalOverlaps(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 4);
        List<RexNode> childrenRexNode = ExpressionConverter.toRexNodes(context, call.getChildren());
        RexNode leftTimePoint = childrenRexNode.get(0);
        RexNode leftTemporal = childrenRexNode.get(1);
        RexNode rightTimePoint = childrenRexNode.get(2);
        RexNode rightTemporal = childrenRexNode.get(3);
        RexNode convLeftT = TypeCheckUtils.isTimeInterval((LogicalType)FlinkTypeFactory.toLogicalType(leftTemporal.getType())) ? context.getRelBuilder().call(FlinkSqlOperatorTable.DATETIME_PLUS, leftTimePoint, leftTemporal) : leftTemporal;
        RexNode leftLe = context.getRelBuilder().call(FlinkSqlOperatorTable.LESS_THAN_OR_EQUAL, leftTimePoint, convLeftT);
        RexNode s0 = context.getRelBuilder().call(FlinkSqlOperatorTable.CASE, leftLe, leftTimePoint, convLeftT);
        RexNode e0 = context.getRelBuilder().call(FlinkSqlOperatorTable.CASE, leftLe, convLeftT, leftTimePoint);
        RexNode convRightT = TypeCheckUtils.isTimeInterval((LogicalType)FlinkTypeFactory.toLogicalType(rightTemporal.getType())) ? context.getRelBuilder().call(FlinkSqlOperatorTable.DATETIME_PLUS, rightTimePoint, rightTemporal) : rightTemporal;
        RexNode rightLe = context.getRelBuilder().call(FlinkSqlOperatorTable.LESS_THAN_OR_EQUAL, rightTimePoint, convRightT);
        RexNode s1 = context.getRelBuilder().call(FlinkSqlOperatorTable.CASE, rightLe, rightTimePoint, convRightT);
        RexNode e1 = context.getRelBuilder().call(FlinkSqlOperatorTable.CASE, rightLe, convRightT, rightTimePoint);
        RexNode leftPred = context.getRelBuilder().call(FlinkSqlOperatorTable.GREATER_THAN_OR_EQUAL, e0, s1);
        RexNode rightPred = context.getRelBuilder().call(FlinkSqlOperatorTable.GREATER_THAN_OR_EQUAL, e1, s0);
        return context.getRelBuilder().call(FlinkSqlOperatorTable.AND, leftPred, rightPred);
    }

    private static RexNode convertPlus(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 2);
        List<RexNode> childrenRexNode = ExpressionConverter.toRexNodes(context, call.getChildren());
        if (TypeCheckUtils.isCharacterString((LogicalType)FlinkTypeFactory.toLogicalType(childrenRexNode.get(0).getType()))) {
            return context.getRelBuilder().call(FlinkSqlOperatorTable.CONCAT, childrenRexNode.get(0), context.getRelBuilder().cast(childrenRexNode.get(1), SqlTypeName.VARCHAR));
        }
        if (TypeCheckUtils.isCharacterString((LogicalType)FlinkTypeFactory.toLogicalType(childrenRexNode.get(1).getType()))) {
            return context.getRelBuilder().call(FlinkSqlOperatorTable.CONCAT, context.getRelBuilder().cast(childrenRexNode.get(0), SqlTypeName.VARCHAR), childrenRexNode.get(1));
        }
        if (TypeCheckUtils.isTimeInterval((LogicalType)FlinkTypeFactory.toLogicalType(childrenRexNode.get(0).getType())) && childrenRexNode.get(0).getType() == childrenRexNode.get(1).getType()) {
            return context.getRelBuilder().call(FlinkSqlOperatorTable.PLUS, (Iterable<? extends RexNode>)childrenRexNode);
        }
        if (TypeCheckUtils.isTimeInterval((LogicalType)FlinkTypeFactory.toLogicalType(childrenRexNode.get(0).getType())) && TypeCheckUtils.isTemporal((LogicalType)FlinkTypeFactory.toLogicalType(childrenRexNode.get(1).getType()))) {
            return context.getRelBuilder().call(FlinkSqlOperatorTable.DATETIME_PLUS, childrenRexNode.get(1), childrenRexNode.get(0));
        }
        if (TypeCheckUtils.isTemporal((LogicalType)FlinkTypeFactory.toLogicalType(childrenRexNode.get(0).getType())) && TypeCheckUtils.isTemporal((LogicalType)FlinkTypeFactory.toLogicalType(childrenRexNode.get(1).getType()))) {
            return context.getRelBuilder().call(FlinkSqlOperatorTable.DATETIME_PLUS, (Iterable<? extends RexNode>)childrenRexNode);
        }
        return context.getRelBuilder().call(FlinkSqlOperatorTable.PLUS, (Iterable<? extends RexNode>)childrenRexNode);
    }

    private static RexNode convertReplace(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 2, 3);
        List children = call.getChildren();
        List<RexNode> childrenRexNode = ExpressionConverter.toRexNodes(context, children);
        if (children.size() == 2) {
            return context.getRelBuilder().call((SqlOperator)FlinkSqlOperatorTable.REPLACE, childrenRexNode.get(0), childrenRexNode.get(1), context.getRelBuilder().call((SqlOperator)FlinkSqlOperatorTable.CHAR_LENGTH, childrenRexNode.get(0)));
        }
        return context.getRelBuilder().call((SqlOperator)FlinkSqlOperatorTable.REPLACE, (Iterable<? extends RexNode>)childrenRexNode);
    }

    private static RexNode convertAs(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 2);
        String name = ExpressionConverter.extractValue((ValueLiteralExpression)call.getChildren().get(1), String.class);
        RexNode child = context.toRexNode((Expression)call.getChildren().get(0));
        return context.getRelBuilder().alias(child, name);
    }

    private static RexNode convertTrim(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        SqlTrimFunction.Flag trimMode2;
        CustomizedConvertRule.checkArgumentNumber(call, 4);
        List children = call.getChildren();
        ValueLiteralExpression removeLeadingExpr = (ValueLiteralExpression)children.get(0);
        Boolean removeLeading = ExpressionConverter.extractValue(removeLeadingExpr, Boolean.class);
        ValueLiteralExpression removeTrailingExpr = (ValueLiteralExpression)children.get(1);
        Boolean removeTrailing = ExpressionConverter.extractValue(removeTrailingExpr, Boolean.class);
        RexNode trimString = context.toRexNode((Expression)children.get(2));
        RexNode str = context.toRexNode((Expression)children.get(3));
        if (removeLeading.booleanValue() && removeTrailing.booleanValue()) {
            trimMode2 = SqlTrimFunction.Flag.BOTH;
        } else if (removeLeading.booleanValue()) {
            trimMode2 = SqlTrimFunction.Flag.LEADING;
        } else if (removeTrailing.booleanValue()) {
            trimMode2 = SqlTrimFunction.Flag.TRAILING;
        } else {
            throw new IllegalArgumentException("Unsupported trim mode.");
        }
        return context.getRelBuilder().call((SqlOperator)FlinkSqlOperatorTable.TRIM, context.getRelBuilder().getRexBuilder().makeFlag(trimMode2), trimString, str);
    }

    private static RexNode convertGet(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 2);
        RexNode child = context.toRexNode((Expression)call.getChildren().get(0));
        ValueLiteralExpression keyLiteral = (ValueLiteralExpression)call.getChildren().get(1);
        Optional<Integer> indexOptional = ExpressionUtils.extractValue((Expression)keyLiteral, String.class).map(child.getType().getFieldNames()::indexOf);
        int index = indexOptional.orElseGet(() -> ExpressionConverter.extractValue(keyLiteral, Integer.class));
        return context.getRelBuilder().getRexBuilder().makeFieldAccess(child, index);
    }

    private static RexNode convertIn(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgument(call, call.getChildren().size() > 1);
        Expression headExpr = (Expression)call.getChildren().get(1);
        if (headExpr instanceof TableReferenceExpression) {
            QueryOperation tableOperation = ((TableReferenceExpression)headExpr).getQueryOperation();
            RexNode child = context.toRexNode((Expression)call.getChildren().get(0));
            return RexSubQuery.in(((FlinkRelBuilder)context.getRelBuilder()).queryOperation(tableOperation).build(), ImmutableList.of(child));
        }
        List<RexNode> child = ExpressionConverter.toRexNodes(context, call.getChildren());
        return context.getRelBuilder().call(FlinkSqlOperatorTable.IN, (Iterable<? extends RexNode>)child);
    }

    private static RexNode convertReinterpretCast(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 3);
        RexNode child = context.toRexNode((Expression)call.getChildren().get(0));
        TypeLiteralExpression type = (TypeLiteralExpression)call.getChildren().get(1);
        RexNode checkOverflow = context.toRexNode((Expression)call.getChildren().get(2));
        return context.getRelBuilder().getRexBuilder().makeReinterpretCast(context.getTypeFactory().createFieldTypeFromLogicalType(type.getOutputDataType().getLogicalType().copy(child.getType().isNullable())), child, checkOverflow);
    }

    private static RexNode convertSqrt(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 1);
        return context.getRelBuilder().call((SqlOperator)FlinkSqlOperatorTable.POWER, (Iterable<? extends RexNode>)ExpressionConverter.toRexNodes(context, Arrays.asList((Expression)call.getChildren().get(0), ApiExpressionUtils.valueLiteral((Object)0.5))));
    }

    private static RexNode convertThrowException(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        CustomizedConvertRule.checkArgumentNumber(call, 2);
        DataType type = ((TypeLiteralExpression)call.getChildren().get(1)).getOutputDataType();
        SqlThrowExceptionFunction function = new SqlThrowExceptionFunction(context.getTypeFactory().createFieldTypeFromLogicalType(LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)type)));
        return context.getRelBuilder().call((SqlOperator)function, context.toRexNode((Expression)call.getChildren().get(0)));
    }

    private static void checkArgumentNumber(CallExpression call, int ... numbers) {
        boolean find = false;
        for (int number : numbers) {
            if (call.getChildren().size() != number) continue;
            find = true;
            break;
        }
        CustomizedConvertRule.checkArgument(call, find);
    }

    private static void checkArgument(CallExpression call, boolean check) {
        if (!check) {
            throw new TableException("Invalid arguments for call: " + call);
        }
    }

    static {
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.CAST, CustomizedConvertRule::convertCast);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.REINTERPRET_CAST, CustomizedConvertRule::convertReinterpretCast);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.IN, CustomizedConvertRule::convertIn);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.GET, CustomizedConvertRule::convertGet);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.TRIM, CustomizedConvertRule::convertTrim);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.AS, CustomizedConvertRule::convertAs);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.BETWEEN, CustomizedConvertRule::convertBetween);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.NOT_BETWEEN, CustomizedConvertRule::convertNotBetween);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.REPLACE, CustomizedConvertRule::convertReplace);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.PLUS, CustomizedConvertRule::convertPlus);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.CEIL, CustomizedConvertRule::convertCeil);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.FLOOR, CustomizedConvertRule::convertFloor);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.TEMPORAL_OVERLAPS, CustomizedConvertRule::convertTemporalOverlaps);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.TIMESTAMP_DIFF, CustomizedConvertRule::convertTimestampDiff);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.ARRAY, CustomizedConvertRule::convertArray);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.MAP, CustomizedConvertRule::convertMap);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.ROW, CustomizedConvertRule::convertRow);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.ORDER_ASC, CustomizedConvertRule::convertOrderAsc);
        DEFINITION_RULE_MAP.put((FunctionDefinition)BuiltInFunctionDefinitions.SQRT, CustomizedConvertRule::convertSqrt);
        DEFINITION_RULE_MAP.put((FunctionDefinition)InternalFunctionDefinitions.THROW_EXCEPTION, CustomizedConvertRule::convertThrowException);
    }

    private static interface Conversion {
        public RexNode convert(CallExpression var1, CallExpressionConvertRule.ConvertContext var2);
    }
}

