/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.BooleanSerializer;
import org.apache.flink.api.common.typeutils.base.ByteSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.FloatSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.ShortSerializer;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.dataview.MapViewSerializer;
import org.apache.flink.table.dataview.MapViewTypeInfo;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.runtime.typeutils.DecimalDataSerializer;
import org.apache.flink.table.runtime.typeutils.DecimalDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.StringDataSerializer;
import org.apache.flink.table.runtime.typeutils.StringDataTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TypeInformationRawType;

public abstract class FirstValueWithRetractAggFunction<T>
extends AggregateFunction<T, GenericRowData> {
    public GenericRowData createAccumulator() {
        GenericRowData acc = new GenericRowData(4);
        acc.setField(0, null);
        acc.setField(1, null);
        acc.setField(2, (Object)RawValueData.fromObject((Object)new MapView(this.getResultType(), (TypeInformation)new ListTypeInfo(Types.LONG))));
        acc.setField(3, (Object)RawValueData.fromObject((Object)new MapView(Types.LONG, (TypeInformation)new ListTypeInfo(this.getResultType()))));
        return acc;
    }

    public void accumulate(GenericRowData acc, Object value) throws Exception {
        if (value != null) {
            Object v = value;
            Long order = System.currentTimeMillis();
            MapView<T, List<Long>> valueToOrderMapView = this.getValueToOrderMapViewFromAcc(acc);
            ArrayList<Long> orderList = (ArrayList<Long>)valueToOrderMapView.get(v);
            if (orderList == null) {
                orderList = new ArrayList<Long>();
            }
            orderList.add(order);
            valueToOrderMapView.put(v, orderList);
            this.accumulate(acc, value, order);
        }
    }

    public void accumulate(GenericRowData acc, Object value, Long order) throws Exception {
        if (value != null) {
            MapView<Long, List<T>> orderToValueMapView;
            ArrayList<Object> valueList;
            Object v = value;
            Long prevOrder = (Long)acc.getField(1);
            if (prevOrder == null || prevOrder > order) {
                acc.setField(0, v);
                acc.setField(1, (Object)order);
            }
            if ((valueList = (ArrayList<Object>)(orderToValueMapView = this.getOrderToValueMapViewFromAcc(acc)).get((Object)order)) == null) {
                valueList = new ArrayList<Object>();
            }
            valueList.add(v);
            orderToValueMapView.put((Object)order, valueList);
        }
    }

    public void retract(GenericRowData acc, Object value) throws Exception {
        if (value != null) {
            Object v = value;
            MapView<T, List<Long>> valueToOrderMapView = this.getValueToOrderMapViewFromAcc(acc);
            List orderList = (List)valueToOrderMapView.get(v);
            if (orderList != null && orderList.size() > 0) {
                Long order = (Long)orderList.get(0);
                orderList.remove(0);
                if (orderList.isEmpty()) {
                    valueToOrderMapView.remove(v);
                } else {
                    valueToOrderMapView.put(v, (Object)orderList);
                }
                this.retract(acc, value, order);
            }
        }
    }

    public void retract(GenericRowData acc, Object value, Long order) throws Exception {
        if (value != null) {
            Object v = value;
            MapView<Long, List<T>> orderToValueMapView = this.getOrderToValueMapViewFromAcc(acc);
            List valueList = (List)orderToValueMapView.get((Object)order);
            if (valueList == null) {
                return;
            }
            int index = valueList.indexOf(v);
            if (index >= 0) {
                valueList.remove(index);
                if (valueList.isEmpty()) {
                    orderToValueMapView.remove((Object)order);
                } else {
                    orderToValueMapView.put((Object)order, (Object)valueList);
                }
            }
            if (v.equals(acc.getField(0))) {
                Long startKey = (Long)acc.getField(1);
                Iterator iter = orderToValueMapView.keys().iterator();
                Long nextKey = Long.MAX_VALUE;
                while (iter.hasNext()) {
                    Long key = (Long)iter.next();
                    if (key < startKey || key >= nextKey) continue;
                    nextKey = key;
                }
                if (nextKey != Long.MAX_VALUE) {
                    acc.setField(0, ((List)orderToValueMapView.get((Object)nextKey)).get(0));
                    acc.setField(1, (Object)nextKey);
                } else {
                    acc.setField(0, null);
                    acc.setField(1, null);
                }
            }
        }
    }

    public void resetAccumulator(GenericRowData acc) {
        acc.setField(0, null);
        acc.setField(1, null);
        MapView<T, List<Long>> valueToOrderMapView = this.getValueToOrderMapViewFromAcc(acc);
        valueToOrderMapView.clear();
        MapView<Long, List<T>> orderToValueMapView = this.getOrderToValueMapViewFromAcc(acc);
        orderToValueMapView.clear();
    }

    public T getValue(GenericRowData acc) {
        return (T)acc.getField(0);
    }

    protected abstract TypeSerializer<T> createValueSerializer();

    public TypeInformation<GenericRowData> getAccumulatorType() {
        LogicalType[] fieldTypes = new LogicalType[]{TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType((TypeInformation)this.getResultType()), new BigIntType(), new TypeInformationRawType((TypeInformation)new MapViewTypeInfo(this.getResultType(), (TypeInformation)new ListTypeInfo(Types.LONG), false, false)), new TypeInformationRawType((TypeInformation)new MapViewTypeInfo(Types.LONG, (TypeInformation)new ListTypeInfo(this.getResultType()), false, false))};
        String[] fieldNames = new String[]{"firstValue", "firstOrder", "valueToOrderMapView", "orderToValueMapView"};
        return new RowDataTypeInfo(fieldTypes, fieldNames);
    }

    private MapView<T, List<Long>> getValueToOrderMapViewFromAcc(GenericRowData acc) {
        RawValueData rawValue = (RawValueData)acc.getField(2);
        return (MapView)rawValue.toObject(this.getValueToOrderMapViewSerializer());
    }

    private MapView<Long, List<T>> getOrderToValueMapViewFromAcc(GenericRowData acc) {
        RawValueData rawValue = (RawValueData)acc.getField(3);
        return (MapView)rawValue.toObject(this.getOrderToValueMapViewSerializer());
    }

    private MapViewSerializer<T, List<Long>> getValueToOrderMapViewSerializer() {
        return new MapViewSerializer((TypeSerializer)new MapSerializer(this.createValueSerializer(), (TypeSerializer)new ListSerializer((TypeSerializer)LongSerializer.INSTANCE)));
    }

    private MapViewSerializer<Long, List<T>> getOrderToValueMapViewSerializer() {
        return new MapViewSerializer((TypeSerializer)new MapSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)new ListSerializer(this.createValueSerializer())));
    }

    public static class StringFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<StringData> {
        public TypeInformation<StringData> getResultType() {
            return StringDataTypeInfo.INSTANCE;
        }

        public void accumulate(GenericRowData acc, StringData value) throws Exception {
            if (value != null) {
                super.accumulate(acc, ((BinaryStringData)value).copy());
            }
        }

        public void accumulate(GenericRowData acc, StringData value, Long order) throws Exception {
            if (value != null) {
                super.accumulate(acc, ((BinaryStringData)value).copy(), order);
            }
        }

        @Override
        protected TypeSerializer<StringData> createValueSerializer() {
            return StringDataSerializer.INSTANCE;
        }
    }

    public static class DecimalFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<DecimalData> {
        private DecimalDataTypeInfo decimalTypeInfo;

        public DecimalFirstValueWithRetractAggFunction(DecimalDataTypeInfo decimalTypeInfo) {
            this.decimalTypeInfo = decimalTypeInfo;
        }

        public void accumulate(GenericRowData acc, DecimalData value) throws Exception {
            super.accumulate(acc, value);
        }

        public void accumulate(GenericRowData acc, DecimalData value, Long order) throws Exception {
            super.accumulate(acc, value, order);
        }

        public TypeInformation<DecimalData> getResultType() {
            return this.decimalTypeInfo;
        }

        @Override
        protected TypeSerializer<DecimalData> createValueSerializer() {
            return new DecimalDataSerializer(this.decimalTypeInfo.precision(), this.decimalTypeInfo.scale());
        }
    }

    public static class BooleanFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Boolean> {
        public TypeInformation<Boolean> getResultType() {
            return Types.BOOLEAN;
        }

        @Override
        protected TypeSerializer<Boolean> createValueSerializer() {
            return BooleanSerializer.INSTANCE;
        }
    }

    public static class DoubleFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Double> {
        public TypeInformation<Double> getResultType() {
            return Types.DOUBLE;
        }

        @Override
        protected TypeSerializer<Double> createValueSerializer() {
            return DoubleSerializer.INSTANCE;
        }
    }

    public static class FloatFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Float> {
        public TypeInformation<Float> getResultType() {
            return Types.FLOAT;
        }

        @Override
        protected TypeSerializer<Float> createValueSerializer() {
            return FloatSerializer.INSTANCE;
        }
    }

    public static class LongFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Long> {
        public TypeInformation<Long> getResultType() {
            return Types.LONG;
        }

        @Override
        protected TypeSerializer<Long> createValueSerializer() {
            return LongSerializer.INSTANCE;
        }
    }

    public static class IntFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Integer> {
        public TypeInformation<Integer> getResultType() {
            return Types.INT;
        }

        @Override
        protected TypeSerializer<Integer> createValueSerializer() {
            return IntSerializer.INSTANCE;
        }
    }

    public static class ShortFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Short> {
        public TypeInformation<Short> getResultType() {
            return Types.SHORT;
        }

        @Override
        protected TypeSerializer<Short> createValueSerializer() {
            return ShortSerializer.INSTANCE;
        }
    }

    public static class ByteFirstValueWithRetractAggFunction
    extends FirstValueWithRetractAggFunction<Byte> {
        public TypeInformation<Byte> getResultType() {
            return Types.BYTE;
        }

        @Override
        protected TypeSerializer<Byte> createValueSerializer() {
            return ByteSerializer.INSTANCE;
        }
    }
}

